/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import corgitaco.betterweather.config.BetterWeatherConfig;
import corgitaco.betterweather.datastorage.BetterWeatherData;
import corgitaco.betterweather.server.BetterWeatherCommand;
import corgitaco.betterweather.weatherevents.AcidRain;
import corgitaco.betterweather.weatherevents.Blizzard;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import me.sargunvohra.mcmods.autoconfig1u.AutoConfig;
import me.sargunvohra.mcmods.autoconfig1u.serializer.JanksonConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v1.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.network.ServerSidePacketRegistry;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1311;
import net.minecraft.class_1928;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3193;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BetterWeather
implements ModInitializer {
    public static Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "betterweather";
    public static BetterWeatherConfig BW_CONFIG;
    public static final class_2960 BW_WEATHER_PACKET;
    public static final class_2960 ACID_RAIN_PACKET;
    static boolean damageAnimals;
    static boolean damageMonsters;
    static boolean damagePlayer;
    public static boolean destroyGrass;
    public static boolean destroyLeaves;
    public static boolean destroyCrops;
    public static boolean destroyPlants;
    public static List<class_2248> blocksToNotDestroyList;
    public static int dataCache;

    public void configReader() {
        String[] blocksToNotDestroyList;
        String[] blockTypeToDestroyList;
        String[] entityList;
        AutoConfig.register(BetterWeatherConfig.class, JanksonConfigSerializer::new);
        BW_CONFIG = (BetterWeatherConfig)AutoConfig.getConfigHolder(BetterWeatherConfig.class).getConfig();
        String entityTypes = BetterWeather.BW_CONFIG.acid_rain.entity.entityTypesToDamage;
        String removeSpaces = entityTypes.trim().toLowerCase().replace(" ", "");
        for (String string : entityList = removeSpaces.split(",")) {
            if (string.equalsIgnoreCase("animal") && !damageAnimals) {
                damageAnimals = true;
            }
            if (string.equalsIgnoreCase("monster") && !damageMonsters) {
                damageMonsters = true;
            }
            if (!string.equalsIgnoreCase("player") || damagePlayer) continue;
            damagePlayer = true;
        }
        String allowedBlockTypesToDestroy = BetterWeather.BW_CONFIG.acid_rain.world.allowedBlocksToDestroy;
        String removeBlockTypeSpaces = allowedBlockTypesToDestroy.trim().toLowerCase().replace(" ", "");
        for (String s : blockTypeToDestroyList = removeBlockTypeSpaces.split(",")) {
            if (s.equalsIgnoreCase("grass") && !destroyGrass) {
                destroyGrass = true;
            }
            if (s.equalsIgnoreCase("leaves") && !destroyLeaves) {
                destroyLeaves = true;
            }
            if (s.equalsIgnoreCase("crops") && !destroyCrops) {
                destroyCrops = true;
            }
            if (!s.equalsIgnoreCase("plants") || destroyCrops) continue;
            destroyPlants = true;
        }
        String string = BetterWeather.BW_CONFIG.acid_rain.world.blocksToNotDestroy;
        String removeBlocksToNotDestroySpaces = string.trim().toLowerCase().replace(" ", "");
        for (String s : blocksToNotDestroyList = removeBlocksToNotDestroySpaces.split(",")) {
            class_2248 block = (class_2248)class_2378.field_11146.method_10223(new class_2960(s));
            if (block != null) {
                BetterWeather.blocksToNotDestroyList.add(block);
                continue;
            }
            LOGGER.error("A block registry name you added to the \"BlocksToNotDestroy\" list was incorrect, you put: " + s + "\n Please fix it or this block will be destroyed.");
        }
    }

    public void onInitialize() {
        this.configReader();
        ServerTickEvents.END_WORLD_TICK.register(event -> BetterWeatherEvents.worldTick(event.method_8410()));
        BetterWeatherEvents.commandRegisterEvent();
    }

    static {
        BW_WEATHER_PACKET = new class_2960(MOD_ID, "blizzard_update");
        ACID_RAIN_PACKET = new class_2960(MOD_ID, "acid_rain_update");
        damageAnimals = false;
        damageMonsters = false;
        damagePlayer = false;
        destroyGrass = false;
        destroyLeaves = false;
        destroyCrops = false;
        destroyPlants = false;
        blocksToNotDestroyList = new ArrayList<class_2248>();
        dataCache = 0;
    }

    public static enum WeatherType {
        BLIZZARD,
        HAIL,
        HEATWAVE,
        WINDSTORM,
        SANDSTORM,
        ACIDRAIN;

    }

    public static class BetterWeatherEvents {
        public static BetterWeatherData weatherData = null;

        public static void worldTick(class_1937 world) {
            Random random;
            BetterWeatherEvents.setWeatherData((class_1936)world);
            class_3218 serverWorld = (class_3218)world;
            int tickSpeed = world.method_8450().method_8356(class_1928.field_19399);
            long worldTime = world.method_8401().method_188();
            if (worldTime == 100L || worldTime % 24000L == 0L && !world.method_8401().method_156()) {
                random = world.field_9229;
                weatherData.setAcidRain((double)random.nextFloat() < BetterWeather.BW_CONFIG.acid_rain.world.acidRainChance);
                weatherData.setBlizzard(false);
            }
            if (worldTime == 100L || worldTime % 24000L == 0L && !world.method_8401().method_156()) {
                random = world.field_9229;
                weatherData.setBlizzard((double)random.nextFloat() + 0.05 < BetterWeather.BW_CONFIG.blizzard.world.snow_generation.blizzardChance);
                weatherData.setAcidRain(false);
            }
            if (world.method_8401().method_156()) {
                if (dataCache == 0) {
                    ++dataCache;
                }
            } else if (dataCache != 0) {
                if (weatherData.isBlizzard()) {
                    weatherData.setBlizzard(false);
                }
                if (weatherData.isAcidRain()) {
                    weatherData.setAcidRain(false);
                }
            }
            ArrayList list = Lists.newArrayList((Iterable)serverWorld.method_14178().field_17254.method_17264());
            list.forEach(chunkHolder -> {
                Optional optional1;
                Optional optional = chunkHolder.method_16145().getNow(class_3193.field_16427).left();
                if (optional.isPresent() && (optional1 = chunkHolder.method_14003().getNow(class_3193.field_16427).left()).isPresent()) {
                    class_2818 chunk = (class_2818)optional1.get();
                    Blizzard.blizzardEvent(chunk, (class_1937)serverWorld, tickSpeed, worldTime);
                    if (BetterWeather.BW_CONFIG.blizzard.world.snow_decay.decaySnowAndIce) {
                        Blizzard.doesIceAndSnowDecay(chunk, (class_1937)serverWorld, worldTime);
                    }
                    AcidRain.acidRainEvent(chunk, serverWorld, tickSpeed, worldTime);
                }
            });
            class_2540 passedData = new class_2540(Unpooled.buffer());
            passedData.writeBoolean(weatherData.isBlizzard());
            passedData.writeBoolean(weatherData.isAcidRain());
            if (serverWorld.method_8401().method_188() % 5L == 0L) {
                world.method_18456().forEach(player -> ServerSidePacketRegistry.INSTANCE.sendToPlayer(player, BW_WEATHER_PACKET, passedData));
            }
        }

        public static void entityTickEvent(class_1297 entity) {
            class_2338 entityPos;
            class_1937 world;
            if (entity.field_6002 != null) {
                BetterWeatherEvents.setWeatherData((class_1936)entity.field_6002);
            }
            if (damageMonsters && entity.method_5864().method_5891() == class_1311.field_6302 && (world = entity.field_6002).method_8311(entityPos = new class_2338(entity.method_23317(), entity.method_23318(), entity.method_23321())) && weatherData.isAcidRain() && world.method_8401().method_156() && world.method_8510() % (long)BetterWeather.BW_CONFIG.acid_rain.entity.entityDamageTickSpeed == 0L) {
                entity.method_5643(class_1282.field_5869, (float)BetterWeather.BW_CONFIG.acid_rain.entity.damageStrength);
            }
            if (damageAnimals && (entity.method_5864().method_5891() == class_1311.field_6294 || entity.method_5864().method_5891() == class_1311.field_6303) && (world = entity.field_6002).method_8311(entityPos = new class_2338(entity.method_23317(), entity.method_23318(), entity.method_23321())) && weatherData.isAcidRain() && world.method_8401().method_156() && world.method_8510() % (long)BetterWeather.BW_CONFIG.acid_rain.entity.entityDamageTickSpeed == 0L) {
                entity.method_5643(class_1282.field_5869, (float)BetterWeather.BW_CONFIG.acid_rain.entity.damageStrength);
            }
            if (damagePlayer && entity instanceof class_3222 && (world = entity.field_6002).method_8311(entityPos = new class_2338(entity.method_23317(), entity.method_23318(), entity.method_23321())) && weatherData.isAcidRain() && world.method_8401().method_156() && world.method_8510() % (long)BetterWeather.BW_CONFIG.acid_rain.entity.entityDamageTickSpeed == 0L) {
                entity.method_5643(class_1282.field_5869, (float)BetterWeather.BW_CONFIG.acid_rain.entity.damageStrength);
            }
            Blizzard.blizzardEntityHandler(entity);
        }

        public static void commandRegisterEvent() {
            CommandRegistrationCallback.EVENT.register((dispatcher, dedicated) -> BetterWeatherCommand.register((CommandDispatcher<class_2168>)dispatcher));
            LOGGER.info("BW: \"Server Starting\" Event Complete!");
        }

        public static void setWeatherData(class_1936 world) {
            if (weatherData == null) {
                weatherData = BetterWeatherData.get(world);
            }
        }
    }
}

