/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.bakedmodels;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.pianomanu.blockcarpentry.block.FrameBlock;
import mod.pianomanu.blockcarpentry.tileentity.FrameBlockTile;
import mod.pianomanu.blockcarpentry.util.ModelHelper;
import mod.pianomanu.blockcarpentry.util.TextureHelper;
import net.minecraft.block.BlockState;
import net.minecraft.block.GrassBlock;
import net.minecraft.block.LadderBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;

public class IllusionLadderBakedModel
implements IDynamicBakedModel {
    public static final ResourceLocation TEXTURE = new ResourceLocation("minecraft", "block/oak_planks");

    private TextureAtlasSprite getTexture() {
        return (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(TEXTURE);
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        ModelResourceLocation location;
        BlockState mimic = (BlockState)extraData.getData(FrameBlockTile.MIMIC);
        if (mimic != null && !(mimic.func_177230_c() instanceof FrameBlock) && (location = BlockModelShapes.func_209554_c((BlockState)mimic)) != null) {
            IBakedModel model = Minecraft.func_71410_x().func_209506_al().func_174953_a(location);
            model.getBakedModel().getQuads(mimic, side, rand, extraData);
            if (model != null) {
                return this.getMimicQuads(state, side, rand, extraData, model);
            }
        }
        return Collections.emptyList();
    }

    public List<BakedQuad> getMimicQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData, IBakedModel model) {
        if (side != null) {
            return Collections.emptyList();
        }
        BlockState mimic = (BlockState)extraData.getData(FrameBlockTile.MIMIC);
        if (mimic != null && state != null) {
            int overlayIndex;
            List<TextureAtlasSprite> textureList = TextureHelper.getTextureFromModel(model, extraData, rand);
            ArrayList<TextureAtlasSprite> designTextureList = new ArrayList<TextureAtlasSprite>();
            if (textureList.size() == 0) {
                if (Minecraft.func_71410_x().field_71439_g != null) {
                    Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new TranslationTextComponent("We're sorry, but this block can't be displayed", new Object[0]), true);
                }
                return Collections.emptyList();
            }
            designTextureList.add(textureList.get(0));
            designTextureList.addAll(TextureHelper.getMetalTextures());
            int tintIndex = -1;
            if (mimic.func_177230_c() instanceof GrassBlock) {
                tintIndex = 1;
            }
            int design = (Integer)extraData.getData(FrameBlockTile.DESIGN);
            int desTex = (Integer)extraData.getData(FrameBlockTile.DESIGN_TEXTURE);
            TextureAtlasSprite designTexture = (TextureAtlasSprite)designTextureList.get(desTex);
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            if (design == 5) {
                switch ((Direction)state.func_177229_b((IProperty)LadderBlock.field_176382_a)) {
                    case WEST: {
                        return new ArrayList<BakedQuad>(ModelHelper.createSixFaceCuboid(0.8125f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex));
                    }
                    case SOUTH: {
                        return new ArrayList<BakedQuad>(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.1875f, mimic, model, extraData, rand, tintIndex));
                    }
                    case NORTH: {
                        return new ArrayList<BakedQuad>(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.0f, 1.0f, 0.8125f, 1.0f, mimic, model, extraData, rand, tintIndex));
                    }
                    case EAST: {
                        return new ArrayList<BakedQuad>(ModelHelper.createSixFaceCuboid(0.0f, 0.1875f, 0.0f, 1.0f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex));
                    }
                }
            }
            if (design == 0 || design == 1 || design == 2) {
                switch ((Direction)state.func_177229_b((IProperty)LadderBlock.field_176382_a)) {
                    case WEST: {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.8125f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0625f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.8125f, 1.0f, 0.0f, 1.0f, 0.9375f, 1.0f, mimic, model, extraData, rand, tintIndex));
                        break;
                    }
                    case SOUTH: {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.0625f, 0.0f, 1.0f, 0.0f, 0.1875f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.9375f, 1.0f, 0.0f, 1.0f, 0.0f, 0.1875f, mimic, model, extraData, rand, tintIndex));
                        break;
                    }
                    case NORTH: {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.0625f, 0.0f, 1.0f, 0.8125f, 1.0f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.9375f, 1.0f, 0.0f, 1.0f, 0.8125f, 1.0f, mimic, model, extraData, rand, tintIndex));
                        break;
                    }
                    case EAST: {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.1875f, 0.0f, 1.0f, 0.0f, 0.0625f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.1875f, 0.0f, 1.0f, 0.9375f, 1.0f, mimic, model, extraData, rand, tintIndex));
                    }
                }
            }
            if (design == 0 || design == 1) {
                switch ((Direction)state.func_177229_b((IProperty)LadderBlock.field_176382_a)) {
                    case WEST: {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.8125f, 1.0f, 0.125f, 0.1875f, 0.0625f, 0.9375f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.8125f, 1.0f, 0.375f, 0.4375f, 0.0625f, 0.9375f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.8125f, 1.0f, 0.625f, 0.6875f, 0.0625f, 0.9375f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.8125f, 1.0f, 0.875f, 0.9375f, 0.0625f, 0.9375f, mimic, model, extraData, rand, tintIndex));
                        break;
                    }
                    case SOUTH: {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.9375f, 0.125f, 0.1875f, 0.0f, 0.1875f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.9375f, 0.375f, 0.4375f, 0.0f, 0.1875f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.9375f, 0.625f, 0.6875f, 0.0f, 0.1875f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.9375f, 0.875f, 0.9375f, 0.0f, 0.1875f, mimic, model, extraData, rand, tintIndex));
                        break;
                    }
                    case NORTH: {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.9375f, 0.125f, 0.1875f, 0.8125f, 1.0f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.9375f, 0.375f, 0.4375f, 0.8125f, 1.0f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.9375f, 0.625f, 0.6875f, 0.8125f, 1.0f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.9375f, 0.875f, 0.9375f, 0.8125f, 1.0f, mimic, model, extraData, rand, tintIndex));
                        break;
                    }
                    case EAST: {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.1875f, 0.125f, 0.1875f, 0.0625f, 0.9375f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.1875f, 0.375f, 0.4375f, 0.0625f, 0.9375f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.1875f, 0.625f, 0.6875f, 0.0625f, 0.9375f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.1875f, 0.875f, 0.9375f, 0.0625f, 0.9375f, mimic, model, extraData, rand, tintIndex));
                    }
                }
            }
            if (design == 1) {
                switch ((Direction)state.func_177229_b((IProperty)LadderBlock.field_176382_a)) {
                    case WEST: {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.8125f, 1.0f, 0.0f, 0.0625f, 0.0625f, 0.9375f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.8125f, 1.0f, 0.25f, 0.3125f, 0.0625f, 0.9375f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.8125f, 1.0f, 0.5f, 0.5625f, 0.0625f, 0.9375f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.8125f, 1.0f, 0.75f, 0.8125f, 0.0625f, 0.9375f, mimic, model, extraData, rand, tintIndex));
                        break;
                    }
                    case SOUTH: {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.9375f, 0.0f, 0.0625f, 0.0f, 0.1875f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.9375f, 0.25f, 0.3125f, 0.0f, 0.1875f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.9375f, 0.5f, 0.5625f, 0.0f, 0.1875f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.9375f, 0.75f, 0.8125f, 0.0f, 0.1875f, mimic, model, extraData, rand, tintIndex));
                        break;
                    }
                    case NORTH: {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.9375f, 0.0f, 0.0625f, 0.8125f, 1.0f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.9375f, 0.25f, 0.3125f, 0.8125f, 1.0f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.9375f, 0.5f, 0.5625f, 0.8125f, 1.0f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.9375f, 0.75f, 0.8125f, 0.8125f, 1.0f, mimic, model, extraData, rand, tintIndex));
                        break;
                    }
                    case EAST: {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.1875f, 0.0f, 0.0625f, 0.0625f, 0.9375f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.1875f, 0.25f, 0.3125f, 0.0625f, 0.9375f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.1875f, 0.5f, 0.5625f, 0.0625f, 0.9375f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.1875f, 0.75f, 0.8125f, 0.0625f, 0.9375f, mimic, model, extraData, rand, tintIndex));
                    }
                }
            }
            if (design == 2) {
                switch ((Direction)state.func_177229_b((IProperty)LadderBlock.field_176382_a)) {
                    case WEST: {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.8125f, 1.0f, 0.0625f, 0.1875f, 0.0625f, 0.9375f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.8125f, 1.0f, 0.3125f, 0.4375f, 0.0625f, 0.9375f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.8125f, 1.0f, 0.5625f, 0.6875f, 0.0625f, 0.9375f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.8125f, 1.0f, 0.8125f, 0.9375f, 0.0625f, 0.9375f, mimic, model, extraData, rand, tintIndex));
                        break;
                    }
                    case SOUTH: {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.9375f, 0.0625f, 0.1875f, 0.0f, 0.1875f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.9375f, 0.3125f, 0.4375f, 0.0f, 0.1875f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.9375f, 0.5625f, 0.6875f, 0.0f, 0.1875f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.9375f, 0.8125f, 0.9375f, 0.0f, 0.1875f, mimic, model, extraData, rand, tintIndex));
                        break;
                    }
                    case NORTH: {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.9375f, 0.0625f, 0.1875f, 0.8125f, 1.0f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.9375f, 0.3125f, 0.4375f, 0.8125f, 1.0f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.9375f, 0.5625f, 0.6875f, 0.8125f, 1.0f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.9375f, 0.8125f, 0.9375f, 0.8125f, 1.0f, mimic, model, extraData, rand, tintIndex));
                        break;
                    }
                    case EAST: {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.1875f, 0.0625f, 0.1875f, 0.0625f, 0.9375f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.1875f, 0.3125f, 0.4375f, 0.0625f, 0.9375f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.1875f, 0.5625f, 0.6875f, 0.0625f, 0.9375f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.1875f, 0.8125f, 0.9375f, 0.0625f, 0.9375f, mimic, model, extraData, rand, tintIndex));
                    }
                }
            }
            if (design == 3) {
                switch ((Direction)state.func_177229_b((IProperty)LadderBlock.field_176382_a)) {
                    case WEST: {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.8125f, 1.0f, 0.0625f, 0.1875f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.8125f, 1.0f, 0.3125f, 0.4375f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.8125f, 1.0f, 0.5625f, 0.6875f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.8125f, 1.0f, 0.8125f, 0.9375f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.875f, 1.0f, 0.0f, 1.0f, 0.125f, 0.25f, designTexture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.875f, 1.0f, 0.0f, 1.0f, 0.75f, 0.875f, designTexture, tintIndex));
                        break;
                    }
                    case SOUTH: {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.0625f, 0.1875f, 0.0f, 0.1875f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.3125f, 0.4375f, 0.0f, 0.1875f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.5625f, 0.6875f, 0.0f, 0.1875f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.8125f, 0.9375f, 0.0f, 0.1875f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.125f, 0.25f, 0.0f, 1.0f, 0.0f, 0.125f, designTexture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.75f, 0.875f, 0.0f, 1.0f, 0.0f, 0.125f, designTexture, tintIndex));
                        break;
                    }
                    case NORTH: {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.0625f, 0.1875f, 0.8125f, 1.0f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.3125f, 0.4375f, 0.8125f, 1.0f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.5625f, 0.6875f, 0.8125f, 1.0f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.8125f, 0.9375f, 0.8125f, 1.0f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.125f, 0.25f, 0.0f, 1.0f, 0.875f, 1.0f, designTexture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.75f, 0.875f, 0.0f, 1.0f, 0.875f, 1.0f, designTexture, tintIndex));
                        break;
                    }
                    case EAST: {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.1875f, 0.0625f, 0.1875f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.1875f, 0.3125f, 0.4375f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.1875f, 0.5625f, 0.6875f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.1875f, 0.8125f, 0.9375f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.125f, 0.0f, 1.0f, 0.125f, 0.25f, designTexture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.125f, 0.0f, 1.0f, 0.75f, 0.875f, designTexture, tintIndex));
                    }
                }
            }
            if (design == 4) {
                switch ((Direction)state.func_177229_b((IProperty)LadderBlock.field_176382_a)) {
                    case WEST: {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.8125f, 0.875f, 0.0625f, 0.1875f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.8125f, 0.875f, 0.3125f, 0.4375f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.8125f, 0.875f, 0.5625f, 0.6875f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.8125f, 0.875f, 0.8125f, 0.9375f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.875f, 1.0f, 0.0f, 1.0f, 0.125f, 0.25f, designTexture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.875f, 1.0f, 0.0f, 1.0f, 0.75f, 0.875f, designTexture, tintIndex));
                        break;
                    }
                    case SOUTH: {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.0625f, 0.1875f, 0.125f, 0.1875f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.3125f, 0.4375f, 0.125f, 0.1875f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.5625f, 0.6875f, 0.125f, 0.1875f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.8125f, 0.9375f, 0.125f, 0.1875f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.125f, 0.25f, 0.0f, 1.0f, 0.0f, 0.125f, designTexture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.75f, 0.875f, 0.0f, 1.0f, 0.0f, 0.125f, designTexture, tintIndex));
                        break;
                    }
                    case NORTH: {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.0625f, 0.1875f, 0.8125f, 0.875f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.3125f, 0.4375f, 0.8125f, 0.875f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.5625f, 0.6875f, 0.8125f, 0.875f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.8125f, 0.9375f, 0.8125f, 0.875f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.125f, 0.25f, 0.0f, 1.0f, 0.875f, 1.0f, designTexture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.75f, 0.875f, 0.0f, 1.0f, 0.875f, 1.0f, designTexture, tintIndex));
                        break;
                    }
                    case EAST: {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.125f, 0.1875f, 0.0625f, 0.1875f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.125f, 0.1875f, 0.3125f, 0.4375f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.125f, 0.1875f, 0.5625f, 0.6875f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.125f, 0.1875f, 0.8125f, 0.9375f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.125f, 0.0f, 1.0f, 0.125f, 0.25f, designTexture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.125f, 0.0f, 1.0f, 0.75f, 0.875f, designTexture, tintIndex));
                    }
                }
            }
            if ((overlayIndex = ((Integer)extraData.getData(FrameBlockTile.OVERLAY)).intValue()) != 0) {
                switch ((Direction)state.func_177229_b((IProperty)LadderBlock.field_176382_a)) {
                    case NORTH: {
                        quads.addAll(ModelHelper.createOverlay(0.0f, 1.0f, 0.0f, 1.0f, 0.8125f, 1.0f, overlayIndex));
                        break;
                    }
                    case WEST: {
                        quads.addAll(ModelHelper.createOverlay(0.8125f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, overlayIndex));
                        break;
                    }
                    case EAST: {
                        quads.addAll(ModelHelper.createOverlay(0.0f, 0.1875f, 0.0f, 1.0f, 0.0f, 1.0f, overlayIndex));
                        break;
                    }
                    case SOUTH: {
                        quads.addAll(ModelHelper.createOverlay(0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.1875f, overlayIndex));
                    }
                }
            }
            return quads;
        }
        return Collections.emptyList();
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.getTexture();
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }
}

