/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.bakedmodels;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.pianomanu.blockcarpentry.block.FrameBlock;
import mod.pianomanu.blockcarpentry.tileentity.FrameBlockTile;
import mod.pianomanu.blockcarpentry.util.ModelHelper;
import mod.pianomanu.blockcarpentry.util.TextureHelper;
import net.minecraft.block.BlockState;
import net.minecraft.block.GrassBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;

public class PressurePlateFrameBakedModel
implements IDynamicBakedModel {
    public static final ResourceLocation TEXTURE = new ResourceLocation("minecraft", "block/oak_planks");

    private TextureAtlasSprite getTexture() {
        return (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(TEXTURE);
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        ModelResourceLocation location;
        BlockState mimic = (BlockState)extraData.getData(FrameBlockTile.MIMIC);
        if (mimic != null && !(mimic.func_177230_c() instanceof FrameBlock) && (location = BlockModelShapes.func_209554_c((BlockState)mimic)) != null) {
            IBakedModel model = Minecraft.func_71410_x().func_209506_al().func_174953_a(location);
            model.getBakedModel().getQuads(mimic, side, rand, extraData);
            if (model != null) {
                return this.getMimicQuads(state, side, rand, extraData, model);
            }
        }
        return Collections.emptyList();
    }

    public List<BakedQuad> getMimicQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData, IBakedModel model) {
        if (side != null) {
            return Collections.emptyList();
        }
        BlockState mimic = (BlockState)extraData.getData(FrameBlockTile.MIMIC);
        int tex = (Integer)extraData.getData(FrameBlockTile.TEXTURE);
        if (mimic != null) {
            List<TextureAtlasSprite> textureList = TextureHelper.getTextureFromModel(model, extraData, rand);
            if (textureList.size() <= tex) {
                extraData.setData(FrameBlockTile.TEXTURE, (Object)0);
                tex = 0;
            }
            if (textureList.size() == 0) {
                if (Minecraft.func_71410_x().field_71439_g != null) {
                    Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new TranslationTextComponent("We're sorry, but this block can't be displayed", new Object[0]), true);
                }
                return Collections.emptyList();
            }
            TextureAtlasSprite texture = textureList.get(tex);
            int tintIndex = -1;
            if (mimic.func_177230_c() instanceof GrassBlock) {
                tintIndex = 1;
            }
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.0f, 0.0625f, 0.0625f, 0.9375f, texture, tintIndex));
            int overlayIndex = (Integer)extraData.getData(FrameBlockTile.OVERLAY);
            if (overlayIndex != 0) {
                quads.addAll(ModelHelper.createOverlay(0.0625f, 0.9375f, 0.0f, 0.0625f, 0.0625f, 0.9375f, overlayIndex));
            }
            return quads;
        }
        return Collections.emptyList();
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.getTexture();
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }
}

