/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.bakedmodels.helper;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;

public class HandleBakedModel {
    private static void putVertex(BakedQuadBuilder builder, Vec3d normal, double x, double y, double z, float u, float v, TextureAtlasSprite sprite, float r, float g, float b) {
        ImmutableList elements = builder.getVertexFormat().func_227894_c_().asList();
        block10: for (int j = 0; j < elements.size(); ++j) {
            VertexFormatElement e = (VertexFormatElement)elements.get(j);
            switch (e.func_177375_c()) {
                case POSITION: {
                    builder.put(j, new float[]{(float)x, (float)y, (float)z, 1.0f});
                    continue block10;
                }
                case COLOR: {
                    builder.put(j, new float[]{r, g, b, 1.0f});
                    continue block10;
                }
                case UV: {
                    switch (e.func_177369_e()) {
                        case 0: {
                            float iu = sprite.func_94214_a((double)u);
                            float iv = sprite.func_94207_b((double)v);
                            builder.put(j, new float[]{iu, iv});
                            continue block10;
                        }
                        case 2: {
                            builder.put(j, new float[]{0.0f, 0.0f});
                            continue block10;
                        }
                    }
                    builder.put(j, new float[0]);
                    continue block10;
                }
                case NORMAL: {
                    builder.put(j, new float[]{(float)normal.field_72450_a, (float)normal.field_72448_b, (float)normal.field_72449_c});
                    continue block10;
                }
                default: {
                    builder.put(j, new float[0]);
                }
            }
        }
        builder.setApplyDiffuseLighting(true);
    }

    private static BakedQuad create5x4Quad(Vec3d v1, Vec3d v2, Vec3d v3, Vec3d v4, TextureAtlasSprite sprite, int flag) {
        Vec3d normal = v3.func_178788_d(v2).func_72431_c(v1.func_178788_d(v2)).func_72432_b();
        BakedQuadBuilder builder = new BakedQuadBuilder(sprite);
        builder.setQuadOrientation(Direction.func_210769_a((double)normal.field_72450_a, (double)normal.field_72448_b, (double)normal.field_72449_c));
        builder.setApplyDiffuseLighting(true);
        float ul = 0.0f;
        float uh = 5.0f;
        float vl = 0.0f;
        float vh = 4.0f;
        if (flag == 0) {
            uh = 1.0f;
        } else if (flag == 1) {
            uh = 4.0f;
            vh = 1.0f;
        } else if (flag == 2) {
            uh = 4.0f;
            vh = 5.0f;
        }
        HandleBakedModel.putVertex(builder, normal, v1.field_72450_a, v1.field_72448_b, v1.field_72449_c, ul, vl, sprite, 1.0f, 1.0f, 1.0f);
        HandleBakedModel.putVertex(builder, normal, v2.field_72450_a, v2.field_72448_b, v2.field_72449_c, ul, vh, sprite, 1.0f, 1.0f, 1.0f);
        HandleBakedModel.putVertex(builder, normal, v3.field_72450_a, v3.field_72448_b, v3.field_72449_c, uh, vh, sprite, 1.0f, 1.0f, 1.0f);
        HandleBakedModel.putVertex(builder, normal, v4.field_72450_a, v4.field_72448_b, v4.field_72449_c, uh, vl, sprite, 1.0f, 1.0f, 1.0f);
        return builder.build();
    }

    private static BakedQuad create1x4Quad(Vec3d v1, Vec3d v2, Vec3d v3, Vec3d v4, TextureAtlasSprite sprite, int flag) {
        Vec3d normal = v3.func_178788_d(v2).func_72431_c(v1.func_178788_d(v2)).func_72432_b();
        BakedQuadBuilder builder = new BakedQuadBuilder(sprite);
        builder.setQuadOrientation(Direction.func_210769_a((double)normal.field_72450_a, (double)normal.field_72448_b, (double)normal.field_72449_c));
        builder.setApplyDiffuseLighting(true);
        float ul = 0.0f;
        float uh = 4.0f;
        float vl = 0.0f;
        float vh = 1.0f;
        if (flag == 3) {
            uh = 5.0f;
            vh = 1.0f;
        } else if (flag == 1) {
            uh = 4.0f;
            vh = 5.0f;
        } else if (flag == 2) {
            uh = 4.0f;
            vh = 1.0f;
        } else if (flag == 0) {
            uh = 1.0f;
            vh = 5.0f;
        }
        HandleBakedModel.putVertex(builder, normal, v1.field_72450_a, v1.field_72448_b, v1.field_72449_c, ul, vl, sprite, 1.0f, 1.0f, 1.0f);
        HandleBakedModel.putVertex(builder, normal, v2.field_72450_a, v2.field_72448_b, v2.field_72449_c, ul, vh, sprite, 1.0f, 1.0f, 1.0f);
        HandleBakedModel.putVertex(builder, normal, v3.field_72450_a, v3.field_72448_b, v3.field_72449_c, uh, vh, sprite, 1.0f, 1.0f, 1.0f);
        HandleBakedModel.putVertex(builder, normal, v4.field_72450_a, v4.field_72448_b, v4.field_72449_c, uh, vl, sprite, 1.0f, 1.0f, 1.0f);
        return builder.build();
    }

    private static BakedQuad create1x5Quad(Vec3d v1, Vec3d v2, Vec3d v3, Vec3d v4, TextureAtlasSprite sprite, int flag) {
        Vec3d normal = v3.func_178788_d(v2).func_72431_c(v1.func_178788_d(v2)).func_72432_b();
        BakedQuadBuilder builder = new BakedQuadBuilder(sprite);
        builder.setQuadOrientation(Direction.func_210769_a((double)normal.field_72450_a, (double)normal.field_72448_b, (double)normal.field_72449_c));
        builder.setApplyDiffuseLighting(true);
        float ul = 0.0f;
        float uh = 1.0f;
        float vl = 0.0f;
        float vh = 5.0f;
        if (flag == 3) {
            vh = 4.0f;
        } else if (flag == 1) {
            uh = 4.0f;
            vh = 1.0f;
        } else if (flag == 0) {
            vh = 4.0f;
            uh = 5.0f;
        }
        HandleBakedModel.putVertex(builder, normal, v1.field_72450_a, v1.field_72448_b, v1.field_72449_c, ul, vl, sprite, 1.0f, 1.0f, 1.0f);
        HandleBakedModel.putVertex(builder, normal, v2.field_72450_a, v2.field_72448_b, v2.field_72449_c, ul, vh, sprite, 1.0f, 1.0f, 1.0f);
        HandleBakedModel.putVertex(builder, normal, v3.field_72450_a, v3.field_72448_b, v3.field_72449_c, uh, vh, sprite, 1.0f, 1.0f, 1.0f);
        HandleBakedModel.putVertex(builder, normal, v4.field_72450_a, v4.field_72448_b, v4.field_72449_c, uh, vl, sprite, 1.0f, 1.0f, 1.0f);
        return builder.build();
    }

    public static List<BakedQuad> createHandle(float xl, float xh, float yl, float yh, float zl, float zh, int flag, int design_texture) {
        TextureAtlasSprite texture = design_texture == 0 ? (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(new ResourceLocation("minecraft", "block/iron_block")) : (design_texture == 1 ? (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(new ResourceLocation("minecraft", "block/obsidian")) : (design_texture == 2 ? (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(new ResourceLocation("minecraft", "block/stone")) : (design_texture == 3 ? (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(new ResourceLocation("minecraft", "block/gold_block")) : (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(new ResourceLocation("minecraft", "block/oak_log")))));
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        Vec3d NWU = HandleBakedModel.v(xl, yh, zl);
        Vec3d NEU = HandleBakedModel.v(xl, yh, zh);
        Vec3d NWD = HandleBakedModel.v(xl, yl, zl);
        Vec3d NED = HandleBakedModel.v(xl, yl, zh);
        Vec3d SWU = HandleBakedModel.v(xh, yh, zl);
        Vec3d SEU = HandleBakedModel.v(xh, yh, zh);
        Vec3d SWD = HandleBakedModel.v(xh, yl, zl);
        Vec3d SED = HandleBakedModel.v(xh, yl, zh);
        quads.add(HandleBakedModel.create5x4Quad(NWU, NEU, SEU, SWU, texture, flag));
        quads.add(HandleBakedModel.create5x4Quad(SWD, SED, NED, NWD, texture, flag));
        quads.add(HandleBakedModel.create1x4Quad(NWD, NWU, SWU, SWD, texture, flag));
        quads.add(HandleBakedModel.create1x4Quad(SED, SEU, NEU, NED, texture, flag));
        quads.add(HandleBakedModel.create1x5Quad(NWD, NED, NEU, NWU, texture, flag));
        quads.add(HandleBakedModel.create1x5Quad(SWU, SEU, SED, SWD, texture, flag));
        return quads;
    }

    private static Vec3d v(double x, double y, double z) {
        return new Vec3d(x, y, z);
    }
}

