/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.block;

import java.util.Objects;
import javax.annotation.Nullable;
import mod.pianomanu.blockcarpentry.setup.Registration;
import mod.pianomanu.blockcarpentry.setup.config.BCModConfig;
import mod.pianomanu.blockcarpentry.tileentity.FrameBlockTile;
import mod.pianomanu.blockcarpentry.util.BCBlockStateProperties;
import mod.pianomanu.blockcarpentry.util.BlockAppearanceHelper;
import mod.pianomanu.blockcarpentry.util.BlockSavingHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class SixWaySlabFrameBlock
extends Block
implements IWaterLoggable {
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    public static final BooleanProperty CONTAINS_BLOCK = BCBlockStateProperties.CONTAINS_BLOCK;
    public static final IntegerProperty LIGHT_LEVEL = BCBlockStateProperties.LIGHT_LEVEL;
    protected static final VoxelShape BOTTOM = Block.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape TOP = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape EAST = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    protected static final VoxelShape WEST = Block.func_208617_a((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape NORTH = Block.func_208617_a((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);

    public SixWaySlabFrameBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.DOWN)).func_206870_a((IProperty)CONTAINS_BLOCK, (Comparable)Boolean.FALSE)).func_206870_a((IProperty)LIGHT_LEVEL, (Comparable)Integer.valueOf(0))).func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, BlockStateProperties.field_208198_y, CONTAINS_BLOCK, LIGHT_LEVEL});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((IProperty)FACING)) {
            case EAST: {
                return EAST;
            }
            case NORTH: {
                return NORTH;
            }
            case SOUTH: {
                return SOUTH;
            }
            case WEST: {
                return WEST;
            }
            case UP: {
                return TOP;
            }
        }
        return BOTTOM;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos blockpos = context.func_195995_a();
        IFluidState fluidstate = context.func_195991_k().func_204610_c(blockpos);
        if (fluidstate.func_206886_c() == Fluids.field_204546_a) {
            return (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_196000_l())).func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(fluidstate.func_206889_d()));
        }
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_196000_l());
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new FrameBlockTile();
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult trace) {
        ItemStack item = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            BlockAppearanceHelper.setLightLevel(item, state, world, pos, player, hand);
            BlockAppearanceHelper.setTexture(item, state, world, player, pos);
            BlockAppearanceHelper.setDesign(world, pos, player, item);
            BlockAppearanceHelper.setDesignTexture(world, pos, player, item);
            BlockAppearanceHelper.setOverlay(world, pos, player, item);
            if (item.func_77973_b() instanceof BlockItem) {
                if (((Boolean)state.func_177229_b((IProperty)BCBlockStateProperties.CONTAINS_BLOCK)).booleanValue() || Objects.requireNonNull(item.func_77973_b().getRegistryName()).func_110624_b().equals("blockcarpentry")) {
                    return ActionResultType.PASS;
                }
                TileEntity tileEntity = world.func_175625_s(pos);
                int count = player.func_184586_b(hand).func_190916_E();
                Block heldBlock = ((BlockItem)item.func_77973_b()).func_179223_d();
                if (tileEntity instanceof FrameBlockTile && !item.func_190926_b() && BlockSavingHelper.isValidBlock(heldBlock) && !((Boolean)state.func_177229_b((IProperty)CONTAINS_BLOCK)).booleanValue()) {
                    BlockState handBlockState = ((BlockItem)item.func_77973_b()).func_179223_d().func_176223_P();
                    this.insertBlock((IWorld)world, pos, state, handBlockState);
                    if (!player.func_184812_l_()) {
                        player.func_184586_b(hand).func_190920_e(count - 1);
                    }
                }
            }
            if (player.func_184586_b(hand).func_77973_b() == Registration.HAMMER.get() || !((Boolean)BCModConfig.HAMMER_NEEDED.get()).booleanValue() && player.func_225608_bj_()) {
                if (!player.func_184812_l_()) {
                    this.dropContainedBlock(world, pos);
                }
                state = (BlockState)state.func_206870_a((IProperty)CONTAINS_BLOCK, (Comparable)Boolean.FALSE);
                world.func_180501_a(pos, state, 2);
            }
        }
        return ActionResultType.SUCCESS;
    }

    protected void dropContainedBlock(World worldIn, BlockPos pos) {
        FrameBlockTile frameTileEntity;
        BlockState blockState;
        TileEntity tileentity;
        if (!worldIn.field_72995_K && (tileentity = worldIn.func_175625_s(pos)) instanceof FrameBlockTile && (blockState = (frameTileEntity = (FrameBlockTile)tileentity).getMimic()) != null) {
            worldIn.func_217379_c(1010, pos, 0);
            frameTileEntity.clear();
            float f = 0.7f;
            double d0 = (double)(worldIn.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
            double d1 = (double)(worldIn.field_73012_v.nextFloat() * 0.7f) + 0.06000000238418579 + 0.6;
            double d2 = (double)(worldIn.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
            ItemStack itemstack1 = new ItemStack((IItemProvider)blockState.func_177230_c());
            ItemEntity itementity = new ItemEntity(worldIn, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, itemstack1);
            itementity.func_174869_p();
            worldIn.func_217376_c((Entity)itementity);
            frameTileEntity.clear();
        }
    }

    public void insertBlock(IWorld worldIn, BlockPos pos, BlockState state, BlockState handBlock) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof FrameBlockTile) {
            FrameBlockTile frameTileEntity = (FrameBlockTile)tileentity;
            frameTileEntity.clear();
            frameTileEntity.setMimic(handBlock);
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)CONTAINS_BLOCK, (Comparable)Boolean.TRUE), 2);
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            this.dropContainedBlock(worldIn, pos);
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        if ((Integer)state.func_177229_b((IProperty)LIGHT_LEVEL) > 15) {
            return 15;
        }
        return (Integer)state.func_177229_b((IProperty)LIGHT_LEVEL);
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208198_y) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)BlockStateProperties.field_208198_y)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }
}

