/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.block;

import java.util.Objects;
import javax.annotation.Nullable;
import mod.pianomanu.blockcarpentry.setup.Registration;
import mod.pianomanu.blockcarpentry.setup.config.BCModConfig;
import mod.pianomanu.blockcarpentry.tileentity.FrameBlockTile;
import mod.pianomanu.blockcarpentry.util.BCBlockStateProperties;
import mod.pianomanu.blockcarpentry.util.BlockAppearanceHelper;
import mod.pianomanu.blockcarpentry.util.BlockSavingHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.FourWayBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.LeadItem;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class WallFrameBlock
extends FourWayBlock {
    public static final BooleanProperty CONTAINS_BLOCK = BCBlockStateProperties.CONTAINS_BLOCK;
    public static final IntegerProperty LIGHT_LEVEL = BCBlockStateProperties.LIGHT_LEVEL;
    private final VoxelShape[] renderShapes;

    public WallFrameBlock(Block.Properties properties) {
        super(4.0f, 3.0f, 16.0f, 14.0f, 24.0f, properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_196409_a, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)field_196411_b, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)field_196413_c, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)field_196414_y, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)field_204514_u, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)CONTAINS_BLOCK, (Comparable)Boolean.FALSE)).func_206870_a((IProperty)LIGHT_LEVEL, (Comparable)Integer.valueOf(0)));
        this.renderShapes = this.func_196408_a(2.0f, 1.0f, 16.0f, 6.0f, 15.0f);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_196409_a, field_196411_b, field_196414_y, field_196413_c, field_204514_u, CONTAINS_BLOCK, LIGHT_LEVEL});
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return this.renderShapes[this.func_196406_i(state)];
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new FrameBlockTile();
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult trace) {
        ItemStack item = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            BlockAppearanceHelper.setLightLevel(item, state, world, pos, player, hand);
            BlockAppearanceHelper.setTexture(item, state, world, player, pos);
            BlockAppearanceHelper.setDesign(world, pos, player, item);
            BlockAppearanceHelper.setDesignTexture(world, pos, player, item);
            BlockAppearanceHelper.setGlassColor(world, pos, player, hand);
            BlockAppearanceHelper.setOverlay(world, pos, player, item);
            if (item.func_77973_b() instanceof BlockItem) {
                if (((Boolean)state.func_177229_b((IProperty)BCBlockStateProperties.CONTAINS_BLOCK)).booleanValue() || Objects.requireNonNull(item.func_77973_b().getRegistryName()).func_110624_b().equals("blockcarpentry")) {
                    return ActionResultType.PASS;
                }
                TileEntity tileEntity = world.func_175625_s(pos);
                int count = player.func_184586_b(hand).func_190916_E();
                Block heldBlock = ((BlockItem)item.func_77973_b()).func_179223_d();
                if (tileEntity instanceof FrameBlockTile && !item.func_190926_b() && BlockSavingHelper.isValidBlock(heldBlock) && !((Boolean)state.func_177229_b((IProperty)CONTAINS_BLOCK)).booleanValue()) {
                    BlockState handBlockState = ((BlockItem)item.func_77973_b()).func_179223_d().func_176223_P();
                    this.insertBlock((IWorld)world, pos, state, handBlockState);
                    if (!player.func_184812_l_()) {
                        player.func_184586_b(hand).func_190920_e(count - 1);
                    }
                    return ActionResultType.SUCCESS;
                }
            }
            if (item.func_77973_b() == Items.field_151058_ca) {
                return LeadItem.func_226641_a_((PlayerEntity)player, (World)world, (BlockPos)pos);
            }
            if (player.func_184586_b(hand).func_77973_b() == Registration.HAMMER.get() || !((Boolean)BCModConfig.HAMMER_NEEDED.get()).booleanValue() && player.func_225608_bj_()) {
                if (!player.func_184812_l_()) {
                    this.dropContainedBlock(world, pos);
                }
                state = (BlockState)state.func_206870_a((IProperty)CONTAINS_BLOCK, (Comparable)Boolean.FALSE);
                world.func_180501_a(pos, state, 2);
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.SUCCESS;
    }

    protected void dropContainedBlock(World worldIn, BlockPos pos) {
        FrameBlockTile frameTileEntity;
        BlockState blockState;
        TileEntity tileentity;
        if (!worldIn.field_72995_K && (tileentity = worldIn.func_175625_s(pos)) instanceof FrameBlockTile && (blockState = (frameTileEntity = (FrameBlockTile)tileentity).getMimic()) != null) {
            worldIn.func_217379_c(1010, pos, 0);
            frameTileEntity.clear();
            float f = 0.7f;
            double d0 = (double)(worldIn.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
            double d1 = (double)(worldIn.field_73012_v.nextFloat() * 0.7f) + 0.06000000238418579 + 0.6;
            double d2 = (double)(worldIn.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
            ItemStack itemstack1 = new ItemStack((IItemProvider)blockState.func_177230_c());
            ItemEntity itementity = new ItemEntity(worldIn, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, itemstack1);
            itementity.func_174869_p();
            worldIn.func_217376_c((Entity)itementity);
            frameTileEntity.clear();
        }
    }

    public void insertBlock(IWorld worldIn, BlockPos pos, BlockState state, BlockState handBlock) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof FrameBlockTile) {
            FrameBlockTile frameTileEntity = (FrameBlockTile)tileentity;
            frameTileEntity.clear();
            frameTileEntity.setMimic(handBlock);
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)CONTAINS_BLOCK, (Comparable)Boolean.TRUE), 2);
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            this.dropContainedBlock(worldIn, pos);
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        if ((Integer)state.func_177229_b((IProperty)LIGHT_LEVEL) > 15) {
            return 15;
        }
        return (Integer)state.func_177229_b((IProperty)LIGHT_LEVEL);
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public boolean canConnect(BlockState state, boolean isSideSolid, Direction direction) {
        Block block = state.func_177230_c();
        boolean flag = this.func_235493_c_(block);
        boolean flag1 = block instanceof FenceGateBlock && FenceGateBlock.func_220253_a((BlockState)state, (Direction)direction);
        return !WallFrameBlock.func_220073_a((Block)block) && isSideSolid || flag || flag1;
    }

    private boolean func_235493_c_(Block block) {
        return block.func_203417_a(BlockTags.field_219748_G) && block.func_203417_a(BlockTags.field_219756_j) == this.func_176223_P().func_203425_a(BlockTags.field_219756_j);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        World iblockreader = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        IFluidState fluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        BlockPos blockpos1 = blockpos.func_177978_c();
        BlockPos blockpos2 = blockpos.func_177974_f();
        BlockPos blockpos3 = blockpos.func_177968_d();
        BlockPos blockpos4 = blockpos.func_177976_e();
        BlockState blockstate = iblockreader.func_180495_p(blockpos1);
        BlockState blockstate1 = iblockreader.func_180495_p(blockpos2);
        BlockState blockstate2 = iblockreader.func_180495_p(blockpos3);
        BlockState blockstate3 = iblockreader.func_180495_p(blockpos4);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)super.func_196258_a(context).func_206870_a((IProperty)field_196409_a, (Comparable)Boolean.valueOf(this.canConnect(blockstate, blockstate.func_224755_d((IBlockReader)iblockreader, blockpos1, Direction.SOUTH), Direction.SOUTH)))).func_206870_a((IProperty)field_196411_b, (Comparable)Boolean.valueOf(this.canConnect(blockstate1, blockstate1.func_224755_d((IBlockReader)iblockreader, blockpos2, Direction.WEST), Direction.WEST)))).func_206870_a((IProperty)field_196413_c, (Comparable)Boolean.valueOf(this.canConnect(blockstate2, blockstate2.func_224755_d((IBlockReader)iblockreader, blockpos3, Direction.NORTH), Direction.NORTH)))).func_206870_a((IProperty)field_196414_y, (Comparable)Boolean.valueOf(this.canConnect(blockstate3, blockstate3.func_224755_d((IBlockReader)iblockreader, blockpos4, Direction.EAST), Direction.EAST)))).func_206870_a((IProperty)field_204514_u, (Comparable)Boolean.valueOf(fluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)field_204514_u)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return facing.func_176740_k().func_176716_d() == Direction.Plane.HORIZONTAL ? (BlockState)stateIn.func_206870_a((IProperty)field_196415_z.get(facing), (Comparable)Boolean.valueOf(this.canConnect(facingState, facingState.func_224755_d((IBlockReader)worldIn, facingPos, facing.func_176734_d()), facing.func_176734_d()))) : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }
}

