/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.tileentity;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.pianomanu.blockcarpentry.setup.Registration;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BedFrameTile
extends TileEntity {
    public static final ModelProperty<BlockState> MIMIC = new ModelProperty();
    public static final ModelProperty<Integer> TEXTURE = new ModelProperty();
    public static final ModelProperty<Integer> PILLOW = new ModelProperty();
    public static final ModelProperty<Integer> BLANKET = new ModelProperty();
    public static final ModelProperty<Integer> DESIGN = new ModelProperty();
    public static final ModelProperty<Integer> DESIGN_TEXTURE = new ModelProperty();
    public final int maxTextures = 6;
    public final int maxDesigns = 4;
    private BlockState mimic;
    private Integer texture = 0;
    private Integer pillowColor = 0;
    private Integer blanketColor = 0;
    private Integer design = 0;
    private Integer designTexture = 0;
    private static final Logger LOGGER = LogManager.getLogger();

    public BedFrameTile() {
        super((TileEntityType)Registration.BED_FRAME_TILE.get());
    }

    public void setMimic(BlockState mimic) {
        this.mimic = mimic;
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
    }

    public BlockState getMimic() {
        return this.mimic;
    }

    private static Integer readInteger(CompoundNBT tag) {
        if (!tag.func_150297_b("number", 8)) {
            return 0;
        }
        try {
            return Integer.parseInt(tag.func_74779_i("number"));
        }
        catch (NumberFormatException e) {
            LOGGER.error("Not a valid Number Format: " + tag.func_74779_i("number"));
            return 0;
        }
    }

    public Integer getPillowColor() {
        return this.pillowColor;
    }

    public void setPillowColor(Integer pillowColor) {
        this.pillowColor = pillowColor;
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
    }

    public Integer getBlanketColor() {
        return this.blanketColor;
    }

    public void setBlanketColor(Integer blanketColor) {
        this.blanketColor = blanketColor;
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
    }

    public Integer getDesign() {
        return this.design;
    }

    public void setDesign(Integer design) {
        this.design = design;
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
    }

    public Integer getDesignTexture() {
        return this.designTexture;
    }

    public void setDesignTexture(Integer designTexture) {
        this.designTexture = designTexture;
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tag = super.func_189517_E_();
        if (this.mimic != null) {
            tag.func_218657_a("mimic", (INBT)NBTUtil.func_190009_a((BlockState)this.mimic));
        }
        if (this.texture != null) {
            tag.func_218657_a("texture", (INBT)BedFrameTile.writeInteger(this.texture));
        }
        if (this.blanketColor != null) {
            tag.func_218657_a("blanket", (INBT)BedFrameTile.writeInteger(this.blanketColor));
        }
        if (this.pillowColor != null) {
            tag.func_218657_a("pillow", (INBT)BedFrameTile.writeInteger(this.pillowColor));
        }
        if (this.design != null) {
            tag.func_218657_a("design", (INBT)BedFrameTile.writeInteger(this.design));
        }
        if (this.designTexture != null) {
            tag.func_218657_a("design_texture", (INBT)BedFrameTile.writeInteger(this.designTexture));
        }
        return tag;
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        BlockState oldMimic = this.mimic;
        Integer oldTexture = this.texture;
        Integer oldPillow = this.pillowColor;
        Integer oldBlanket = this.blanketColor;
        Integer oldDesign = this.design;
        Integer oldDesignTexture = this.designTexture;
        CompoundNBT tag = pkt.func_148857_g();
        if (tag.func_74764_b("mimic")) {
            this.mimic = NBTUtil.func_190008_d((CompoundNBT)tag.func_74775_l("mimic"));
            if (!Objects.equals(oldMimic, this.mimic)) {
                ModelDataManager.requestModelDataRefresh((TileEntity)this);
                this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
            }
        }
        if (tag.func_74764_b("texture")) {
            this.texture = BedFrameTile.readInteger(tag.func_74775_l("texture"));
            if (!Objects.equals(oldTexture, this.texture)) {
                ModelDataManager.requestModelDataRefresh((TileEntity)this);
                this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
            }
        }
        if (tag.func_74764_b("blanket")) {
            this.blanketColor = BedFrameTile.readInteger(tag.func_74775_l("blanket"));
            if (!Objects.equals(oldBlanket, this.blanketColor)) {
                ModelDataManager.requestModelDataRefresh((TileEntity)this);
                this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
            }
        }
        if (tag.func_74764_b("pillow")) {
            this.pillowColor = BedFrameTile.readInteger(tag.func_74775_l("pillow"));
            if (!Objects.equals(oldPillow, this.pillowColor)) {
                ModelDataManager.requestModelDataRefresh((TileEntity)this);
                this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
            }
        }
        if (tag.func_74764_b("design")) {
            this.design = BedFrameTile.readInteger(tag.func_74775_l("design"));
            if (!Objects.equals(oldDesign, this.design)) {
                ModelDataManager.requestModelDataRefresh((TileEntity)this);
                this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
            }
        }
        if (tag.func_74764_b("design_texture")) {
            this.designTexture = BedFrameTile.readInteger(tag.func_74775_l("design_texture"));
            if (!Objects.equals(oldDesignTexture, this.designTexture)) {
                ModelDataManager.requestModelDataRefresh((TileEntity)this);
                this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
            }
        }
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(MIMIC, (Object)this.mimic).withInitial(TEXTURE, (Object)this.texture).withInitial(BLANKET, (Object)this.blanketColor).withInitial(PILLOW, (Object)this.pillowColor).withInitial(DESIGN, (Object)this.design).withInitial(DESIGN_TEXTURE, (Object)this.designTexture).build();
    }

    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("mimic")) {
            this.mimic = NBTUtil.func_190008_d((CompoundNBT)tag.func_74775_l("mimic"));
        }
        if (tag.func_74764_b("texture")) {
            this.texture = BedFrameTile.readInteger(tag.func_74775_l("texture"));
        }
        if (tag.func_74764_b("blanket")) {
            this.blanketColor = BedFrameTile.readInteger(tag.func_74775_l("blanket"));
        }
        if (tag.func_74764_b("pillow")) {
            this.pillowColor = BedFrameTile.readInteger(tag.func_74775_l("pillow"));
        }
        if (tag.func_74764_b("design")) {
            this.design = BedFrameTile.readInteger(tag.func_74775_l("design"));
        }
        if (tag.func_74764_b("design_texture")) {
            this.designTexture = BedFrameTile.readInteger(tag.func_74775_l("design_texture"));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        if (this.mimic != null) {
            tag.func_218657_a("mimic", (INBT)NBTUtil.func_190009_a((BlockState)this.mimic));
        }
        if (this.texture != null) {
            tag.func_218657_a("texture", (INBT)BedFrameTile.writeInteger(this.texture));
        }
        if (this.blanketColor != null) {
            tag.func_218657_a("blanket", (INBT)BedFrameTile.writeInteger(this.blanketColor));
        }
        if (this.pillowColor != null) {
            tag.func_218657_a("pillow", (INBT)BedFrameTile.writeInteger(this.pillowColor));
        }
        if (this.design != null) {
            tag.func_218657_a("design", (INBT)BedFrameTile.writeInteger(this.design));
        }
        if (this.designTexture != null) {
            tag.func_218657_a("design_texture", (INBT)BedFrameTile.writeInteger(this.designTexture));
        }
        return tag;
    }

    private static CompoundNBT writeInteger(Integer tag) {
        CompoundNBT compoundnbt = new CompoundNBT();
        compoundnbt.func_74778_a("number", tag.toString());
        return compoundnbt;
    }

    public void clear() {
        this.setMimic(null);
        this.setTexture(0);
        this.setBlanketColor(0);
        this.setPillowColor(0);
        this.setDesign(0);
        this.setDesignTexture(0);
    }

    public Integer getTexture() {
        return this.texture;
    }

    public void setTexture(Integer texture) {
        this.texture = texture;
    }
}

