/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.tileentity;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.pianomanu.blockcarpentry.block.ChestFrameBlock;
import mod.pianomanu.blockcarpentry.container.ChestFrameContainer;
import mod.pianomanu.blockcarpentry.setup.Registration;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChestFrameTileEntity
extends LockableLootTileEntity {
    private NonNullList<ItemStack> chestContents = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
    protected int numPlayersUsing;
    private IItemHandlerModifiable items = this.createHandler();
    private LazyOptional<IItemHandlerModifiable> itemHandler = LazyOptional.of(() -> this.items);
    public static final ModelProperty<BlockState> MIMIC = new ModelProperty();
    public static final ModelProperty<Integer> TEXTURE = new ModelProperty();
    public static final ModelProperty<Integer> DESIGN = new ModelProperty();
    public static final ModelProperty<Integer> DESIGN_TEXTURE = new ModelProperty();
    public static final ModelProperty<Integer> GLASS_COLOR = new ModelProperty();
    public final int maxTextures = 8;
    public final int maxDesignTextures = 4;
    public final int maxDesigns = 4;
    private BlockState mimic;
    private Integer texture = 0;
    private Integer design = 0;
    private Integer designTexture = 0;
    private Integer glassColor = 0;
    private static final Logger LOGGER = LogManager.getLogger();

    public ChestFrameTileEntity(TileEntityType<?> typeIn) {
        super(typeIn);
    }

    public ChestFrameTileEntity() {
        this((TileEntityType)Registration.CHEST_FRAME_TILE.get());
    }

    public static void swapContents(ChestFrameTileEntity te, ChestFrameTileEntity otherTe) {
        NonNullList<ItemStack> list = te.func_190576_q();
        te.func_199721_a(otherTe.func_190576_q());
        otherTe.func_199721_a(list);
    }

    private static Integer readInteger(CompoundNBT tag) {
        if (!tag.func_150297_b("number", 8)) {
            return 0;
        }
        try {
            return Integer.parseInt(tag.func_74779_i("number"));
        }
        catch (NumberFormatException e) {
            LOGGER.error("Not a valid Number Format: " + tag.func_74779_i("number"));
            return 0;
        }
    }

    public int func_70302_i_() {
        return 27;
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.frame_chest", new Object[0]);
    }

    public NonNullList<ItemStack> func_190576_q() {
        return this.chestContents;
    }

    public void func_199721_a(NonNullList<ItemStack> itemsIn) {
        this.chestContents = itemsIn;
    }

    protected Container func_213906_a(int id, PlayerInventory player) {
        return new ChestFrameContainer(id, player, this);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        if (this.mimic != null) {
            compound.func_218657_a("mimic", (INBT)NBTUtil.func_190009_a((BlockState)this.mimic));
        }
        if (this.texture != null) {
            compound.func_218657_a("texture", (INBT)ChestFrameTileEntity.writeInteger(this.texture));
        }
        if (this.design != null) {
            compound.func_218657_a("design", (INBT)ChestFrameTileEntity.writeInteger(this.design));
        }
        if (this.designTexture != null) {
            compound.func_218657_a("design_texture", (INBT)ChestFrameTileEntity.writeInteger(this.designTexture));
        }
        if (this.glassColor != null) {
            compound.func_218657_a("glass_color", (INBT)ChestFrameTileEntity.writeInteger(this.glassColor));
        }
        super.func_189515_b(compound);
        if (!this.func_184282_c(compound)) {
            ItemStackHelper.func_191282_a((CompoundNBT)compound, this.chestContents);
        }
        return compound;
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("mimic")) {
            this.mimic = NBTUtil.func_190008_d((CompoundNBT)compound.func_74775_l("mimic"));
        }
        if (compound.func_74764_b("texture")) {
            this.texture = ChestFrameTileEntity.readInteger(compound.func_74775_l("texture"));
        }
        if (compound.func_74764_b("design")) {
            this.design = ChestFrameTileEntity.readInteger(compound.func_74775_l("design"));
        }
        if (compound.func_74764_b("design_texture")) {
            this.designTexture = ChestFrameTileEntity.readInteger(compound.func_74775_l("design_texture"));
        }
        if (compound.func_74764_b("glass_color")) {
            this.glassColor = ChestFrameTileEntity.readInteger(compound.func_74775_l("glass_color"));
        }
        this.chestContents = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        if (!this.func_184283_b(compound)) {
            ItemStackHelper.func_191283_b((CompoundNBT)compound, this.chestContents);
        }
    }

    private void playSound(SoundEvent sound) {
        double dx = (double)this.field_174879_c.func_177958_n() + 0.5;
        double dy = (double)this.field_174879_c.func_177956_o() + 0.5;
        double dz = (double)this.field_174879_c.func_177952_p() + 0.5;
        this.field_145850_b.func_184148_a((PlayerEntity)null, dx, dy, dz, sound, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.numPlayersUsing = type;
            return true;
        }
        return super.func_145842_c(id, type);
    }

    public void func_174889_b(PlayerEntity player) {
        if (!player.func_175149_v()) {
            if (this.numPlayersUsing < 0) {
                this.numPlayersUsing = 0;
            }
            ++this.numPlayersUsing;
            this.onOpenOrClose();
        }
    }

    public static int getPlayersUsing(IBlockReader reader, BlockPos pos) {
        TileEntity tileentity;
        BlockState blockstate = reader.func_180495_p(pos);
        if (blockstate.hasTileEntity() && (tileentity = reader.func_175625_s(pos)) instanceof ChestFrameTileEntity) {
            return ((ChestFrameTileEntity)tileentity).numPlayersUsing;
        }
        return 0;
    }

    public void func_174886_c(PlayerEntity player) {
        if (!player.func_175149_v()) {
            --this.numPlayersUsing;
            this.onOpenOrClose();
        }
    }

    protected void onOpenOrClose() {
        Block block = this.func_195044_w().func_177230_c();
        if (block instanceof ChestFrameBlock) {
            this.field_145850_b.func_175641_c(this.field_174879_c, block, 1, this.numPlayersUsing);
            this.field_145850_b.func_195593_d(this.field_174879_c, block);
        }
    }

    public void func_145836_u() {
        super.func_145836_u();
        if (this.itemHandler != null) {
            this.itemHandler.invalidate();
            this.itemHandler = null;
        }
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nonnull Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    private IItemHandlerModifiable createHandler() {
        return new InvWrapper((IInventory)this);
    }

    public void setMimic(BlockState mimic) {
        this.mimic = mimic;
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
    }

    public BlockState getMimic() {
        return this.mimic;
    }

    public Integer getDesign() {
        return this.design;
    }

    public void setDesign(Integer design) {
        this.design = design;
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
    }

    public Integer getDesignTexture() {
        return this.designTexture;
    }

    public void setDesignTexture(Integer designTexture) {
        this.designTexture = designTexture;
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
    }

    public Integer getTexture() {
        return this.texture;
    }

    public void setTexture(Integer texture) {
        this.texture = texture;
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
    }

    public Integer getGlassColor() {
        return this.glassColor;
    }

    public void setGlassColor(Integer colorNumber) {
        this.glassColor = colorNumber;
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tag = super.func_189517_E_();
        if (this.mimic != null) {
            tag.func_218657_a("mimic", (INBT)NBTUtil.func_190009_a((BlockState)this.mimic));
        }
        if (this.texture != null) {
            tag.func_218657_a("texture", (INBT)ChestFrameTileEntity.writeInteger(this.texture));
        }
        if (this.design != null) {
            tag.func_218657_a("design", (INBT)ChestFrameTileEntity.writeInteger(this.design));
        }
        if (this.designTexture != null) {
            tag.func_218657_a("design_texture", (INBT)ChestFrameTileEntity.writeInteger(this.designTexture));
        }
        if (this.glassColor != null) {
            tag.func_218657_a("glass_color", (INBT)ChestFrameTileEntity.writeInteger(this.glassColor));
        }
        return tag;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        BlockState oldMimic = this.mimic;
        Integer oldTexture = this.texture;
        Integer oldDesign = this.design;
        Integer oldDesignTexture = this.designTexture;
        Integer oldGlassColor = this.glassColor;
        CompoundNBT tag = pkt.func_148857_g();
        if (tag.func_74764_b("mimic")) {
            this.mimic = NBTUtil.func_190008_d((CompoundNBT)tag.func_74775_l("mimic"));
            if (!Objects.equals(oldMimic, this.mimic)) {
                ModelDataManager.requestModelDataRefresh((TileEntity)this);
                this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
            }
        }
        if (tag.func_74764_b("texture")) {
            this.texture = ChestFrameTileEntity.readInteger(tag.func_74775_l("texture"));
            if (!Objects.equals(oldTexture, this.texture)) {
                ModelDataManager.requestModelDataRefresh((TileEntity)this);
                this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
            }
        }
        if (tag.func_74764_b("design")) {
            this.design = ChestFrameTileEntity.readInteger(tag.func_74775_l("design"));
            if (!Objects.equals(oldDesign, this.design)) {
                ModelDataManager.requestModelDataRefresh((TileEntity)this);
                this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
            }
        }
        if (tag.func_74764_b("design_texture")) {
            this.designTexture = ChestFrameTileEntity.readInteger(tag.func_74775_l("design_texture"));
            if (!Objects.equals(oldDesignTexture, this.designTexture)) {
                ModelDataManager.requestModelDataRefresh((TileEntity)this);
                this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
            }
        }
        if (tag.func_74764_b("glass_color")) {
            this.glassColor = ChestFrameTileEntity.readInteger(tag.func_74775_l("glass_color"));
            if (!Objects.equals(oldGlassColor, this.glassColor)) {
                ModelDataManager.requestModelDataRefresh((TileEntity)this);
                this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
            }
        }
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(MIMIC, (Object)this.mimic).withInitial(TEXTURE, (Object)this.texture).withInitial(DESIGN, (Object)this.design).withInitial(DESIGN_TEXTURE, (Object)this.designTexture).withInitial(GLASS_COLOR, (Object)this.glassColor).build();
    }

    public void func_174888_l() {
        this.setMimic(null);
        this.setDesign(0);
        this.setDesign(0);
        this.setDesign(0);
        this.setGlassColor(0);
    }

    private static CompoundNBT writeInteger(Integer tag) {
        CompoundNBT compoundnbt = new CompoundNBT();
        compoundnbt.func_74778_a("number", tag.toString());
        return compoundnbt;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.itemHandler != null) {
            this.itemHandler.invalidate();
        }
    }
}

