/*
 * Decompiled with CFR 0.152.
 */
package com.pugz.bloomful.common.entity;

import com.pugz.bloomful.common.entity.ai.LandOnPlantGoal;
import com.pugz.bloomful.core.util.ButterflyType;
import java.awt.Color;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.BushBlock;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ButterflyEntity
extends CreatureEntity {
    private BlockPos spawnPosition;
    private boolean field_204228_bA = true;

    public ButterflyEntity(EntityType<? extends ButterflyEntity> type, World world) {
        super(type, world);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(8, (Goal)new LandOnPlantGoal(this, 0.6));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomFlyingGoal((CreatureEntity)this, 0.6));
    }

    public static boolean spawnCondition(EntityType<ButterflyEntity> entity, IWorld world, SpawnReason reason, BlockPos pos, Random random) {
        int light = world.func_201696_r(pos);
        if (world.func_201675_m().func_186058_p() == DimensionType.field_223227_a_ && world.func_175710_j(pos) && light >= 7 && world.func_201672_e().func_72935_r()) {
            return (world.func_180495_p(pos).func_177230_c() instanceof BushBlock || world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BushBlock || world.func_180495_p(pos.func_177978_c()).func_177230_c() instanceof BushBlock || world.func_180495_p(pos.func_177968_d()).func_177230_c() instanceof BushBlock || world.func_180495_p(pos.func_177974_f()).func_177230_c() instanceof BushBlock || world.func_180495_p(pos.func_177976_e()).func_177230_c() instanceof BushBlock) && world.func_226659_b_(pos, 0) > 8;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String getBottleName() {
        return "entity.bloomful.butterfly." + Variant.toRegistryName(Variant.name);
    }

    public boolean func_204209_c(int p_204209_1_) {
        return !this.field_204228_bA;
    }

    public Variant getButterflyVariant() {
        ButterflyType type = ButterflyType.types[this.field_70146_Z.nextInt(ButterflyType.values().length)];
        Variant variant = type.getVariants().get(this.field_70146_Z.nextInt(type.getVariants().size()));
        System.out.println(variant + type.name());
        return variant;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Color getPatternColorA() {
        this.getButterflyVariant();
        return Variant.colorA;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Color getPatternColorB() {
        this.getButterflyVariant();
        return Variant.colorB;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getPatternTextureA() {
        this.getButterflyVariant();
        return Variant.patternA;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getPatternTextureB() {
        this.getButterflyVariant();
        return Variant.patternB;
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_82167_n(Entity entity) {
    }

    protected void func_85033_bc() {
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(3.0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.6, 1.0));
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (!(this.spawnPosition == null || this.field_70170_p.func_175623_d(this.spawnPosition) && this.spawnPosition.func_177956_o() >= 1)) {
            this.spawnPosition = null;
        }
        if (this.spawnPosition == null || this.field_70146_Z.nextInt(30) == 0 || this.spawnPosition.func_218137_a((IPosition)this.func_213303_ch(), 2.0)) {
            this.spawnPosition = new BlockPos(this.func_226277_ct_() + (double)this.field_70146_Z.nextInt(7) - (double)this.field_70146_Z.nextInt(7), this.func_226278_cu_() + (double)this.field_70146_Z.nextInt(6) - 2.0, this.func_226281_cx_() + (double)this.field_70146_Z.nextInt(7) - (double)this.field_70146_Z.nextInt(7));
        }
        double x = (double)this.spawnPosition.func_177958_n() + 0.5 - this.func_226277_ct_();
        double y = (double)this.spawnPosition.func_177956_o() + 0.1 - this.func_226278_cu_();
        double z = (double)this.spawnPosition.func_177952_p() + 0.5 - this.func_226281_cx_();
        Vec3d lvt_9_1_ = this.func_213322_ci();
        Vec3d lvt_10_1_ = lvt_9_1_.func_72441_c((Math.signum(x) * 0.5 - lvt_9_1_.field_72450_a) * (double)0.1f, (Math.signum(y) * (double)0.7f - lvt_9_1_.field_72448_b) * (double)0.1f, (Math.signum(z) * 0.5 - lvt_9_1_.field_72449_c) * (double)0.1f);
        this.func_213317_d(lvt_10_1_);
        float lvt_11_1_ = (float)(MathHelper.func_181159_b((double)lvt_10_1_.field_72449_c, (double)lvt_10_1_.field_72450_a) * 57.2957763671875) - 90.0f;
        float lvt_12_1_ = MathHelper.func_76142_g((float)(lvt_11_1_ - this.field_70177_z));
        this.field_191988_bg = 0.5f;
        this.field_70177_z += lvt_12_1_;
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public void fall(float p_180430_1_, float p_180430_2_) {
    }

    protected void func_184231_a(double p_184231_1_, boolean p_184231_3_, BlockState state, BlockPos pos) {
    }

    public boolean func_145773_az() {
        return true;
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (this.func_180431_b(source)) {
            return false;
        }
        return super.func_70097_a(source, damage);
    }

    protected float func_213348_b(Pose pose, EntitySize size) {
        return size.field_220316_b / 2.0f;
    }

    public static class Variant {
        private static String name;
        private static Color colorA;
        private static Color colorB;
        private static ResourceLocation patternA;
        private static ResourceLocation patternB;

        public Variant(String nameIn, Color a, Color b) {
            name = nameIn;
            colorA = a;
            colorB = b;
        }

        private static String toRegistryName(String string) {
            string.toLowerCase().replace(" ", "_").replace("-", "_");
            return string;
        }

        static {
            patternA = new ResourceLocation("bloomful", "textures/entity/butterfly/butterfly_a_pattern_1.png");
            patternB = new ResourceLocation("bloomful", "textures/entity/butterfly/butterfly_b_pattern_1.png");
        }
    }
}

