/*
 * Decompiled with CFR 0.152.
 */
package com.pugz.bloomful.common.world.gen.feature;

import com.mojang.datafixers.Dynamic;
import com.pugz.bloomful.core.util.BiomeFeatures;
import com.pugz.bloomful.core.util.WisteriaTreeUtils;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.TreeFeatureConfig;
import net.minecraftforge.common.IPlantable;

public class WisteriaTreeFeature
extends AbstractTreeFeature<TreeFeatureConfig> {
    private Supplier<BlockState> VINE_UPPER;
    private Supplier<BlockState> VINE_LOWER;

    public WisteriaTreeFeature(Function<Dynamic<?>, ? extends TreeFeatureConfig> config) {
        super(config);
    }

    public boolean func_225557_a_(IWorldGenerationReader world, Random random, BlockPos pos, Set<BlockPos> changedBlocks, Set<BlockPos> p_225557_5_, MutableBoundingBox boundingBox, TreeFeatureConfig config) {
        if (config.field_227369_n_.func_225574_a_(random, pos) == BiomeFeatures.BLUE_WISTERIA_LEAVES) {
            this.VINE_UPPER = () -> BiomeFeatures.BLUE_HANGING_WISTERIA_LEAVES_TOP;
            this.VINE_LOWER = () -> BiomeFeatures.BLUE_HANGING_WISTERIA_LEAVES_BOTTOM;
        }
        if (config.field_227369_n_.func_225574_a_(random, pos) == BiomeFeatures.PINK_WISTERIA_LEAVES) {
            this.VINE_UPPER = () -> BiomeFeatures.PINK_HANGING_WISTERIA_LEAVES_TOP;
            this.VINE_LOWER = () -> BiomeFeatures.PINK_HANGING_WISTERIA_LEAVES_BOTTOM;
        }
        if (config.field_227369_n_.func_225574_a_(random, pos) == BiomeFeatures.PURPLE_WISTERIA_LEAVES) {
            this.VINE_UPPER = () -> BiomeFeatures.PURPLE_HANGING_WISTERIA_LEAVES_TOP;
            this.VINE_LOWER = () -> BiomeFeatures.PURPLE_HANGING_WISTERIA_LEAVES_BOTTOM;
        }
        if (config.field_227369_n_.func_225574_a_(random, pos) == BiomeFeatures.WHITE_WISTERIA_LEAVES) {
            this.VINE_UPPER = () -> BiomeFeatures.WHITE_HANGING_WISTERIA_LEAVES_TOP;
            this.VINE_LOWER = () -> BiomeFeatures.WHITE_HANGING_WISTERIA_LEAVES_BOTTOM;
        }
        int height = random.nextInt(7) + 5;
        boolean flag = true;
        if (pos.func_177956_o() >= 1 && pos.func_177956_o() + height + 1 <= world.getMaxHeight()) {
            for (int j = pos.func_177956_o(); j <= pos.func_177956_o() + 1 + height; ++j) {
                int k = 1;
                if (j == pos.func_177956_o()) {
                    k = 0;
                }
                if (j >= pos.func_177956_o() + 1 + height - 2) {
                    k = 2;
                }
                BlockPos.Mutable blockpos$mutableblockpos = new BlockPos.Mutable();
                for (int l = pos.func_177958_n() - k; l <= pos.func_177958_n() + k && flag; ++l) {
                    for (int i1 = pos.func_177952_p() - k; i1 <= pos.func_177952_p() + k && flag; ++i1) {
                        if (j >= 0 && j < world.getMaxHeight()) {
                            if (WisteriaTreeFeature.func_214587_a((IWorldGenerationBaseReader)world, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            if (WisteriaTreeFeature.isSoil((IWorldGenerationBaseReader)world, (BlockPos)pos.func_177977_b(), (IPlantable)config.getSapling()) && pos.func_177956_o() < world.getMaxHeight() - height - 1) {
                this.setDirtAt(world, pos.func_177977_b(), pos);
                for (int y = 4; y > -4; --y) {
                    for (int x = 4; x > -4; --x) {
                        for (int z = 4; z > -4; --z) {
                            int n = y > 0 ? y * y : 0;
                            if (!(Math.sqrt(x * x + n + z * z) <= 4.0)) continue;
                            BlockPos leafPos = pos.func_177982_a(x, y + height, z);
                            boolean place = true;
                            if (y < 0 && (place = world.func_217375_a(leafPos.func_177982_a(0, 1, 0), state -> state.func_203425_a(BlockTags.field_206952_E))) && random.nextInt(Math.abs(y) + 1) != 0) {
                                place = false;
                                if (random.nextInt(4) == 0 && !WisteriaTreeUtils.isLog((IWorldGenerationBaseReader)world, leafPos)) {
                                    this.placeVines(changedBlocks, world, random, leafPos, config.field_227369_n_.func_225574_a_(random, pos), this.VINE_LOWER.get(), this.VINE_UPPER.get(), boundingBox, config);
                                }
                            }
                            if (!place) continue;
                            this.placeLeafAt(changedBlocks, world, leafPos, boundingBox, config, random);
                        }
                    }
                }
                for (int i2 = 0; i2 < height; ++i2) {
                    if (!WisteriaTreeFeature.func_214572_g((IWorldGenerationBaseReader)world, (BlockPos)pos.func_177981_b(i2))) continue;
                    this.setLogState(changedBlocks, (IWorldWriter)world, pos.func_177981_b(i2), config.field_227368_m_.func_225574_a_(random, pos), boundingBox);
                }
                this.placeBranch(changedBlocks, world, random, pos.func_177977_b(), pos.func_177981_b(height).func_177956_o(), boundingBox, config);
                if (random.nextInt(4) == 0) {
                    this.placeBranch(changedBlocks, world, random, pos.func_177977_b(), pos.func_177981_b(height).func_177956_o(), boundingBox, config);
                }
                BlockPos startPos = pos.func_177981_b(height);
                for (BlockPos blockpos : BlockPos.func_191531_b((int)(startPos.func_177958_n() - 10), (int)(startPos.func_177956_o() - 10), (int)(startPos.func_177952_p() - 10), (int)(startPos.func_177958_n() + 10), (int)(startPos.func_177956_o() + 10), (int)(startPos.func_177952_p() + 10))) {
                    if (!WisteriaTreeFeature.func_214574_b((IWorldGenerationBaseReader)world, (BlockPos)blockpos) || !WisteriaTreeFeature.isLeaves((IWorldGenerationBaseReader)world, blockpos.func_177984_a(), config, random) || random.nextInt(4) != 0) continue;
                    if (WisteriaTreeFeature.func_214574_b((IWorldGenerationBaseReader)world, (BlockPos)blockpos)) {
                        this.setForcedState(changedBlocks, (IWorldWriter)world, blockpos, this.VINE_UPPER.get(), boundingBox);
                    }
                    if (!WisteriaTreeFeature.func_214574_b((IWorldGenerationBaseReader)world, (BlockPos)blockpos.func_177977_b()) || random.nextInt(2) != 0) continue;
                    this.setForcedState(changedBlocks, (IWorldWriter)world, blockpos.func_177977_b(), this.VINE_LOWER.get(), boundingBox);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void placeBranch(Set<BlockPos> changedBlocks, IWorldGenerationReader world, Random random, BlockPos pos, int treeHeight, MutableBoundingBox boundingBox, TreeFeatureConfig config) {
        int heightOffset = random.nextInt(3);
        BlockPos[] startPositions = new BlockPos[]{new BlockPos(pos.func_177958_n() - 1, treeHeight - heightOffset, pos.func_177952_p()), new BlockPos(pos.func_177958_n() + 1, treeHeight - heightOffset, pos.func_177952_p()), new BlockPos(pos.func_177958_n(), treeHeight - heightOffset, pos.func_177952_p() - 1), new BlockPos(pos.func_177958_n(), treeHeight - heightOffset, pos.func_177952_p() + 1), new BlockPos(pos.func_177958_n() - 1, treeHeight - heightOffset, pos.func_177952_p() - 1), new BlockPos(pos.func_177958_n() + 1, treeHeight - heightOffset, pos.func_177952_p() - 1), new BlockPos(pos.func_177958_n() - 1, treeHeight - heightOffset, pos.func_177952_p() + 1), new BlockPos(pos.func_177958_n() + 1, treeHeight - heightOffset, pos.func_177952_p() + 1)};
        BlockPos startPos = startPositions[random.nextInt(8)];
        if (WisteriaTreeFeature.func_214572_g((IWorldGenerationBaseReader)world, (BlockPos)startPos)) {
            boolean vines = random.nextInt(6) != 5;
            BlockPos placePos = startPos;
            for (int y = treeHeight - heightOffset; y <= treeHeight; ++y) {
                placePos = new BlockPos(startPos.func_177958_n(), y, startPos.func_177952_p());
                if (!WisteriaTreeFeature.func_214572_g((IWorldGenerationBaseReader)world, (BlockPos)placePos)) continue;
                this.setLogState(changedBlocks, (IWorldWriter)world, placePos, config.field_227368_m_.func_225574_a_(random, pos), boundingBox);
            }
            this.placeLeafAt(changedBlocks, world, placePos.func_177984_a(), boundingBox, config, random);
            if (vines) {
                this.placeVines(changedBlocks, world, random, startPos.func_177977_b(), config.field_227369_n_.func_225574_a_(random, pos), this.VINE_LOWER.get(), this.VINE_UPPER.get(), boundingBox, config);
            }
        }
    }

    private void placeVines(Set<BlockPos> changedBlocks, IWorldGenerationReader world, Random random, BlockPos pos, BlockState leaf, BlockState vineLower, BlockState vineUpper, MutableBoundingBox boundingBox, TreeFeatureConfig config) {
        int length = WisteriaTreeUtils.getLengthByNeighbors(world, random, pos);
        if (random.nextInt(6) != 5 && WisteriaTreeFeature.func_214574_b((IWorldGenerationBaseReader)world, (BlockPos)pos) && !WisteriaTreeUtils.isLog((IWorldGenerationBaseReader)world, pos)) {
            switch (length) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    if (!WisteriaTreeFeature.func_214574_b((IWorldGenerationBaseReader)world, (BlockPos)pos)) break;
                    this.placeLeafAt(changedBlocks, world, pos, boundingBox, config, random);
                    break;
                }
                case 4: {
                    if (WisteriaTreeFeature.func_214574_b((IWorldGenerationBaseReader)world, (BlockPos)pos)) {
                        this.placeLeafAt(changedBlocks, world, pos, boundingBox, config, random);
                    }
                    if (!WisteriaTreeFeature.func_214574_b((IWorldGenerationBaseReader)world, (BlockPos)pos.func_177977_b())) break;
                    this.placeLeafAt(changedBlocks, world, pos.func_177977_b(), boundingBox, config, random);
                    break;
                }
                case 5: {
                    if (WisteriaTreeFeature.func_214574_b((IWorldGenerationBaseReader)world, (BlockPos)pos)) {
                        this.placeLeafAt(changedBlocks, world, pos, boundingBox, config, random);
                    }
                    if (WisteriaTreeFeature.func_214574_b((IWorldGenerationBaseReader)world, (BlockPos)pos.func_177977_b())) {
                        this.placeLeafAt(changedBlocks, world, pos.func_177977_b(), boundingBox, config, random);
                    }
                    if (!WisteriaTreeFeature.func_214574_b((IWorldGenerationBaseReader)world, (BlockPos)pos.func_177979_c(2))) break;
                    this.placeLeafAt(changedBlocks, world, pos.func_177979_c(2), boundingBox, config, random);
                }
            }
        }
    }

    private void placeLeafAt(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, BlockPos pos, MutableBoundingBox boundingBox, TreeFeatureConfig config, Random random) {
        if (WisteriaTreeFeature.func_214572_g((IWorldGenerationBaseReader)worldIn, (BlockPos)pos)) {
            this.setLogState(changedBlocks, (IWorldWriter)worldIn, pos, config.field_227369_n_.func_225574_a_(random, pos), boundingBox);
        }
    }

    protected final void setLogState(Set<BlockPos> changedBlocks, IWorldWriter worldIn, BlockPos pos, BlockState p_208520_4_, MutableBoundingBox p_208520_5_) {
        this.func_208521_b(worldIn, pos, p_208520_4_);
        p_208520_5_.func_78888_b(new MutableBoundingBox((Vec3i)pos, (Vec3i)pos));
        if (BlockTags.field_200031_h.func_199685_a_((Object)p_208520_4_.func_177230_c())) {
            changedBlocks.add(pos.func_185334_h());
        }
    }

    private void func_208521_b(IWorldWriter p_208521_1_, BlockPos p_208521_2_, BlockState p_208521_3_) {
        p_208521_1_.func_180501_a(p_208521_2_, p_208521_3_, 18);
    }

    private void setForcedState(Set<BlockPos> changedBlocks, IWorldWriter worldIn, BlockPos pos, BlockState state, MutableBoundingBox boundingBox) {
        worldIn.func_180501_a(pos, state, 18);
        boundingBox.func_78888_b(new MutableBoundingBox((Vec3i)pos, (Vec3i)pos));
        changedBlocks.add(pos.func_185334_h());
    }

    public static boolean isLeaves(IWorldGenerationBaseReader worldIn, BlockPos pos, TreeFeatureConfig config, Random random) {
        if (worldIn instanceof IWorldReader) {
            return worldIn.func_217375_a(pos, state -> state == config.field_227369_n_.func_225574_a_(random, pos));
        }
        return worldIn.func_217375_a(pos, p_227223_0_ -> config.field_227369_n_.func_225574_a_(random, pos) == p_227223_0_);
    }
}

