/*
 * Decompiled with CFR 0.152.
 */
package com.pugz.bloomful.core;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class BloomfulConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;

    private static String makeTranslation(String name) {
        return "bloomful.config." + name;
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class ValuesHolder {
        private static boolean generateExternalWisterias;

        public static void updateCommonValuesFromConfig(ModConfig config) {
            generateExternalWisterias = (Boolean)BloomfulConfig.COMMON.generateExternalWisterias.get();
        }

        public static boolean generateWisterias() {
            return generateExternalWisterias;
        }
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<Boolean> generateExternalWisterias;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Common Config").push("common");
            this.generateExternalWisterias = builder.comment("If Wisteria Trees generate outside of the Wisteria Forest; Default: False").translation(BloomfulConfig.makeTranslation("generate_external_wisterias")).define("generateExternalWisterias", false);
            builder.pop();
        }
    }
}

