/*
 * Decompiled with CFR 0.152.
 */
package com.pugz.bloomful.core.registry;

import com.pugz.bloomful.common.world.gen.feature.BigWisteriaTreeFeature;
import com.pugz.bloomful.common.world.gen.feature.WisteriaTreeFeature;
import com.pugz.bloomful.core.BloomfulConfig;
import com.pugz.bloomful.core.util.BiomeFeatures;
import com.pugz.bloomful.core.util.WisteriaColor;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.TreeFeatureConfig;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="bloomful", bus=Mod.EventBusSubscriber.Bus.MOD)
public class BloomfulFeatures {
    public static final Feature<TreeFeatureConfig> WISTERIA_TREE = new WisteriaTreeFeature(TreeFeatureConfig::func_227338_a_);
    public static final Feature<TreeFeatureConfig> BIG_WISTERIA_TREE = new BigWisteriaTreeFeature(TreeFeatureConfig::func_227338_a_);

    @SubscribeEvent
    public static void registerFeatures(RegistryEvent.Register<Feature<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Feature[]{(Feature)WISTERIA_TREE.setRegistryName("wisteria_tree"), (Feature)BIG_WISTERIA_TREE.setRegistryName("big_wisteria_tree")});
    }

    public static void generateFeatures() {
        ForgeRegistries.BIOMES.getValues().forEach(BloomfulFeatures::generateWisteriaTrees);
    }

    public static void generateWisteriaTrees(Biome biome) {
        if (biome.func_201856_r() == Biome.Category.FOREST && biome == Biomes.field_185444_T) {
            BiomeFeatures.addDelphiniums(biome, 12);
            BiomeFeatures.addWisteriaTreesBeehive(biome, 2, 0.01f, false);
        }
        if (BloomfulConfig.ValuesHolder.generateWisterias()) {
            if (biome.func_201856_r() == Biome.Category.JUNGLE) {
                BiomeFeatures.addWisteriaTree(biome, WisteriaColor.PINK, 0, 0.1f, true);
            } else if (biome.func_201856_r() == Biome.Category.SWAMP) {
                BiomeFeatures.addWisteriaTree(biome, WisteriaColor.BLUE, 0, 0.001f, true);
            } else if (biome.func_201856_r() == Biome.Category.PLAINS) {
                BiomeFeatures.addWisteriaTreeBeehive(biome, WisteriaColor.PURPLE, 0, 0.001f, true);
            } else if (biome.func_201856_r() == Biome.Category.ICY) {
                BiomeFeatures.addWisteriaTree(biome, WisteriaColor.BLUE, 0, 0.001f, true);
            }
        }
    }
}

