/*
 * Decompiled with CFR 0.152.
 */
package com.pugz.bloomful.core.util;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;

public class WisteriaTreeUtils {
    public static int getLengthByNeighbors(IWorldGenerationReader world, Random random, BlockPos pos) {
        int length = random.nextInt(6);
        for (Direction direction : Direction.values()) {
            if (direction == Direction.UP || direction == Direction.DOWN) continue;
            if (WisteriaTreeUtils.isAir((IWorldGenerationBaseReader)world, pos.func_177972_a(direction))) {
                ++length;
                continue;
            }
            if (!WisteriaTreeUtils.isLeaves((IWorldGenerationBaseReader)world, pos.func_177972_a(direction))) continue;
            --length;
        }
        return length;
    }

    protected static boolean isAir(IWorldGenerationBaseReader worldIn, BlockPos pos) {
        if (!(worldIn instanceof IBlockReader)) {
            return worldIn.func_217375_a(pos, BlockState::func_196958_f);
        }
        return worldIn.func_217375_a(pos, state -> state.isAir((IBlockReader)worldIn, pos));
    }

    protected static boolean isLeaves(IWorldGenerationBaseReader worldIn, BlockPos pos) {
        return worldIn.func_217375_a(pos, p_214579_0_ -> p_214579_0_.func_203425_a(BlockTags.field_206952_E));
    }

    public static boolean isLog(IWorldGenerationBaseReader worldIn, BlockPos pos) {
        return worldIn.func_217375_a(pos, p_214579_0_ -> p_214579_0_.func_203425_a(BlockTags.field_200031_h));
    }
}

