/*
 * Decompiled with CFR 0.152.
 */
package com.pugz.bloomful.common.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IShearable;

public class WisteriaVineBlock
extends Block
implements IShearable {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.field_208163_P;
    protected static final VoxelShape WISTERIA_VINE_TOP = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    protected static final VoxelShape WISTERIA_VINE_BOTTOM = Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);

    public WisteriaVineBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(HALF, (Comparable)DoubleBlockHalf.UPPER));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (state.func_177229_b(HALF) == DoubleBlockHalf.UPPER) {
            return WISTERIA_VINE_TOP;
        }
        if (state.func_177229_b(HALF) == DoubleBlockHalf.LOWER) {
            return WISTERIA_VINE_BOTTOM;
        }
        return VoxelShapes.func_197880_a();
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197880_a();
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean moving) {
        if (state == this.func_176223_P().func_206870_a(HALF, (Comparable)DoubleBlockHalf.UPPER)) {
            if (world.func_180495_p(pos.func_177984_a()) == Blocks.field_150350_a.func_176223_P()) {
                world.func_217377_a(pos, false);
            }
        } else if (state == this.func_176223_P().func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER) && world.func_180495_p(pos.func_177984_a()) == Blocks.field_150350_a.func_176223_P()) {
            world.func_217377_a(pos, false);
        }
    }

    public int func_200011_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 1;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{HALF});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        BlockPos blockpos;
        BlockState blockstate;
        if (!(!worldIn.func_175727_C(pos.func_177984_a()) || rand.nextInt(15) != 1 || (blockstate = worldIn.func_180495_p(blockpos = pos.func_177977_b())).func_200132_m() && blockstate.func_224755_d((IBlockReader)worldIn, blockpos, Direction.UP))) {
            double d0 = (float)pos.func_177958_n() + rand.nextFloat();
            double d1 = (double)pos.func_177956_o() - 0.05;
            double d2 = (float)pos.func_177952_p() + rand.nextFloat();
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197618_k, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public boolean isLadder(BlockState state, IWorldReader world, BlockPos pos, LivingEntity entity) {
        return true;
    }

    public boolean func_200124_e(BlockState state) {
        return false;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean func_220060_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return false;
    }

    public boolean func_220067_a(BlockState state, IBlockReader worldIn, BlockPos pos, EntityType<?> type) {
        return type == EntityType.field_200781_U || type == EntityType.field_200783_W;
    }

    protected boolean isStateValid(World worldIn, BlockPos pos) {
        Block block = worldIn.func_180495_p(pos.func_177984_a()).func_177230_c();
        return block == ((BlockState)this.func_176223_P().func_206870_a(HALF, (Comparable)DoubleBlockHalf.UPPER)).func_177230_c() || block.func_203417_a(BlockTags.field_206952_E) || block.func_203417_a(BlockTags.field_200031_h);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos pos;
        World world = context.func_195991_k();
        if (this.isStateValid(world, pos = context.func_195995_a())) {
            if (world.func_180495_p(pos.func_177984_a()) == this.func_176223_P().func_206870_a(HALF, (Comparable)DoubleBlockHalf.UPPER)) {
                return (BlockState)this.func_176223_P().func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER);
            }
            if (world.func_180495_p(pos.func_177984_a()) == this.func_176223_P().func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER)) {
                return null;
            }
            return (BlockState)this.func_176223_P().func_206870_a(HALF, (Comparable)DoubleBlockHalf.UPPER);
        }
        return null;
    }
}

