/*
 * Decompiled with CFR 0.152.
 */
package com.pugz.bloomful.common.world.gen.feature;

import com.mojang.datafixers.Dynamic;
import com.pugz.bloomful.common.block.WisteriaVineBlock;
import com.pugz.bloomful.core.registry.BlockRegistry;
import com.pugz.bloomful.core.util.WisteriaColor;
import com.pugz.bloomful.core.util.WisteriaTreeUtils;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.IPlantable;

public class BigWisteriaTreeFeature
extends AbstractTreeFeature<NoFeatureConfig> {
    private final BlockState LOG = BlockRegistry.WISTERIA_LOG.func_176223_P();
    private BlockState LEAF;
    private BlockState VINE_UPPER;
    private BlockState VINE_LOWER;

    public BigWisteriaTreeFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> function, boolean doBlockNofityOnPlace, WisteriaColor color) {
        super(function, doBlockNofityOnPlace);
        this.setBlocksByColor(color);
    }

    private void setBlocksByColor(WisteriaColor color) {
        switch (color) {
            case PURPLE: {
                this.LEAF = BlockRegistry.PURPLE_WISTERIA_LEAVES.func_176223_P();
                this.VINE_UPPER = BlockRegistry.PURPLE_WISTERIA_VINE.func_176223_P();
                this.VINE_LOWER = (BlockState)BlockRegistry.PURPLE_WISTERIA_VINE.func_176223_P().func_206870_a(WisteriaVineBlock.HALF, (Comparable)DoubleBlockHalf.LOWER);
                break;
            }
            case WHITE: {
                this.LEAF = BlockRegistry.WHITE_WISTERIA_LEAVES.func_176223_P();
                this.VINE_UPPER = BlockRegistry.WHITE_WISTERIA_VINE.func_176223_P();
                this.VINE_LOWER = (BlockState)BlockRegistry.WHITE_WISTERIA_VINE.func_176223_P().func_206870_a(WisteriaVineBlock.HALF, (Comparable)DoubleBlockHalf.LOWER);
                break;
            }
            case PINK: {
                this.LEAF = BlockRegistry.PINK_WISTERIA_LEAVES.func_176223_P();
                this.VINE_UPPER = BlockRegistry.PINK_WISTERIA_VINE.func_176223_P();
                this.VINE_LOWER = (BlockState)BlockRegistry.PINK_WISTERIA_VINE.func_176223_P().func_206870_a(WisteriaVineBlock.HALF, (Comparable)DoubleBlockHalf.LOWER);
                break;
            }
            case BLUE: {
                this.LEAF = BlockRegistry.BLUE_WISTERIA_LEAVES.func_176223_P();
                this.VINE_UPPER = BlockRegistry.BLUE_WISTERIA_VINE.func_176223_P();
                this.VINE_LOWER = (BlockState)BlockRegistry.BLUE_WISTERIA_VINE.func_176223_P().func_206870_a(WisteriaVineBlock.HALF, (Comparable)DoubleBlockHalf.LOWER);
            }
        }
    }

    public boolean func_208519_a(Set<BlockPos> changedBlocks, IWorldGenerationReader world, Random random, BlockPos pos, MutableBoundingBox boundingBox) {
        int height = random.nextInt(7) + 5;
        boolean flag = true;
        if (pos.func_177956_o() >= 1 && pos.func_177956_o() + height + 1 <= world.getMaxHeight()) {
            for (int j = pos.func_177956_o(); j <= pos.func_177956_o() + 1 + height; ++j) {
                int k = 1;
                if (j == pos.func_177956_o()) {
                    k = 0;
                }
                if (j >= pos.func_177956_o() + 1 + height - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int l = pos.func_177958_n() - k; l <= pos.func_177958_n() + k && flag; ++l) {
                    for (int i1 = pos.func_177952_p() - k; i1 <= pos.func_177952_p() + k && flag; ++i1) {
                        if (j >= 0 && j < world.getMaxHeight()) {
                            if (BigWisteriaTreeFeature.func_214587_a((IWorldGenerationBaseReader)world, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            if (BigWisteriaTreeFeature.isSoil((IWorldGenerationBaseReader)world, (BlockPos)pos.func_177977_b(), (IPlantable)this.getSapling()) && pos.func_177956_o() < world.getMaxHeight() - height - 1) {
                this.setDirtAt(world, pos.func_177977_b(), pos);
                for (int k = 0; k < 3; ++k) {
                    BlockPos position = new BlockPos((Vec3i)pos.func_177982_a(0, random.nextInt(3) + 4, 0));
                    boolean xNeg = random.nextBoolean();
                    boolean zNeg = random.nextBoolean();
                    int size = random.nextInt(3) + 5;
                    for (int j = 1; j <= size; ++j) {
                        position = position.func_177982_a(random.nextInt(2) - (xNeg ? 1 : 0), random.nextInt(2), random.nextInt(2) - (zNeg ? 1 : 0));
                        this.func_208520_a(changedBlocks, (IWorldWriter)world, position, this.LOG, boundingBox);
                        if (j != size) continue;
                        for (int y = 4; y > -4; --y) {
                            for (int x = 4; x > -4; --x) {
                                for (int z = 4; z > -4; --z) {
                                    int n = y > 0 ? y * y : 0;
                                    if (!(Math.sqrt(x * x + n + z * z) <= 4.0)) continue;
                                    BlockPos leafPos = position.func_177982_a(x, y, z);
                                    boolean place = true;
                                    if (y < 0 && (place = world.func_217375_a(leafPos.func_177982_a(0, 1, 0), state -> state.func_203425_a(BlockTags.field_206952_E))) && random.nextInt(Math.abs(y) + 1) != 0) {
                                        place = false;
                                        if (random.nextInt(5) == 0 && !WisteriaTreeUtils.isLog((IWorldGenerationBaseReader)world, leafPos)) {
                                            this.placeVines(changedBlocks, world, random, leafPos, this.LEAF, this.VINE_LOWER, this.VINE_UPPER, boundingBox);
                                        }
                                    }
                                    if (!place) continue;
                                    this.placeLeafAt(changedBlocks, world, leafPos, boundingBox);
                                }
                            }
                        }
                    }
                }
                for (int i2 = 0; i2 < height; ++i2) {
                    if (!WisteriaTreeUtils.isAirOrLeavesOrVines((IWorldGenerationBaseReader)world, pos.func_177981_b(i2))) continue;
                    this.func_208520_a(changedBlocks, (IWorldWriter)world, pos.func_177981_b(i2), this.LOG, boundingBox);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void placeVines(Set<BlockPos> changedBlocks, IWorldGenerationReader world, Random random, BlockPos pos, BlockState leaf, BlockState vineLower, BlockState vineUpper, MutableBoundingBox boundingBox) {
        int length = WisteriaTreeUtils.getLengthByNeighbors(world, random, pos);
        if (random.nextInt(6) != 5 && BigWisteriaTreeFeature.func_214574_b((IWorldGenerationBaseReader)world, (BlockPos)pos) && !WisteriaTreeUtils.isLog((IWorldGenerationBaseReader)world, pos)) {
            switch (length) {
                case 0: {
                    break;
                }
                case 1: {
                    if (!BigWisteriaTreeFeature.func_214574_b((IWorldGenerationBaseReader)world, (BlockPos)pos)) break;
                    this.setForcedState(changedBlocks, (IWorldWriter)world, pos, vineLower, boundingBox);
                    break;
                }
                case 2: {
                    if (BigWisteriaTreeFeature.func_214574_b((IWorldGenerationBaseReader)world, (BlockPos)pos)) {
                        this.setForcedState(changedBlocks, (IWorldWriter)world, pos, vineUpper, boundingBox);
                    }
                    if (!BigWisteriaTreeFeature.func_214574_b((IWorldGenerationBaseReader)world, (BlockPos)pos.func_177977_b())) break;
                    this.setForcedState(changedBlocks, (IWorldWriter)world, pos.func_177977_b(), vineLower, boundingBox);
                    break;
                }
                case 3: {
                    if (BigWisteriaTreeFeature.func_214574_b((IWorldGenerationBaseReader)world, (BlockPos)pos)) {
                        this.placeLeafAt(changedBlocks, world, pos, boundingBox);
                    }
                    if (BigWisteriaTreeFeature.func_214574_b((IWorldGenerationBaseReader)world, (BlockPos)pos.func_177977_b())) {
                        this.setForcedState(changedBlocks, (IWorldWriter)world, pos.func_177977_b(), vineUpper, boundingBox);
                    }
                    if (!BigWisteriaTreeFeature.func_214574_b((IWorldGenerationBaseReader)world, (BlockPos)pos.func_177979_c(2))) break;
                    this.setForcedState(changedBlocks, (IWorldWriter)world, pos.func_177979_c(2), vineLower, boundingBox);
                    break;
                }
                case 4: {
                    if (BigWisteriaTreeFeature.func_214574_b((IWorldGenerationBaseReader)world, (BlockPos)pos)) {
                        this.placeLeafAt(changedBlocks, world, pos, boundingBox);
                    }
                    if (BigWisteriaTreeFeature.func_214574_b((IWorldGenerationBaseReader)world, (BlockPos)pos.func_177977_b())) {
                        this.placeLeafAt(changedBlocks, world, pos.func_177977_b(), boundingBox);
                    }
                    if (BigWisteriaTreeFeature.func_214574_b((IWorldGenerationBaseReader)world, (BlockPos)pos.func_177979_c(2))) {
                        this.setForcedState(changedBlocks, (IWorldWriter)world, pos.func_177979_c(2), vineUpper, boundingBox);
                    }
                    if (!BigWisteriaTreeFeature.func_214574_b((IWorldGenerationBaseReader)world, (BlockPos)pos.func_177979_c(3))) break;
                    this.setForcedState(changedBlocks, (IWorldWriter)world, pos.func_177979_c(3), vineLower, boundingBox);
                    break;
                }
                case 5: {
                    if (BigWisteriaTreeFeature.func_214574_b((IWorldGenerationBaseReader)world, (BlockPos)pos)) {
                        this.placeLeafAt(changedBlocks, world, pos, boundingBox);
                    }
                    if (BigWisteriaTreeFeature.func_214574_b((IWorldGenerationBaseReader)world, (BlockPos)pos.func_177977_b())) {
                        this.placeLeafAt(changedBlocks, world, pos.func_177977_b(), boundingBox);
                    }
                    if (BigWisteriaTreeFeature.func_214574_b((IWorldGenerationBaseReader)world, (BlockPos)pos.func_177979_c(2))) {
                        this.placeLeafAt(changedBlocks, world, pos.func_177979_c(2), boundingBox);
                    }
                    if (BigWisteriaTreeFeature.func_214574_b((IWorldGenerationBaseReader)world, (BlockPos)pos.func_177979_c(3))) {
                        this.setForcedState(changedBlocks, (IWorldWriter)world, pos.func_177979_c(3), vineUpper, boundingBox);
                    }
                    if (!BigWisteriaTreeFeature.func_214574_b((IWorldGenerationBaseReader)world, (BlockPos)pos.func_177979_c(4))) break;
                    this.setForcedState(changedBlocks, (IWorldWriter)world, pos.func_177979_c(4), vineLower, boundingBox);
                }
            }
        }
    }

    private void placeLeafAt(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, BlockPos pos, MutableBoundingBox boundingBox) {
        if (BigWisteriaTreeFeature.func_214572_g((IWorldGenerationBaseReader)worldIn, (BlockPos)pos)) {
            this.func_208520_a(changedBlocks, (IWorldWriter)worldIn, pos, this.LEAF, boundingBox);
        }
    }

    private void setForcedState(Set<BlockPos> changedBlocks, IWorldWriter worldIn, BlockPos pos, BlockState state, MutableBoundingBox boundingBox) {
        if (this.field_76488_a) {
            worldIn.func_180501_a(pos, state, 19);
        } else {
            worldIn.func_180501_a(pos, state, 18);
        }
        boundingBox.func_78888_b(new MutableBoundingBox((Vec3i)pos, (Vec3i)pos));
        changedBlocks.add(pos.func_185334_h());
    }
}

