/*
 * Decompiled with CFR 0.152.
 */
package com.pugz.bloomful.common.world.gen.feature;

import com.mojang.datafixers.Dynamic;
import com.pugz.bloomful.common.block.WisteriaVineBlock;
import com.pugz.bloomful.core.registry.BlockRegistry;
import com.pugz.bloomful.core.util.BiomeFeatures;
import com.pugz.bloomful.core.util.WisteriaColor;
import com.pugz.bloomful.core.util.WisteriaTreeUtils;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.registries.ForgeRegistries;

public class WisteriaTreeFeature
extends AbstractTreeFeature<NoFeatureConfig> {
    private final BlockState LOG = BlockRegistry.WISTERIA_LOG.func_176223_P();
    private BlockState LEAF;
    private BlockState VINE_UPPER;
    private BlockState VINE_LOWER;

    public WisteriaTreeFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> configIn, boolean doBlockNotifyIn, WisteriaColor color) {
        super(configIn, doBlockNotifyIn);
        this.setBlocksByColor(color);
    }

    private void setBlocksByColor(WisteriaColor color) {
        switch (color) {
            case PURPLE: {
                this.LEAF = BlockRegistry.PURPLE_WISTERIA_LEAVES.func_176223_P();
                this.VINE_UPPER = BlockRegistry.PURPLE_WISTERIA_VINE.func_176223_P();
                this.VINE_LOWER = (BlockState)BlockRegistry.PURPLE_WISTERIA_VINE.func_176223_P().func_206870_a(WisteriaVineBlock.HALF, (Comparable)DoubleBlockHalf.LOWER);
                break;
            }
            case WHITE: {
                this.LEAF = BlockRegistry.WHITE_WISTERIA_LEAVES.func_176223_P();
                this.VINE_UPPER = BlockRegistry.WHITE_WISTERIA_VINE.func_176223_P();
                this.VINE_LOWER = (BlockState)BlockRegistry.WHITE_WISTERIA_VINE.func_176223_P().func_206870_a(WisteriaVineBlock.HALF, (Comparable)DoubleBlockHalf.LOWER);
                break;
            }
            case PINK: {
                this.LEAF = BlockRegistry.PINK_WISTERIA_LEAVES.func_176223_P();
                this.VINE_UPPER = BlockRegistry.PINK_WISTERIA_VINE.func_176223_P();
                this.VINE_LOWER = (BlockState)BlockRegistry.PINK_WISTERIA_VINE.func_176223_P().func_206870_a(WisteriaVineBlock.HALF, (Comparable)DoubleBlockHalf.LOWER);
                break;
            }
            case BLUE: {
                this.LEAF = BlockRegistry.BLUE_WISTERIA_LEAVES.func_176223_P();
                this.VINE_UPPER = BlockRegistry.BLUE_WISTERIA_VINE.func_176223_P();
                this.VINE_LOWER = (BlockState)BlockRegistry.BLUE_WISTERIA_VINE.func_176223_P().func_206870_a(WisteriaVineBlock.HALF, (Comparable)DoubleBlockHalf.LOWER);
            }
        }
    }

    public boolean func_208519_a(Set<BlockPos> changedBlocks, IWorldGenerationReader world, Random random, BlockPos pos, MutableBoundingBox boundingBox) {
        int height = random.nextInt(7) + 5;
        boolean flag = true;
        if (pos.func_177956_o() >= 1 && pos.func_177956_o() + height + 1 <= world.getMaxHeight()) {
            for (int j = pos.func_177956_o(); j <= pos.func_177956_o() + 1 + height; ++j) {
                int k = 1;
                if (j == pos.func_177956_o()) {
                    k = 0;
                }
                if (j >= pos.func_177956_o() + 1 + height - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int l = pos.func_177958_n() - k; l <= pos.func_177958_n() + k && flag; ++l) {
                    for (int i1 = pos.func_177952_p() - k; i1 <= pos.func_177952_p() + k && flag; ++i1) {
                        if (j >= 0 && j < world.getMaxHeight()) {
                            if (WisteriaTreeFeature.func_214587_a((IWorldGenerationBaseReader)world, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            if (WisteriaTreeFeature.isSoil((IWorldGenerationBaseReader)world, (BlockPos)pos.func_177977_b(), (IPlantable)this.getSapling()) && pos.func_177956_o() < world.getMaxHeight() - height - 1) {
                this.setDirtAt(world, pos.func_177977_b(), pos);
                for (int y = 4; y > -4; --y) {
                    for (int x = 4; x > -4; --x) {
                        for (int z = 4; z > -4; --z) {
                            int n = y > 0 ? y * y : 0;
                            if (!(Math.sqrt(x * x + n + z * z) <= 4.0)) continue;
                            BlockPos leafPos = pos.func_177982_a(x, y + height, z);
                            boolean place = true;
                            if (y < 0 && (place = world.func_217375_a(leafPos.func_177982_a(0, 1, 0), state -> state.func_203425_a(BlockTags.field_206952_E))) && random.nextInt(Math.abs(y) + 1) != 0) {
                                place = false;
                                if (random.nextInt(4) == 0 && !WisteriaTreeUtils.isLog((IWorldGenerationBaseReader)world, leafPos)) {
                                    this.placeVines(changedBlocks, world, random, leafPos, this.LEAF, this.VINE_LOWER, this.VINE_UPPER, boundingBox);
                                }
                            }
                            if (!place) continue;
                            this.placeLeafAt(changedBlocks, world, leafPos, boundingBox);
                        }
                    }
                }
                for (int i2 = 0; i2 < height; ++i2) {
                    if (!WisteriaTreeUtils.isAirOrLeavesOrVines((IWorldGenerationBaseReader)world, pos.func_177981_b(i2))) continue;
                    this.func_208520_a(changedBlocks, (IWorldWriter)world, pos.func_177981_b(i2), this.LOG, boundingBox);
                }
                this.placeBranch(changedBlocks, world, random, pos.func_177977_b(), pos.func_177981_b(height).func_177956_o(), boundingBox);
                if (random.nextInt(4) == 0) {
                    this.placeBranch(changedBlocks, world, random, pos.func_177977_b(), pos.func_177981_b(height).func_177956_o(), boundingBox);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void placeBranch(Set<BlockPos> changedBlocks, IWorldGenerationReader world, Random random, BlockPos pos, int treeHeight, MutableBoundingBox boundingBox) {
        int heightOffset = random.nextInt(3);
        BlockPos[] startPositions = new BlockPos[]{new BlockPos(pos.func_177958_n() - 1, treeHeight - heightOffset, pos.func_177952_p()), new BlockPos(pos.func_177958_n() + 1, treeHeight - heightOffset, pos.func_177952_p()), new BlockPos(pos.func_177958_n(), treeHeight - heightOffset, pos.func_177952_p() - 1), new BlockPos(pos.func_177958_n(), treeHeight - heightOffset, pos.func_177952_p() + 1), new BlockPos(pos.func_177958_n() - 1, treeHeight - heightOffset, pos.func_177952_p() - 1), new BlockPos(pos.func_177958_n() + 1, treeHeight - heightOffset, pos.func_177952_p() - 1), new BlockPos(pos.func_177958_n() - 1, treeHeight - heightOffset, pos.func_177952_p() + 1), new BlockPos(pos.func_177958_n() + 1, treeHeight - heightOffset, pos.func_177952_p() + 1)};
        BlockPos startPos = startPositions[random.nextInt(8)];
        if (WisteriaTreeUtils.isAirOrLeavesOrVines((IWorldGenerationBaseReader)world, startPos)) {
            boolean vines = random.nextInt(6) != 5;
            BlockPos placePos = startPos;
            for (int y = treeHeight - heightOffset; y <= treeHeight; ++y) {
                placePos = new BlockPos(startPos.func_177958_n(), y, startPos.func_177952_p());
                if (!WisteriaTreeUtils.isAirOrLeavesOrVines((IWorldGenerationBaseReader)world, placePos)) continue;
                this.func_208520_a(changedBlocks, (IWorldWriter)world, placePos, this.LOG, boundingBox);
            }
            this.placeLeafAt(changedBlocks, world, placePos.func_177984_a(), boundingBox);
            if (vines) {
                this.placeVines(changedBlocks, world, random, startPos.func_177977_b(), this.LEAF, this.VINE_LOWER, this.VINE_UPPER, boundingBox);
            }
        }
    }

    private void placeVines(Set<BlockPos> changedBlocks, IWorldGenerationReader world, Random random, BlockPos pos, BlockState leaf, BlockState vineLower, BlockState vineUpper, MutableBoundingBox boundingBox) {
        int length = WisteriaTreeUtils.getLengthByNeighbors(world, random, pos);
        if (random.nextInt(6) != 5 && WisteriaTreeFeature.func_214574_b((IWorldGenerationBaseReader)world, (BlockPos)pos) && !WisteriaTreeUtils.isLog((IWorldGenerationBaseReader)world, pos)) {
            switch (length) {
                case 0: {
                    break;
                }
                case 1: {
                    if (!WisteriaTreeFeature.func_214574_b((IWorldGenerationBaseReader)world, (BlockPos)pos)) break;
                    this.setForcedState(changedBlocks, (IWorldWriter)world, pos, vineLower, boundingBox);
                    break;
                }
                case 2: {
                    if (WisteriaTreeFeature.func_214574_b((IWorldGenerationBaseReader)world, (BlockPos)pos)) {
                        this.setForcedState(changedBlocks, (IWorldWriter)world, pos, vineUpper, boundingBox);
                    }
                    if (!WisteriaTreeFeature.func_214574_b((IWorldGenerationBaseReader)world, (BlockPos)pos.func_177977_b())) break;
                    this.setForcedState(changedBlocks, (IWorldWriter)world, pos.func_177977_b(), vineLower, boundingBox);
                    break;
                }
                case 3: {
                    if (WisteriaTreeFeature.func_214574_b((IWorldGenerationBaseReader)world, (BlockPos)pos)) {
                        this.placeLeafAt(changedBlocks, world, pos, boundingBox);
                    }
                    if (WisteriaTreeFeature.func_214574_b((IWorldGenerationBaseReader)world, (BlockPos)pos.func_177977_b())) {
                        this.setForcedState(changedBlocks, (IWorldWriter)world, pos.func_177977_b(), vineUpper, boundingBox);
                    }
                    if (!WisteriaTreeFeature.func_214574_b((IWorldGenerationBaseReader)world, (BlockPos)pos.func_177979_c(2))) break;
                    this.setForcedState(changedBlocks, (IWorldWriter)world, pos.func_177979_c(2), vineLower, boundingBox);
                    break;
                }
                case 4: {
                    if (WisteriaTreeFeature.func_214574_b((IWorldGenerationBaseReader)world, (BlockPos)pos)) {
                        this.placeLeafAt(changedBlocks, world, pos, boundingBox);
                    }
                    if (WisteriaTreeFeature.func_214574_b((IWorldGenerationBaseReader)world, (BlockPos)pos.func_177977_b())) {
                        this.placeLeafAt(changedBlocks, world, pos.func_177977_b(), boundingBox);
                    }
                    if (WisteriaTreeFeature.func_214574_b((IWorldGenerationBaseReader)world, (BlockPos)pos.func_177979_c(2))) {
                        this.setForcedState(changedBlocks, (IWorldWriter)world, pos.func_177979_c(2), vineUpper, boundingBox);
                    }
                    if (!WisteriaTreeFeature.func_214574_b((IWorldGenerationBaseReader)world, (BlockPos)pos.func_177979_c(3))) break;
                    this.setForcedState(changedBlocks, (IWorldWriter)world, pos.func_177979_c(3), vineLower, boundingBox);
                    break;
                }
                case 5: {
                    if (WisteriaTreeFeature.func_214574_b((IWorldGenerationBaseReader)world, (BlockPos)pos)) {
                        this.placeLeafAt(changedBlocks, world, pos, boundingBox);
                    }
                    if (WisteriaTreeFeature.func_214574_b((IWorldGenerationBaseReader)world, (BlockPos)pos.func_177977_b())) {
                        this.placeLeafAt(changedBlocks, world, pos.func_177977_b(), boundingBox);
                    }
                    if (WisteriaTreeFeature.func_214574_b((IWorldGenerationBaseReader)world, (BlockPos)pos.func_177979_c(2))) {
                        this.placeLeafAt(changedBlocks, world, pos.func_177979_c(2), boundingBox);
                    }
                    if (WisteriaTreeFeature.func_214574_b((IWorldGenerationBaseReader)world, (BlockPos)pos.func_177979_c(3))) {
                        this.setForcedState(changedBlocks, (IWorldWriter)world, pos.func_177979_c(3), vineUpper, boundingBox);
                    }
                    if (!WisteriaTreeFeature.func_214574_b((IWorldGenerationBaseReader)world, (BlockPos)pos.func_177979_c(4))) break;
                    this.setForcedState(changedBlocks, (IWorldWriter)world, pos.func_177979_c(4), vineLower, boundingBox);
                }
            }
        }
    }

    private void placeLeafAt(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, BlockPos pos, MutableBoundingBox boundingBox) {
        if (WisteriaTreeUtils.isAirOrLeavesOrVines((IWorldGenerationBaseReader)worldIn, pos)) {
            this.func_208520_a(changedBlocks, (IWorldWriter)worldIn, pos, this.LEAF, boundingBox);
        }
    }

    private void setForcedState(Set<BlockPos> changedBlocks, IWorldWriter worldIn, BlockPos pos, BlockState state, MutableBoundingBox boundingBox) {
        if (this.field_76488_a) {
            worldIn.func_180501_a(pos, state, 19);
        } else {
            worldIn.func_180501_a(pos, state, 18);
        }
        boundingBox.func_78888_b(new MutableBoundingBox((Vec3i)pos, (Vec3i)pos));
        changedBlocks.add(pos.func_185334_h());
    }

    public static void addFeature() {
        ForgeRegistries.BIOMES.getValues().forEach(WisteriaTreeFeature::generate);
    }

    public static void generate(Biome biome) {
        if (biome.func_201856_r() == Biome.Category.JUNGLE) {
            BiomeFeatures.addWisteriaTree(biome, WisteriaColor.PINK, 0, 0.25f);
        } else if (biome.func_201856_r() == Biome.Category.SWAMP) {
            BiomeFeatures.addWisteriaTree(biome, WisteriaColor.BLUE, 0, 0.025f);
        } else if (biome.func_201856_r() == Biome.Category.PLAINS) {
            BiomeFeatures.addNoBirchTrees(biome, 0, 0.01f);
        } else if (biome.func_201856_r() == Biome.Category.FOREST) {
            if (biome == Biomes.field_185444_T || biome == Biomes.field_150585_R || biome == Biomes.field_185430_ab) {
                BiomeFeatures.addWisteriaTrees(biome, 0, 0.1f);
            } else {
                BiomeFeatures.addNoBirchTrees(biome, 0, 0.025f);
            }
        }
    }
}

