/*
 * Decompiled with CFR 0.152.
 */
package com.pugz.bloomful.core.registry;

import com.google.common.collect.Maps;
import com.pugz.bloomful.common.block.BloomfulSaplingBlock;
import com.pugz.bloomful.common.block.BookshelfBlock;
import com.pugz.bloomful.common.block.LadderBlock;
import com.pugz.bloomful.common.block.LeafCarpetBlock;
import com.pugz.bloomful.common.block.VerticalSlabBlock;
import com.pugz.bloomful.common.block.WisteriaLeavesBlock;
import com.pugz.bloomful.common.block.WisteriaVineBlock;
import com.pugz.bloomful.common.item.FuelItem;
import com.pugz.bloomful.common.world.gen.feature.trees.WisteriaTree;
import com.pugz.bloomful.core.util.BlockProperties;
import com.pugz.bloomful.core.util.WisteriaColor;
import java.util.Map;
import net.minecraft.block.BarrelBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.ComposterBlock;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.FireBlock;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.block.LogBlock;
import net.minecraft.block.PressurePlateBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.TallFlowerBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.block.WoodButtonBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.AxeItem;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="bloomful", bus=Mod.EventBusSubscriber.Bus.MOD)
public class BlockRegistry {
    public static Block WISTERIA_LOG = (Block)new LogBlock(MaterialColor.field_193561_M, BlockProperties.WISTERIA_LOG(false)).setRegistryName("wisteria_log");
    public static Block STRIPPED_WISTERIA_LOG = (Block)new LogBlock(MaterialColor.field_193561_M, BlockProperties.WISTERIA_LOG(true)).setRegistryName("stripped_wisteria_log");
    public static Block WISTERIA_WOOD = (Block)new RotatedPillarBlock(BlockProperties.WISTERIA_LOG(false)).setRegistryName("wisteria_wood");
    public static Block STRIPPED_WISTERIA_WOOD = (Block)new RotatedPillarBlock(BlockProperties.WISTERIA_LOG(true)).setRegistryName("stripped_wisteria_wood");
    public static Block WISTERIA_PLANKS = (Block)new Block(BlockProperties.WISTERIA_PLANKS).setRegistryName("wisteria_planks");
    public static Block PINK_WISTERIA_SAPLING = (Block)new BloomfulSaplingBlock(BlockProperties.SAPLING, new WisteriaTree(WisteriaColor.PINK)).setRegistryName("pink_wisteria_sapling");
    public static Block BLUE_WISTERIA_SAPLING = (Block)new BloomfulSaplingBlock(BlockProperties.SAPLING, new WisteriaTree(WisteriaColor.BLUE)).setRegistryName("blue_wisteria_sapling");
    public static Block PURPLE_WISTERIA_SAPLING = (Block)new BloomfulSaplingBlock(BlockProperties.SAPLING, new WisteriaTree(WisteriaColor.PURPLE)).setRegistryName("purple_wisteria_sapling");
    public static Block WHITE_WISTERIA_SAPLING = (Block)new BloomfulSaplingBlock(BlockProperties.SAPLING, new WisteriaTree(WisteriaColor.WHITE)).setRegistryName("white_wisteria_sapling");
    public static Block POTTED_PINK_WISTERIA_SAPLING = (Block)new FlowerPotBlock(PINK_WISTERIA_SAPLING, BlockProperties.FLOWER_POT).setRegistryName("potted_pink_wisteria_sapling");
    public static Block POTTED_BLUE_WISTERIA_SAPLING = (Block)new FlowerPotBlock(BLUE_WISTERIA_SAPLING, BlockProperties.FLOWER_POT).setRegistryName("potted_blue_wisteria_sapling");
    public static Block POTTED_PURPLE_WISTERIA_SAPLING = (Block)new FlowerPotBlock(PURPLE_WISTERIA_SAPLING, BlockProperties.FLOWER_POT).setRegistryName("potted_purple_wisteria_sapling");
    public static Block POTTED_WHITE_WISTERIA_SAPLING = (Block)new FlowerPotBlock(WHITE_WISTERIA_SAPLING, BlockProperties.FLOWER_POT).setRegistryName("potted_white_wisteria_sapling");
    public static Block PINK_WISTERIA_LEAVES = (Block)new WisteriaLeavesBlock(BlockProperties.WISTERIA_LEAVES(MaterialColor.field_151671_v)).setRegistryName("pink_wisteria_leaves");
    public static Block BLUE_WISTERIA_LEAVES = (Block)new WisteriaLeavesBlock(BlockProperties.WISTERIA_LEAVES(MaterialColor.field_151649_A)).setRegistryName("blue_wisteria_leaves");
    public static Block PURPLE_WISTERIA_LEAVES = (Block)new WisteriaLeavesBlock(BlockProperties.WISTERIA_LEAVES(MaterialColor.field_151678_z)).setRegistryName("purple_wisteria_leaves");
    public static Block WHITE_WISTERIA_LEAVES = (Block)new WisteriaLeavesBlock(BlockProperties.WISTERIA_LEAVES(MaterialColor.field_151666_j)).setRegistryName("white_wisteria_leaves");
    public static Block PINK_WISTERIA_VINE = (Block)new WisteriaVineBlock(BlockProperties.WISTERIA_LEAVES(MaterialColor.field_151671_v)).setRegistryName("pink_wisteria_vine");
    public static Block BLUE_WISTERIA_VINE = (Block)new WisteriaVineBlock(BlockProperties.WISTERIA_LEAVES(MaterialColor.field_151649_A)).setRegistryName("blue_wisteria_vine");
    public static Block PURPLE_WISTERIA_VINE = (Block)new WisteriaVineBlock(BlockProperties.WISTERIA_LEAVES(MaterialColor.field_151678_z)).setRegistryName("purple_wisteria_vine");
    public static Block WHITE_WISTERIA_VINE = (Block)new WisteriaVineBlock(BlockProperties.WISTERIA_LEAVES(MaterialColor.field_151666_j)).setRegistryName("white_wisteria_vine");
    public static Block WISTERIA_STAIRS = (Block)new StairsBlock(WISTERIA_PLANKS.func_176223_P(), BlockProperties.WISTERIA_PLANKS).setRegistryName("wisteria_stairs");
    public static Block WISTERIA_SLAB = (Block)new SlabBlock(BlockProperties.WISTERIA_PLANKS).setRegistryName("wisteria_slab");
    public static Block WISTERIA_FENCE = (Block)new FenceBlock(BlockProperties.WISTERIA_PLANKS).setRegistryName("wisteria_fence");
    public static Block WISTERIA_FENCE_GATE = (Block)new FenceGateBlock(BlockProperties.WISTERIA_PLANKS).setRegistryName("wisteria_fence_gate");
    public static Block WISTERIA_TRAPDOOR = (Block)new TrapDoorBlock(BlockProperties.WISTERIA_DOORS).setRegistryName("wisteria_trapdoor");
    public static Block WISTERIA_DOOR = (Block)new DoorBlock(BlockProperties.WISTERIA_DOORS).setRegistryName("wisteria_door");
    public static Block WISTERIA_PRESSURE_PLATE = (Block)new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, Block.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_193561_M).func_200942_a().func_200943_b(0.5f).func_200947_a(SoundType.field_185848_a)).setRegistryName("wisteria_pressure_plate");
    public static Block WISTERIA_BUTTON = (Block)new WoodButtonBlock(BlockProperties.WOOD_BUTTON).setRegistryName("wisteria_button");
    public static Block PINK_DELPHINIUM = (Block)new TallFlowerBlock(BlockProperties.DELPHINIUMS).setRegistryName("pink_delphinium");
    public static Block BLUE_DELPHINIUM = (Block)new TallFlowerBlock(BlockProperties.DELPHINIUMS).setRegistryName("blue_delphinium");
    public static Block PURPLE_DELPHINIUM = (Block)new TallFlowerBlock(BlockProperties.DELPHINIUMS).setRegistryName("purple_delphinium");
    public static Block WHITE_DELPHINIUM = (Block)new TallFlowerBlock(BlockProperties.DELPHINIUMS).setRegistryName("white_delphinium");
    public static Block WISTERIA_BOOKSHELF = (Block)new BookshelfBlock(BlockProperties.BOOKSHELF).setRegistryName("wisteria_bookshelf");
    public static Block WISTERIA_LADDER = (Block)new LadderBlock(BlockProperties.LADDER).setRegistryName("wisteria_ladder");
    public static Block VERTICAL_WISTERIA_PLANKS = (Block)new Block(BlockProperties.WISTERIA_PLANKS).setRegistryName("vertical_wisteria_planks");
    public static Block PINK_WISTERIA_LEAF_CARPET = (Block)new LeafCarpetBlock(BlockProperties.WISTERIA_LEAVES(MaterialColor.field_151671_v)).setRegistryName("pink_wisteria_leaf_carpet");
    public static Block BLUE_WISTERIA_LEAF_CARPET = (Block)new LeafCarpetBlock(BlockProperties.WISTERIA_LEAVES(MaterialColor.field_151649_A)).setRegistryName("blue_wisteria_leaf_carpet");
    public static Block PURPLE_WISTERIA_LEAF_CARPET = (Block)new LeafCarpetBlock(BlockProperties.WISTERIA_LEAVES(MaterialColor.field_151678_z)).setRegistryName("purple_wisteria_leaf_carpet");
    public static Block WHITE_WISTERIA_LEAF_CARPET = (Block)new LeafCarpetBlock(BlockProperties.WISTERIA_LEAVES(MaterialColor.field_151666_j)).setRegistryName("white_wisteria_leaf_carpet");
    public static Block VERTICAL_WISTERIA_SLAB = (Block)new VerticalSlabBlock(BlockProperties.WISTERIA_PLANKS).setRegistryName("vertical_wisteria_slab");
    public static Block WISTERIA_BARREL = (Block)new BarrelBlock(BlockProperties.CHEST).setRegistryName("wisteria_barrel");

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{WISTERIA_LOG, STRIPPED_WISTERIA_LOG, WISTERIA_WOOD, STRIPPED_WISTERIA_WOOD, WISTERIA_PLANKS, PINK_WISTERIA_SAPLING, BLUE_WISTERIA_SAPLING, PURPLE_WISTERIA_SAPLING, WHITE_WISTERIA_SAPLING, POTTED_PINK_WISTERIA_SAPLING, POTTED_BLUE_WISTERIA_SAPLING, POTTED_PURPLE_WISTERIA_SAPLING, POTTED_WHITE_WISTERIA_SAPLING, PINK_WISTERIA_LEAVES, BLUE_WISTERIA_LEAVES, PURPLE_WISTERIA_LEAVES, WHITE_WISTERIA_LEAVES, PINK_WISTERIA_VINE, BLUE_WISTERIA_VINE, PURPLE_WISTERIA_VINE, WHITE_WISTERIA_VINE, WISTERIA_STAIRS, WISTERIA_SLAB, WISTERIA_FENCE, WISTERIA_FENCE_GATE, WISTERIA_TRAPDOOR, WISTERIA_DOOR, WISTERIA_PRESSURE_PLATE, WISTERIA_BUTTON, PINK_DELPHINIUM, BLUE_DELPHINIUM, PURPLE_DELPHINIUM, WHITE_DELPHINIUM});
        if (ModList.get().isLoaded("quark")) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{WISTERIA_BOOKSHELF, WISTERIA_LADDER, VERTICAL_WISTERIA_PLANKS, VERTICAL_WISTERIA_SLAB, PINK_WISTERIA_LEAF_CARPET, BLUE_WISTERIA_LEAF_CARPET, PURPLE_WISTERIA_LEAF_CARPET, WHITE_WISTERIA_LEAF_CARPET});
        }
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        Item.Properties buildingBlocks = new Item.Properties().func_200916_a(ItemGroup.field_78030_b);
        Item.Properties decorations = new Item.Properties().func_200916_a(ItemGroup.field_78031_c);
        Item.Properties redstone = new Item.Properties().func_200916_a(ItemGroup.field_78028_d);
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{(Item)new BlockItem(WISTERIA_LOG, buildingBlocks).setRegistryName(WISTERIA_LOG.getRegistryName()), (Item)new BlockItem(STRIPPED_WISTERIA_LOG, buildingBlocks).setRegistryName(STRIPPED_WISTERIA_LOG.getRegistryName()), (Item)new BlockItem(WISTERIA_WOOD, buildingBlocks).setRegistryName(WISTERIA_WOOD.getRegistryName()), (Item)new BlockItem(STRIPPED_WISTERIA_WOOD, buildingBlocks).setRegistryName(STRIPPED_WISTERIA_WOOD.getRegistryName()), (Item)new BlockItem(WISTERIA_PLANKS, buildingBlocks).setRegistryName(WISTERIA_PLANKS.getRegistryName()), (Item)new BlockItem(WISTERIA_SLAB, buildingBlocks).setRegistryName(WISTERIA_SLAB.getRegistryName()), (Item)new BlockItem(WISTERIA_STAIRS, buildingBlocks).setRegistryName(WISTERIA_STAIRS.getRegistryName()), (Item)new BlockItem(WISTERIA_FENCE, decorations).setRegistryName(WISTERIA_FENCE.getRegistryName()), (Item)new BlockItem(PINK_WISTERIA_LEAVES, decorations).setRegistryName(PINK_WISTERIA_LEAVES.getRegistryName()), (Item)new BlockItem(BLUE_WISTERIA_LEAVES, decorations).setRegistryName(BLUE_WISTERIA_LEAVES.getRegistryName()), (Item)new BlockItem(PURPLE_WISTERIA_LEAVES, decorations).setRegistryName(PURPLE_WISTERIA_LEAVES.getRegistryName()), (Item)new BlockItem(WHITE_WISTERIA_LEAVES, decorations).setRegistryName(WHITE_WISTERIA_LEAVES.getRegistryName()), (Item)new BlockItem(PINK_WISTERIA_VINE, decorations).setRegistryName(PINK_WISTERIA_VINE.getRegistryName()), (Item)new BlockItem(BLUE_WISTERIA_VINE, decorations).setRegistryName(BLUE_WISTERIA_VINE.getRegistryName()), (Item)new BlockItem(PURPLE_WISTERIA_VINE, decorations).setRegistryName(PURPLE_WISTERIA_VINE.getRegistryName()), (Item)new BlockItem(WHITE_WISTERIA_VINE, decorations).setRegistryName(WHITE_WISTERIA_VINE.getRegistryName()), (Item)new BlockItem(PINK_WISTERIA_SAPLING, decorations).setRegistryName(PINK_WISTERIA_SAPLING.getRegistryName()), (Item)new BlockItem(BLUE_WISTERIA_SAPLING, decorations).setRegistryName(BLUE_WISTERIA_SAPLING.getRegistryName()), (Item)new BlockItem(PURPLE_WISTERIA_SAPLING, decorations).setRegistryName(PURPLE_WISTERIA_SAPLING.getRegistryName()), (Item)new BlockItem(WHITE_WISTERIA_SAPLING, decorations).setRegistryName(WHITE_WISTERIA_SAPLING.getRegistryName()), (Item)new BlockItem(WISTERIA_FENCE_GATE, redstone).setRegistryName(WISTERIA_FENCE_GATE.getRegistryName()), (Item)new BlockItem(WISTERIA_TRAPDOOR, redstone).setRegistryName(WISTERIA_TRAPDOOR.getRegistryName()), (Item)new BlockItem(WISTERIA_DOOR, redstone).setRegistryName(WISTERIA_DOOR.getRegistryName()), (Item)new BlockItem(WISTERIA_PRESSURE_PLATE, redstone).setRegistryName(WISTERIA_PRESSURE_PLATE.getRegistryName()), (Item)new BlockItem(WISTERIA_BUTTON, redstone).setRegistryName(WISTERIA_BUTTON.getRegistryName()), (Item)new BlockItem(PINK_DELPHINIUM, decorations).setRegistryName(PINK_DELPHINIUM.getRegistryName()), (Item)new BlockItem(BLUE_DELPHINIUM, decorations).setRegistryName(BLUE_DELPHINIUM.getRegistryName()), (Item)new BlockItem(PURPLE_DELPHINIUM, decorations).setRegistryName(PURPLE_DELPHINIUM.getRegistryName()), (Item)new BlockItem(WHITE_DELPHINIUM, decorations).setRegistryName(WHITE_DELPHINIUM.getRegistryName())});
        if (ModList.get().isLoaded("quark")) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{(Item)new FuelItem(WISTERIA_BOOKSHELF, buildingBlocks, 300).setRegistryName(WISTERIA_BOOKSHELF.getRegistryName()), (Item)new FuelItem(WISTERIA_LADDER, decorations, 300).setRegistryName(WISTERIA_LADDER.getRegistryName()), (Item)new BlockItem(VERTICAL_WISTERIA_PLANKS, buildingBlocks).setRegistryName(VERTICAL_WISTERIA_PLANKS.getRegistryName()), (Item)new BlockItem(PINK_WISTERIA_LEAF_CARPET, decorations).setRegistryName(PINK_WISTERIA_LEAF_CARPET.getRegistryName()), (Item)new BlockItem(BLUE_WISTERIA_LEAF_CARPET, decorations).setRegistryName(BLUE_WISTERIA_LEAF_CARPET.getRegistryName()), (Item)new BlockItem(PURPLE_WISTERIA_LEAF_CARPET, decorations).setRegistryName(PURPLE_WISTERIA_LEAF_CARPET.getRegistryName()), (Item)new BlockItem(WHITE_WISTERIA_LEAF_CARPET, decorations).setRegistryName(WHITE_WISTERIA_LEAF_CARPET.getRegistryName()), (Item)new FuelItem(VERTICAL_WISTERIA_SLAB, buildingBlocks, 150).setRegistryName(VERTICAL_WISTERIA_SLAB.getRegistryName())});
        }
    }

    public static void registerBlockData() {
        BlockRegistry.registerCompostable((IItemProvider)BLUE_DELPHINIUM, 0.75f);
        BlockRegistry.registerCompostable((IItemProvider)WHITE_DELPHINIUM, 0.75f);
        BlockRegistry.registerCompostable((IItemProvider)PINK_DELPHINIUM, 0.75f);
        BlockRegistry.registerCompostable((IItemProvider)PURPLE_DELPHINIUM, 0.75f);
        BlockRegistry.registerCompostable((IItemProvider)BLUE_WISTERIA_LEAVES, 0.35f);
        BlockRegistry.registerCompostable((IItemProvider)WHITE_WISTERIA_LEAVES, 0.35f);
        BlockRegistry.registerCompostable((IItemProvider)PINK_WISTERIA_LEAVES, 0.35f);
        BlockRegistry.registerCompostable((IItemProvider)PURPLE_WISTERIA_LEAVES, 0.35f);
        BlockRegistry.registerCompostable((IItemProvider)BLUE_WISTERIA_VINE, 0.35f);
        BlockRegistry.registerCompostable((IItemProvider)WHITE_WISTERIA_VINE, 0.35f);
        BlockRegistry.registerCompostable((IItemProvider)PINK_WISTERIA_VINE, 0.35f);
        BlockRegistry.registerCompostable((IItemProvider)PURPLE_WISTERIA_VINE, 0.35f);
        BlockRegistry.registerCompostable((IItemProvider)BLUE_WISTERIA_SAPLING, 0.35f);
        BlockRegistry.registerCompostable((IItemProvider)WHITE_WISTERIA_SAPLING, 0.35f);
        BlockRegistry.registerCompostable((IItemProvider)PINK_WISTERIA_SAPLING, 0.35f);
        BlockRegistry.registerCompostable((IItemProvider)PURPLE_WISTERIA_SAPLING, 0.35f);
        BlockRegistry.registerCompostable((IItemProvider)BLUE_WISTERIA_LEAF_CARPET, 0.35f);
        BlockRegistry.registerCompostable((IItemProvider)WHITE_WISTERIA_LEAF_CARPET, 0.35f);
        BlockRegistry.registerCompostable((IItemProvider)PINK_WISTERIA_LEAF_CARPET, 0.35f);
        BlockRegistry.registerCompostable((IItemProvider)PURPLE_WISTERIA_LEAF_CARPET, 0.35f);
        BlockRegistry.registerStrippable(WISTERIA_LOG, STRIPPED_WISTERIA_LOG);
        BlockRegistry.registerStrippable(WISTERIA_WOOD, STRIPPED_WISTERIA_WOOD);
        BlockRegistry.registerFlammable(BLUE_WISTERIA_LEAVES, 30, 60);
        BlockRegistry.registerFlammable(WHITE_WISTERIA_LEAVES, 30, 60);
        BlockRegistry.registerFlammable(PINK_WISTERIA_LEAVES, 30, 60);
        BlockRegistry.registerFlammable(PURPLE_WISTERIA_LEAVES, 30, 60);
        BlockRegistry.registerFlammable(BLUE_WISTERIA_VINE, 30, 60);
        BlockRegistry.registerFlammable(WHITE_WISTERIA_VINE, 30, 60);
        BlockRegistry.registerFlammable(PINK_WISTERIA_VINE, 30, 60);
        BlockRegistry.registerFlammable(PURPLE_WISTERIA_VINE, 30, 60);
        BlockRegistry.registerFlammable(WISTERIA_LOG, 5, 5);
        BlockRegistry.registerFlammable(WISTERIA_WOOD, 5, 5);
        BlockRegistry.registerFlammable(STRIPPED_WISTERIA_LOG, 5, 5);
        BlockRegistry.registerFlammable(STRIPPED_WISTERIA_WOOD, 5, 5);
        BlockRegistry.registerFlammable(WISTERIA_PLANKS, 5, 20);
        BlockRegistry.registerFlammable(WISTERIA_SLAB, 5, 20);
        BlockRegistry.registerFlammable(WISTERIA_STAIRS, 5, 20);
        BlockRegistry.registerFlammable(WISTERIA_FENCE, 5, 20);
        BlockRegistry.registerFlammable(WISTERIA_FENCE_GATE, 5, 20);
        BlockRegistry.registerFlammable(BLUE_DELPHINIUM, 60, 100);
        BlockRegistry.registerFlammable(WHITE_DELPHINIUM, 60, 100);
        BlockRegistry.registerFlammable(PINK_DELPHINIUM, 60, 100);
        BlockRegistry.registerFlammable(PURPLE_DELPHINIUM, 60, 100);
        BlockRegistry.registerFlammable(VERTICAL_WISTERIA_PLANKS, 5, 20);
        BlockRegistry.registerFlammable(BLUE_WISTERIA_LEAF_CARPET, 30, 60);
        BlockRegistry.registerFlammable(WHITE_WISTERIA_LEAF_CARPET, 30, 60);
        BlockRegistry.registerFlammable(PINK_WISTERIA_LEAF_CARPET, 30, 60);
        BlockRegistry.registerFlammable(PURPLE_WISTERIA_LEAF_CARPET, 30, 60);
        BlockRegistry.registerFlammable(VERTICAL_WISTERIA_SLAB, 5, 20);
        BlockRegistry.registerFlammable(WISTERIA_BOOKSHELF, 5, 20);
    }

    public static void registerFlammable(Block block, int encouragement, int flammability) {
        FireBlock fire = (FireBlock)Blocks.field_150480_ab;
        fire.func_180686_a(block, encouragement, flammability);
    }

    public static void registerCompostable(IItemProvider item, float chance) {
        ComposterBlock.field_220299_b.put((Object)item.func_199767_j(), chance);
    }

    public static void registerStrippable(Block log, Block stripped) {
        AxeItem.field_203176_a = Maps.newHashMap((Map)AxeItem.field_203176_a);
        AxeItem.field_203176_a.put(log, stripped);
    }
}

