/*
 * Decompiled with CFR 0.152.
 */
package com.pugz.bloomful.core.registry;

import com.pugz.bloomful.common.entity.ButterflyEntity;
import com.pugz.bloomful.common.entity.WisteriaBoatEntity;
import java.util.function.BiFunction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="bloomful", bus=Mod.EventBusSubscriber.Bus.MOD)
public class EntityRegistry {
    public static Item BUTTERFLY_SPAWN_EGG;
    public static EntityType<WisteriaBoatEntity> WISTERIA_BOAT;
    public static EntityType<ButterflyEntity> BUTTERFLY;

    private static <T extends Entity> EntityType<T> createEntity(EntityType.IFactory<T> factory, EntityClassification entityClassification, String name, float width, float height, int eggPrimary, int eggSecondary) {
        ResourceLocation location = new ResourceLocation("bloomful", name);
        EntityType entity = EntityType.Builder.func_220322_a(factory, (EntityClassification)entityClassification).func_220321_a(width, height).setTrackingRange(64).setShouldReceiveVelocityUpdates(true).setUpdateInterval(3).func_206830_a(location.toString());
        entity.setRegistryName(location);
        BUTTERFLY_SPAWN_EGG = (Item)new SpawnEggItem(entity, eggPrimary, eggSecondary, new Item.Properties().func_200916_a(ItemGroup.field_78026_f)).setRegistryName(entity.getRegistryName() + "_spawn_egg");
        return entity;
    }

    private static <T extends Entity> EntityType<T> createBasicEntity(EntityType.IFactory<T> factory, BiFunction<FMLPlayMessages.SpawnEntity, World, T> clientFactory, EntityClassification entityClassification, String name, float width, float height) {
        ResourceLocation location = new ResourceLocation("bloomful", name);
        EntityType entity = EntityType.Builder.func_220322_a(factory, (EntityClassification)entityClassification).func_220321_a(width, height).setTrackingRange(64).setShouldReceiveVelocityUpdates(true).setUpdateInterval(3).setCustomClientFactory(clientFactory).func_206830_a(location.toString());
        entity.setRegistryName(location);
        return entity;
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new EntityType[]{WISTERIA_BOAT});
    }

    @SubscribeEvent
    public static void registerSpawnEggs(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[0]);
    }

    public static void registerSpawns() {
    }

    static {
        WISTERIA_BOAT = EntityRegistry.createBasicEntity(WisteriaBoatEntity::new, WisteriaBoatEntity::new, EntityClassification.MISC, "wisteria_boat", 1.375f, 0.5625f);
        BUTTERFLY = EntityRegistry.createEntity(ButterflyEntity::new, EntityClassification.AMBIENT, "butterfly", 0.75f, 0.25f, 459542, 15036163);
    }
}

