/*
 * Decompiled with CFR 0.152.
 */
package com.bagel.buzzierbees.common.entities;

import com.bagel.buzzierbees.common.entities.goals.bear.AttackPlayerGoal;
import com.bagel.buzzierbees.common.entities.goals.bear.EatBerriesGoal;
import com.bagel.buzzierbees.common.entities.goals.bear.HurtByTargetGoal;
import com.bagel.buzzierbees.common.entities.goals.bear.PanicGoal;
import com.bagel.buzzierbees.core.registry.BBEntities;
import com.teamabnormals.abnormals_core.core.library.endimator.ControlledEndimation;
import com.teamabnormals.abnormals_core.core.library.endimator.Endimation;
import com.teamabnormals.abnormals_core.core.library.endimator.entity.IEndimatedEntity;
import com.teamabnormals.abnormals_core.core.utils.NetworkUtil;
import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.FoxEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class AbstractBearEntity
extends AnimalEntity
implements IEndimatedEntity {
    private static final DataParameter<Boolean> IS_STANDING = EntityDataManager.func_187226_a(AbstractBearEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_SITTING = EntityDataManager.func_187226_a(AbstractBearEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_SLEEPING = EntityDataManager.func_187226_a(AbstractBearEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private int warningSoundTicks;
    private int animationTick;
    private Endimation playingEndimation = BLANK_ANIMATION;
    public static final Endimation ATTACK = new Endimation(20);
    public static final Endimation SLEEP_DOWN = new Endimation(40);
    public static final Endimation SIT_DOWN = new Endimation(20);
    public static final ControlledEndimation BREATHING = new ControlledEndimation(8, 0);

    public AbstractBearEntity(EntityType<? extends AbstractBearEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public boolean func_70877_b(ItemStack stack) {
        return false;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowParentGoal((AnimalEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(5, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new SleepGoal());
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(10, (Goal)new EatBerriesGoal(this, 1.2f, 12, 2));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new AttackPlayerGoal(this));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, FoxEntity.class, 10, true, true, (Predicate)null));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
    }

    protected SoundEvent func_184639_G() {
        return this.func_70631_g_() ? SoundEvents.field_190027_es : SoundEvents.field_190026_er;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_190029_eu;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_190028_et;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_190030_ev, 0.15f, 1.0f);
    }

    public void playWarningSound() {
        if (this.warningSoundTicks <= 0) {
            this.func_184185_a(SoundEvents.field_190031_ew, 1.0f, this.func_70647_i());
            this.warningSoundTicks = 40;
        }
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)Items.field_196129_cO);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_STANDING, (Object)false);
        this.field_70180_af.func_187214_a(IS_SLEEPING, (Object)false);
        this.field_70180_af.func_187214_a(IS_SITTING, (Object)false);
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        return super.func_184645_a(player, hand);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.endimateTick();
        if (this.warningSoundTicks > 0) {
            --this.warningSoundTicks;
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        if (flag) {
            this.func_174815_a((LivingEntity)this, entityIn);
        }
        return flag;
    }

    public boolean isStanding() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_STANDING);
    }

    public void setStanding(boolean standing) {
        this.field_70180_af.func_187227_b(IS_STANDING, (Object)standing);
        if (standing && !this.field_70170_p.field_72995_K && !this.isEndimationPlaying(ATTACK)) {
            NetworkUtil.setPlayingAnimationMessage((Entity)this, (Endimation)ATTACK);
        }
    }

    public boolean func_70608_bn() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_SLEEPING);
    }

    public void setSleeping(boolean standing) {
        this.field_70180_af.func_187227_b(IS_SLEEPING, (Object)standing);
    }

    public boolean isSitting() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_SITTING);
    }

    public void setSitting(boolean sitting) {
        this.field_70180_af.func_187227_b(IS_SITTING, (Object)sitting);
    }

    protected float func_189749_co() {
        return 0.98f;
    }

    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        if (spawnDataIn == null) {
            spawnDataIn = new AgeableEntity.AgeableData();
            ((AgeableEntity.AgeableData)spawnDataIn).func_226258_a_(1.0f);
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public Endimation[] getEndimations() {
        return new Endimation[]{SLEEP_DOWN, ATTACK, SIT_DOWN};
    }

    public Endimation getPlayingEndimation() {
        return this.playingEndimation;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int animationTick) {
        this.animationTick = animationTick;
    }

    public void setPlayingEndimation(Endimation endimationToPlay) {
        this.onEndimationEnd(this.playingEndimation);
        this.playingEndimation = endimationToPlay;
        this.setAnimationTick(0);
    }

    public AgeableEntity func_90011_a(AgeableEntity ageable) {
        return (AgeableEntity)((EntityType)BBEntities.GRIZZLY_BEAR.get()).func_200721_a(this.field_70170_p);
    }

    class MeleeAttackGoal
    extends net.minecraft.entity.ai.goal.MeleeAttackGoal {
        public MeleeAttackGoal() {
            super((CreatureEntity)AbstractBearEntity.this, 1.25, true);
        }

        protected void func_190102_a(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.func_179512_a(enemy);
            if (distToEnemySqr <= d0 && this.field_75439_d <= 0) {
                this.field_75439_d = 20;
                this.field_75441_b.func_70652_k((Entity)enemy);
                AbstractBearEntity.this.setStanding(false);
            } else if (distToEnemySqr <= d0 * 1.5) {
                if (this.field_75439_d <= 0) {
                    AbstractBearEntity.this.setStanding(false);
                    this.field_75439_d = 20;
                }
                if (this.field_75439_d <= 10) {
                    AbstractBearEntity.this.setStanding(true);
                    AbstractBearEntity.this.playWarningSound();
                }
            } else {
                this.field_75439_d = 20;
                AbstractBearEntity.this.setStanding(false);
            }
        }

        public void func_75251_c() {
            AbstractBearEntity.this.setStanding(false);
            super.func_75251_c();
        }

        protected double func_179512_a(LivingEntity attackTarget) {
            return 4.0f + attackTarget.func_213311_cf();
        }
    }

    public class AlertablePredicate
    implements Predicate<LivingEntity> {
        @Override
        public boolean test(LivingEntity p_test_1_) {
            if (p_test_1_ instanceof FoxEntity) {
                return false;
            }
            if (!(p_test_1_ instanceof ChickenEntity || p_test_1_ instanceof RabbitEntity || p_test_1_ instanceof MonsterEntity)) {
                if (p_test_1_ instanceof TameableEntity) {
                    return !((TameableEntity)p_test_1_).func_70909_n();
                }
                if (!(p_test_1_ instanceof PlayerEntity) || !p_test_1_.func_175149_v() && !((PlayerEntity)p_test_1_).func_184812_l_()) {
                    return !p_test_1_.func_70608_bn() && !p_test_1_.func_226273_bm_();
                }
                return false;
            }
            return true;
        }
    }

    class SleepGoal
    extends BaseGoal {
        private int field_220825_c;

        public SleepGoal() {
            this.field_220825_c = AbstractBearEntity.this.field_70146_Z.nextInt(140);
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean func_75250_a() {
            if (AbstractBearEntity.this.field_70702_br == 0.0f && AbstractBearEntity.this.field_70701_bs == 0.0f && AbstractBearEntity.this.field_191988_bg == 0.0f) {
                return this.func_220823_j() || AbstractBearEntity.this.func_70608_bn();
            }
            return false;
        }

        public boolean func_75253_b() {
            return this.func_220823_j();
        }

        private boolean func_220823_j() {
            if (this.field_220825_c > 0) {
                --this.field_220825_c;
                return false;
            }
            return AbstractBearEntity.this.field_70170_p.func_72935_r() && this.func_220813_g() && !this.func_220814_h();
        }

        public void func_75251_c() {
            this.field_220825_c = AbstractBearEntity.this.field_70146_Z.nextInt(140);
        }

        public void func_75249_e() {
            AbstractBearEntity.this.func_70637_d(false);
            AbstractBearEntity.this.setSleeping(true);
            AbstractBearEntity.this.func_70661_as().func_75499_g();
            AbstractBearEntity.this.func_70605_aq().func_75642_a(AbstractBearEntity.this.func_226277_ct_(), AbstractBearEntity.this.func_226278_cu_(), AbstractBearEntity.this.func_226281_cx_(), 0.0);
        }
    }

    public abstract class BaseGoal
    extends Goal {
        private final EntityPredicate field_220816_b;

        private BaseGoal() {
            this.field_220816_b = new EntityPredicate().func_221013_a(12.0).func_221014_c().func_221012_a((Predicate)new AlertablePredicate());
        }

        protected boolean func_220813_g() {
            BlockPos blockpos = new BlockPos((Entity)AbstractBearEntity.this);
            return !AbstractBearEntity.this.field_70170_p.func_226660_f_(blockpos) && AbstractBearEntity.this.func_180484_a(blockpos) >= 0.0f;
        }

        protected boolean func_220814_h() {
            return !AbstractBearEntity.this.field_70170_p.func_217374_a(LivingEntity.class, this.field_220816_b, (LivingEntity)AbstractBearEntity.this, AbstractBearEntity.this.func_174813_aQ().func_72314_b(12.0, 6.0, 12.0)).isEmpty();
        }
    }
}

