/*
 * Decompiled with CFR 0.152.
 */
package com.bagel.buzzierbees.core.registry;

import com.bagel.buzzierbees.core.registry.BBBlocks;
import com.bagel.buzzierbees.core.registry.BBItems;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.jigsaw.SingleJigsawPiece;
import net.minecraft.world.gen.feature.structure.DesertVillagePools;
import net.minecraft.world.gen.feature.structure.PlainsVillagePools;
import net.minecraft.world.gen.feature.structure.SavannaVillagePools;
import net.minecraft.world.gen.feature.structure.SnowyVillagePools;
import net.minecraft.world.gen.feature.structure.TaigaVillagePools;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class BBVillagers {
    public static final DeferredRegister<VillagerProfession> PROFESSIONS = new DeferredRegister(ForgeRegistries.PROFESSIONS, "buzzierbees");
    public static final DeferredRegister<PointOfInterestType> POI_TYPES = new DeferredRegister(ForgeRegistries.POI_TYPES, "buzzierbees");
    public static final RegistryObject<PointOfInterestType> HONEY_POT = POI_TYPES.register("honey_pot", () -> new PointOfInterestType("apiarist", PointOfInterestType.func_221042_a((Block)((Block)BBBlocks.HONEY_POT.get())), 1, 1));
    public static final RegistryObject<VillagerProfession> APIARIST = PROFESSIONS.register("apiarist", () -> new VillagerProfession("apiarist", (PointOfInterestType)HONEY_POT.get(), ImmutableSet.of((Object)Items.field_226635_pU_, (Object)Items.field_226638_pX_, (Object)BBItems.WAX.get()), ImmutableSet.of(), SoundEvents.field_219701_mI));

    public static void setupVillagers() {
        JigsawManager.field_214891_a.func_214932_a(new JigsawPattern(new ResourceLocation("buzzierbees", "village/apiarist_bees"), new ResourceLocation("empty"), (List)ImmutableList.of((Object)new Pair((Object)new SingleJigsawPiece("buzzierbees:village/apiarist_bees/bees_1"), (Object)1)), JigsawPattern.PlacementBehaviour.RIGID));
        PlainsVillagePools.func_214744_a();
        SnowyVillagePools.func_214746_a();
        SavannaVillagePools.func_214745_a();
        DesertVillagePools.func_222739_a();
        TaigaVillagePools.func_214806_a();
        for (String biome : new String[]{"plains", "snowy", "savanna", "desert", "taiga"}) {
            BBVillagers.addToPool(new ResourceLocation("village/" + biome + "/houses"), new ResourceLocation("buzzierbees", "village/apiarist_house_" + biome + "_1"), 5);
        }
        try {
            ObfuscationReflectionHelper.findMethod(PointOfInterestType.class, (String)"func_221052_a", (Class[])new Class[]{PointOfInterestType.class}).invoke(null, HONEY_POT.get());
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static void addToPool(ResourceLocation pool, ResourceLocation toAdd, int weight) {
        JigsawPattern old = JigsawManager.field_214891_a.func_214933_a(pool);
        List shuffled = old.func_214943_b(new Random());
        ArrayList<Pair> newPieces = new ArrayList<Pair>();
        for (JigsawPiece p : shuffled) {
            newPieces.add(new Pair((Object)p, (Object)1));
        }
        newPieces.add(new Pair((Object)new SingleJigsawPiece(toAdd.toString()), (Object)weight));
        ResourceLocation something = old.func_214948_a();
        JigsawManager.field_214891_a.func_214932_a(new JigsawPattern(pool, something, newPieces, JigsawPattern.PlacementBehaviour.RIGID));
    }
}

