/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.buzzier_bees.core.other;

import com.google.common.collect.Sets;
import com.minecraftabnormals.buzzier_bees.core.BBConfig;
import com.minecraftabnormals.buzzier_bees.core.other.BBTags;
import com.minecraftabnormals.buzzier_bees.core.registry.BBItems;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.FlowerBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.TallFlowerBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BoneMealItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTables;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="buzzier_bees")
public class BBEvents {
    private static final Set<ResourceLocation> DESERT_LOOT_INJECTIONS = Sets.newHashSet((Object[])new ResourceLocation[]{LootTables.field_186429_k});
    private static final Set<ResourceLocation> JUNGLE_LOOT_INJECTIONS = Sets.newHashSet((Object[])new ResourceLocation[]{LootTables.field_186430_l});

    @SubscribeEvent
    public static void onInjectLoot(LootTableLoadEvent event) {
        LootPool pool;
        if (DESERT_LOOT_INJECTIONS.contains(event.getName())) {
            pool = LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)new ResourceLocation("buzzier_bees", "injections/desert_pyramid")).func_216086_a(1).func_216085_b(0)).name("desert_pyramid").func_216044_b();
            event.getTable().addPool(pool);
        }
        if (JUNGLE_LOOT_INJECTIONS.contains(event.getName())) {
            pool = LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)new ResourceLocation("buzzier_bees", "injections/jungle_temple")).func_216086_a(1).func_216085_b(0)).name("jungle_temple").func_216044_b();
            event.getTable().addPool(pool);
        }
    }

    @SubscribeEvent
    public static void renewableFlowers(PlayerInteractEvent.RightClickBlock event) {
        PlayerEntity player = event.getPlayer();
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        Block block = world.func_180495_p(pos).func_177230_c();
        ItemStack stack = player.func_184586_b(event.getHand());
        if (stack.func_77973_b() != Items.field_196106_bc) {
            return;
        }
        if (((Boolean)BBConfig.COMMON.shortFlowerDuplication.get()).booleanValue()) {
            if (!(block instanceof FlowerBlock) || block.func_203417_a(BBTags.Blocks.FLOWER_BLACKLIST) || block instanceof IGrowable && ((IGrowable)block).func_180670_a(world, world.field_73012_v, pos, world.func_180495_p(pos))) {
                return;
            }
            if (!player.func_184812_l_()) {
                stack.func_190918_g(1);
            }
            player.func_184609_a(event.getHand());
            if (world.field_72995_K) {
                BoneMealItem.func_195965_a((IWorld)world, (BlockPos)pos, (int)world.field_73012_v.nextInt(12));
            }
            Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)block, 1));
        }
        if (!((Boolean)BBConfig.COMMON.tallFlowerDuplication.get()).booleanValue() && block instanceof TallFlowerBlock) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void bottleBug(PlayerInteractEvent.EntityInteractSpecific event) {
        if (event.getTarget() != null && !event.getWorld().field_72995_K) {
            ItemStack itemstack = event.getPlayer().func_184586_b(event.getHand());
            Item item = itemstack.func_77973_b();
            Item bottle = null;
            boolean successful = false;
            Entity target = event.getTarget();
            EntityType targetType = target.func_200600_R();
            PlayerEntity player = event.getPlayer();
            Hand hand = event.getHand();
            if (targetType == EntityType.field_200740_af) {
                bottle = (Item)BBItems.BOTTLE_OF_SILVERFISH.get();
                successful = true;
            }
            if (targetType == EntityType.field_200804_r) {
                bottle = (Item)BBItems.BOTTLE_OF_ENDERMITE.get();
                successful = true;
            }
            if (targetType == EntityType.field_226289_e_) {
                bottle = (Item)BBItems.BOTTLE_OF_BEE.get();
                successful = true;
            }
            ItemStack bottleItem = new ItemStack((IItemProvider)bottle);
            if (targetType == EntityType.field_226289_e_) {
                BeeEntity bee = (BeeEntity)target;
                CompoundNBT tag = bottleItem.func_196082_o();
                tag.func_74757_a("HasNectar", bee.func_226411_eD_());
                tag.func_74757_a("HasStung", bee.func_226412_eE_());
                tag.func_74768_a("AngerTime", bee.func_230256_F__());
                if (bee.func_230257_G__() != null) {
                    tag.func_186854_a("AngryAt", bee.func_230257_G__());
                }
                tag.func_74768_a("Age", bee.func_70874_b());
                tag.func_74776_a("Health", bee.func_110143_aJ());
            }
            if (target.func_145818_k_()) {
                ITextComponent name = target.func_200201_e();
                bottleItem = bottleItem.func_200302_a(name);
            }
            if (successful && ((MobEntity)target).func_70089_S() && item == Items.field_151069_bo) {
                itemstack.func_190918_g(1);
                event.getWorld().func_184133_a(player, event.getPos(), SoundEvents.field_187618_I, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)event.getItemStack().func_77973_b()));
                event.getTarget().func_70106_y();
                if (itemstack.func_190926_b()) {
                    player.func_184611_a(hand, bottleItem);
                } else if (!player.field_71071_by.func_70441_a(bottleItem)) {
                    player.func_71019_a(bottleItem, false);
                }
                player.func_184609_a(hand);
            }
        }
    }
}

