/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.buzzier_bees.core.registry;

import com.google.common.collect.ImmutableList;
import com.minecraftabnormals.buzzier_bees.core.registry.BBBlocks;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.DoublePlantBlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.MultipleWithChanceRandomFeatureConfig;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class BBFeatures {
    private static void addShortFlower(BlockState blockState, Biome biomeIn, int frequency) {
        BlockClusterFeatureConfig config = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(blockState), (BlockPlacer)SimpleBlockPlacer.field_236447_c_).func_227315_a_(32).func_227322_d_();
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227247_y_.func_225566_b_((IFeatureConfig)config).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(frequency))));
    }

    public static void addDoubleFlower(BlockState blockState, Biome biomeIn, int frequency) {
        BlockClusterFeatureConfig config = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(blockState), (BlockPlacer)DoublePlantBlockPlacer.field_236444_c_).func_227315_a_(64).func_227317_b_().func_227322_d_();
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202291_ak.func_225566_b_((IFeatureConfig)new MultipleWithChanceRandomFeatureConfig((List)ImmutableList.of((Object)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)config)), 0)).func_227228_a_(Placement.field_215017_c.func_227446_a_((IPlacementConfig)new FrequencyConfig(frequency))));
    }

    public static void init() {
        ForgeRegistries.BIOMES.getValues().forEach(BBFeatures::generate);
    }

    public static void generate(Biome biome) {
        if (biome.func_201856_r() == Biome.Category.FOREST) {
            if (biome == Biomes.field_185444_T) {
                BBFeatures.addShortFlower(((Block)BBBlocks.PINK_CLOVER.get()).func_176223_P(), biome, 3);
            }
            if (biome == Biomes.field_150583_P || biome == Biomes.field_150582_Q || biome == Biomes.field_185448_Z || biome == Biomes.field_185429_aa) {
                BBFeatures.addShortFlower(((Block)BBBlocks.PINK_CLOVER.get()).func_176223_P(), biome, 3);
            } else {
                BBFeatures.addShortFlower(((Block)BBBlocks.WHITE_CLOVER.get()).func_176223_P(), biome, 3);
            }
        }
    }
}

