/*
 * Decompiled with CFR 0.152.
 */
package tschipp.callablehorses.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.passive.horse.AbstractChestedHorseEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.items.CapabilityItemHandler;
import tschipp.callablehorses.CallableHorses;
import tschipp.callablehorses.common.WhistleSounds;
import tschipp.callablehorses.common.capabilities.horseowner.IHorseOwner;
import tschipp.callablehorses.common.capabilities.storedhorse.IStoredHorse;
import tschipp.callablehorses.common.config.Configs;
import tschipp.callablehorses.common.helper.HorseHelper;
import tschipp.callablehorses.common.worlddata.StoredHorsesWorldData;
import tschipp.callablehorses.network.OwnerSyncShowStatsPacket;
import tschipp.callablehorses.network.PlayWhistlePacket;

public class HorseManager {
    public static boolean callHorse(PlayerEntity player) {
        IHorseOwner horseOwner;
        if (player != null && (horseOwner = HorseHelper.getOwnerCap(player)) != null) {
            IStoredHorse horse;
            if (horseOwner.getHorseNBT().isEmpty()) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("callablehorses.error.nohorse").func_240699_a_(TextFormatting.RED), true);
                return false;
            }
            if (!HorseManager.canCallHorse(player)) {
                return false;
            }
            Random rand = new Random();
            player.field_70170_p.func_184133_a(player, player.func_233580_cy_(), WhistleSounds.getRandomWhistle(), SoundCategory.PLAYERS, 1.0f, (float)(1.4 + rand.nextGaussian() / 3.0));
            CallableHorses.network.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new PlayWhistlePacket());
            AbstractHorseEntity e = HorseManager.findHorseWithStorageID(horseOwner.getStorageUUID(), player.field_70170_p);
            if (e != null && (horse = HorseHelper.getHorseCap((Entity)e)).getStorageUUID().equals(horseOwner.getStorageUUID())) {
                if (e.field_70170_p.func_230315_m_() == player.field_70170_p.func_230315_m_()) {
                    e.func_184226_ay();
                    if (e.func_213303_ch().func_72438_d(player.func_213303_ch()) <= (Double)Configs.SERVER.horseWalkRange.get()) {
                        e.func_110148_a(Attributes.field_233819_b_).func_111128_a(((Double)Configs.SERVER.horseWalkRange.get()).doubleValue());
                        e.func_70661_as().func_75497_a((Entity)player, ((Double)Configs.SERVER.horseWalkSpeed.get()).doubleValue());
                    } else {
                        e.func_70107_b(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
                    }
                    HorseHelper.setHorseLastSeen(player);
                    HorseHelper.sendHorseUpdateInRange((Entity)e);
                    return true;
                }
                HorseManager.saveHorse((Entity)e);
                e.func_70107_b(e.func_226277_ct_(), -200.0, e.func_226281_cx_());
                e.func_70106_y();
            }
            AbstractHorseEntity newHorse = horseOwner.createHorseEntity(player.field_70170_p);
            newHorse.func_70107_b(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
            player.field_70170_p.func_217376_c((Entity)newHorse);
            IStoredHorse h = HorseHelper.getHorseCap((Entity)newHorse);
            HorseHelper.setHorseNum((ServerWorld)newHorse.field_70170_p, h.getStorageUUID(), h.getHorseNum());
            HorseHelper.sendHorseUpdateInRange((Entity)newHorse);
            HorseHelper.setHorseLastSeen(player);
            return true;
        }
        return false;
    }

    public static void setHorse(PlayerEntity player) {
        if (player != null) {
            if (player.func_184187_bx() == null) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("callablehorses.error.notriding").func_240699_a_(TextFormatting.RED), true);
                return;
            }
            Entity e = player.func_184187_bx();
            if (e instanceof AbstractHorseEntity) {
                if (!HorseManager.canSetHorse(player, e)) {
                    return;
                }
                IStoredHorse storedHorse = HorseHelper.getHorseCap(e);
                String owner = storedHorse.getOwnerUUID();
                String playerID = player.func_146103_bH().getId().toString();
                boolean owned = storedHorse.isOwned();
                if (owned && !owner.equals(playerID)) {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("callablehorses.error.alreadyowned").func_240699_a_(TextFormatting.RED), true);
                    return;
                }
                if (owned && owner.equals(playerID)) {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("callablehorses.error.alreadypersonal").func_240699_a_(TextFormatting.RED), true);
                    return;
                }
                IHorseOwner horseOwner = HorseHelper.getOwnerCap(player);
                String ownedID = horseOwner.getStorageUUID();
                if (!ownedID.isEmpty()) {
                    AbstractHorseEntity ent = HorseManager.findHorseWithStorageID(horseOwner.getStorageUUID(), player.field_70170_p);
                    if (ent != null) {
                        HorseManager.clearHorse(HorseHelper.getHorseCap((Entity)ent));
                    } else {
                        player.field_70170_p.func_73046_m().func_212370_w().forEach(serverworld -> {
                            StoredHorsesWorldData data = HorseHelper.getWorldData(serverworld);
                            data.disbandHorse(ownedID);
                        });
                    }
                }
                horseOwner.clearHorse();
                horseOwner.setHorse((AbstractHorseEntity)e, player);
                HorseHelper.setHorseLastSeen(player);
                HorseHelper.setHorseNum((ServerWorld)e.field_70170_p, storedHorse.getStorageUUID(), storedHorse.getHorseNum());
                player.func_146105_b((ITextComponent)new TranslationTextComponent("callablehorses.success"), true);
                HorseHelper.sendHorseUpdateInRange(e);
            }
        }
    }

    public static void showHorseStats(ServerPlayerEntity player) {
        IHorseOwner owner = HorseHelper.getOwnerCap((PlayerEntity)player);
        if (owner.getHorseNBT().isEmpty()) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("callablehorses.error.nohorse").func_240699_a_(TextFormatting.RED), true);
            return;
        }
        AbstractHorseEntity e = HorseManager.findHorseWithStorageID(owner.getStorageUUID(), player.field_70170_p);
        if (e != null) {
            HorseManager.saveHorse((Entity)e);
        }
        CallableHorses.network.send(PacketDistributor.PLAYER.with(() -> player), (Object)new OwnerSyncShowStatsPacket(owner));
    }

    public static void clearHorse(IStoredHorse horse) {
        horse.setOwned(false);
        horse.setHorseNum(0);
        horse.setOwnerUUID("");
        horse.setStorageUUID("");
    }

    @Nullable
    public static AbstractHorseEntity findHorseWithStorageID(String id, World world) {
        MinecraftServer server = world.func_73046_m();
        ArrayList entities = new ArrayList();
        for (ServerWorld w : server.func_212370_w()) {
            entities.addAll(w.getEntities().collect(Collectors.toList()));
        }
        for (Entity e : entities) {
            IStoredHorse horse;
            if (!(e instanceof AbstractHorseEntity) || !(horse = HorseHelper.getHorseCap(e)).getStorageUUID().equals(id)) continue;
            return (AbstractHorseEntity)e;
        }
        return null;
    }

    public static void prepDeadHorseForRespawning(Entity e) {
        LazyOptional cap = e.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        cap.ifPresent(itemHandler -> {
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                itemHandler.extractItem(i, 64, false);
            }
        });
        if (e instanceof AbstractChestedHorseEntity) {
            ((AbstractChestedHorseEntity)e).func_110207_m(false);
        }
        e.func_70066_B();
        ((LivingEntity)e).func_70606_j(((LivingEntity)e).func_110138_aP());
    }

    public static boolean canCallHorse(PlayerEntity player) {
        if (HorseManager.isAreaProtected(player, null)) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("callablehorses.error.area").func_240699_a_(TextFormatting.RED), true);
            return false;
        }
        if (player.func_184187_bx() != null) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("callablehorses.error.riding").func_240699_a_(TextFormatting.RED), true);
            return false;
        }
        if (((Boolean)Configs.SERVER.checkForSpace.get()).booleanValue()) {
            double startX = player.func_226277_ct_() - 1.0;
            double startY = player.func_226278_cu_();
            double startZ = player.func_226281_cx_() - 1.0;
            double endX = player.func_226277_ct_() + 1.0;
            double endY = player.func_226278_cu_() + 2.0;
            double endZ = player.func_226281_cx_() + 1.0;
            World world = player.field_70170_p;
            for (double x = startX; x <= endX; x += 1.0) {
                for (double y = startY; y <= endY; y += 1.0) {
                    for (double z = startZ; z <= endZ; z += 1.0) {
                        BlockPos pos = new BlockPos(x, y, z);
                        BlockState state = world.func_180495_p(pos);
                        if (state.func_177230_c().func_220071_b(state, (IBlockReader)world, pos, null) == VoxelShapes.func_197880_a()) continue;
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("callablehorses.error.nospace").func_240699_a_(TextFormatting.RED), true);
                        return false;
                    }
                }
            }
        }
        if (!((Boolean)Configs.SERVER.callableInEveryDimension.get()).booleanValue()) {
            List allowedDims = (List)Configs.SERVER.callableDimsWhitelist.get();
            RegistryKey playerDim = player.field_70170_p.func_234923_W_();
            for (int i = 0; i < allowedDims.size(); ++i) {
                if (!((String)allowedDims.get(i)).equals(playerDim.func_240901_a_().toString())) continue;
                return true;
            }
            player.func_146105_b((ITextComponent)new TranslationTextComponent("callablehorses.error.dim").func_240699_a_(TextFormatting.RED), true);
            return false;
        }
        int maxDistance = (Integer)Configs.SERVER.maxCallingDistance.get();
        if (maxDistance != -1) {
            double movementFactorOwner;
            double movementFactorHorse;
            IHorseOwner owner = HorseHelper.getOwnerCap(player);
            Vector3d lastSeenPos = owner.getLastSeenPosition();
            RegistryKey lastSeenDim = owner.getLastSeenDim();
            if (lastSeenPos.equals((Object)Vector3d.field_186680_a)) {
                return true;
            }
            MinecraftServer server = player.field_70170_p.func_73046_m();
            AbstractHorseEntity livingHorse = HorseManager.findHorseWithStorageID(owner.getStorageUUID(), player.field_70170_p);
            if (livingHorse != null) {
                lastSeenPos = livingHorse.func_213303_ch();
                lastSeenDim = livingHorse.field_70170_p.func_234923_W_();
            }
            double movementFactorTotal = (movementFactorHorse = server.func_71218_a(lastSeenDim).func_230315_m_().func_242724_f()) > (movementFactorOwner = player.field_70170_p.func_230315_m_().func_242724_f()) ? movementFactorHorse / movementFactorOwner : movementFactorOwner / movementFactorHorse;
            double distance = lastSeenPos.func_72438_d(player.func_213303_ch()) / movementFactorTotal;
            if (distance <= (double)maxDistance) {
                return true;
            }
            player.func_146105_b((ITextComponent)new TranslationTextComponent("callablehorses.error.range").func_240699_a_(TextFormatting.RED), true);
            return false;
        }
        return true;
    }

    public static boolean canSetHorse(PlayerEntity player, Entity entity) {
        if (HorseManager.isAreaProtected(player, entity)) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("callablehorses.error.setarea").func_240699_a_(TextFormatting.RED), true);
            return false;
        }
        return true;
    }

    public static void saveHorse(Entity e) {
        if (e instanceof AbstractHorseEntity) {
            if (((AbstractHorseEntity)e).field_70737_aN != 0) {
                return;
            }
            World world = e.field_70170_p;
            IStoredHorse horse = HorseHelper.getHorseCap(e);
            if (horse != null && horse.isOwned()) {
                String ownerid = horse.getOwnerUUID();
                PlayerEntity owner = HorseHelper.getPlayerFromUUID(ownerid, world);
                if (owner != null) {
                    IHorseOwner horseOwner = HorseHelper.getOwnerCap(owner);
                    if (horseOwner != null) {
                        CompoundNBT nbt = e.serializeNBT();
                        horseOwner.setHorseNBT(nbt);
                        horseOwner.setLastSeenDim((RegistryKey<World>)e.field_70170_p.func_234923_W_());
                        horseOwner.setLastSeenPosition(e.func_213303_ch());
                    } else {
                        world.func_73046_m().func_212370_w().forEach(serverworld -> {
                            StoredHorsesWorldData data = HorseHelper.getWorldData(serverworld);
                            data.addOfflineSavedHorse(horse.getStorageUUID(), e.serializeNBT());
                        });
                    }
                } else {
                    StoredHorsesWorldData data = HorseHelper.getWorldData((ServerWorld)world);
                    data.addOfflineSavedHorse(horse.getStorageUUID(), e.serializeNBT());
                }
            }
        }
    }

    private static boolean isAreaProtected(PlayerEntity player, @Nullable Entity fakeHorse) {
        IHorseOwner owner = HorseHelper.getOwnerCap(player);
        if (fakeHorse == null) {
            fakeHorse = owner.createHorseEntity(player.field_70170_p);
        }
        fakeHorse.func_70107_b(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
        PlayerInteractEvent.EntityInteract interactEvent = new PlayerInteractEvent.EntityInteract(player, Hand.MAIN_HAND, fakeHorse);
        AttackEntityEvent attackEvent = new AttackEntityEvent(player, fakeHorse);
        MinecraftForge.EVENT_BUS.post((Event)interactEvent);
        MinecraftForge.EVENT_BUS.post((Event)attackEvent);
        return interactEvent.isCanceled() || attackEvent.isCanceled();
    }
}

