/*
 * Decompiled with CFR 0.152.
 */
package tschipp.callablehorses.common.helper;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.PacketDistributor;
import tschipp.callablehorses.CallableHorses;
import tschipp.callablehorses.common.capabilities.horseowner.HorseOwnerProvider;
import tschipp.callablehorses.common.capabilities.horseowner.IHorseOwner;
import tschipp.callablehorses.common.capabilities.storedhorse.HorseProvider;
import tschipp.callablehorses.common.capabilities.storedhorse.IStoredHorse;
import tschipp.callablehorses.common.worlddata.StoredHorsesWorldData;
import tschipp.callablehorses.network.HorseCapSyncPacket;

public class HorseHelper {
    private static Map<Entity, LazyOptional<IStoredHorse>> cachedHorses = new HashMap<Entity, LazyOptional<IStoredHorse>>();

    public static IHorseOwner getOwnerCap(PlayerEntity player) {
        LazyOptional cap = player.getCapability(HorseOwnerProvider.OWNER_CAPABILITY, null);
        if (cap.isPresent()) {
            return (IHorseOwner)cap.resolve().get();
        }
        return null;
    }

    public static IStoredHorse getHorseCap(Entity horse) {
        LazyOptional cap = cachedHorses.get(horse);
        if (cap == null) {
            cap = horse.getCapability(HorseProvider.HORSE_CAPABILITY, null);
            cachedHorses.put(horse, (LazyOptional<IStoredHorse>)cap);
            cap.addListener(optional -> cachedHorses.remove(horse));
        }
        if (cap.isPresent()) {
            return (IStoredHorse)cap.resolve().get();
        }
        return null;
    }

    public static void sendHorseUpdateInRange(Entity horse) {
        IStoredHorse storedHorse = HorseHelper.getHorseCap(horse);
        CallableHorses.network.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(horse.func_226277_ct_(), horse.func_226281_cx_(), horse.func_226281_cx_(), 32.0, horse.field_70170_p.func_234923_W_())), (Object)new HorseCapSyncPacket(horse.func_145782_y(), storedHorse));
    }

    public static void sendHorseUpdateToClient(Entity horse, PlayerEntity player) {
        IStoredHorse storedHorse = HorseHelper.getHorseCap(horse);
        CallableHorses.network.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new HorseCapSyncPacket(horse.func_145782_y(), storedHorse));
    }

    @Nullable
    public static PlayerEntity getPlayerFromUUID(String uuid, World world) {
        MinecraftServer server = world.func_73046_m();
        ServerPlayerEntity owner = server.func_184103_al().func_177451_a(UUID.fromString(uuid));
        return owner;
    }

    public static void setHorseNum(ServerWorld world, String storageid, int num) {
        world.func_73046_m().func_212370_w().forEach(serverworld -> {
            StoredHorsesWorldData storedHorses = StoredHorsesWorldData.getInstance(serverworld);
            storedHorses.addHorseNum(storageid, num);
        });
    }

    public static int getHorseNum(ServerWorld world, String storageid) {
        StoredHorsesWorldData storedHorses = StoredHorsesWorldData.getInstance(world);
        return storedHorses.getHorseNum(storageid);
    }

    public static void setHorseLastSeen(PlayerEntity player) {
        IHorseOwner owner = HorseHelper.getOwnerCap(player);
        owner.setLastSeenPosition(player.func_213303_ch());
        owner.setLastSeenDim((RegistryKey<World>)player.field_70170_p.func_234923_W_());
    }

    public static StoredHorsesWorldData getWorldData(ServerWorld world) {
        return StoredHorsesWorldData.getInstance(world);
    }
}

