/*
 * Decompiled with CFR 0.152.
 */
package tschipp.callablehorses.common.loot;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;
import tschipp.callablehorses.common.capabilities.storedhorse.IStoredHorse;
import tschipp.callablehorses.common.helper.HorseHelper;

@Mod.EventBusSubscriber(modid="callablehorses", bus=Mod.EventBusSubscriber.Bus.MOD)
public class HorseDropModifier
extends LootModifier {
    private ILootCondition[] conditions;

    protected HorseDropModifier(ILootCondition[] conditionsIn) {
        super(conditionsIn);
        this.conditions = conditionsIn;
    }

    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        IStoredHorse horse;
        Entity entity = (Entity)context.func_216031_c(LootParameters.field_216281_a);
        if (entity instanceof AbstractHorseEntity && (horse = HorseHelper.getHorseCap(entity)) != null && horse.isOwned()) {
            generatedLoot.clear();
        }
        return generatedLoot;
    }

    @SubscribeEvent
    public static void registerModifierSerializers(RegistryEvent.Register<GlobalLootModifierSerializer<?>> event) {
        event.getRegistry().register((IForgeRegistryEntry)new Serializer().setRegistryName(new ResourceLocation("callablehorses", "horse_drop")));
    }

    private static class Serializer
    extends GlobalLootModifierSerializer<HorseDropModifier> {
        private Serializer() {
        }

        public HorseDropModifier read(ResourceLocation location, JsonObject object, ILootCondition[] ailootcondition) {
            return new HorseDropModifier(ailootcondition);
        }

        public JsonObject write(HorseDropModifier instance) {
            return this.makeConditions(instance.conditions);
        }
    }
}

