/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity;

import de.maxhenkel.car.Main;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.blocks.tileentity.TileEntityBase;
import de.maxhenkel.car.fluids.ModFluids;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.IIntArray;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntityBackmixReactor
extends TileEntityBase
implements ITickableTileEntity,
IFluidHandler,
IEnergyStorage,
IInventory {
    public final int maxStorage;
    protected int storedEnergy;
    public final int energyUsage;
    public final int methanolUsage;
    public final int maxMethanol;
    protected int currentMethanol;
    public final int canolaUsage;
    public final int maxCanola;
    protected int currentCanola;
    public final int maxMix;
    protected int currentMix;
    public final int mixGeneration;
    public final int generatingTime;
    protected int timeToGenerate;
    public final IIntArray FIELDS = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return TileEntityBackmixReactor.this.storedEnergy;
                }
                case 1: {
                    return TileEntityBackmixReactor.this.currentCanola;
                }
                case 2: {
                    return TileEntityBackmixReactor.this.currentMethanol;
                }
                case 3: {
                    return TileEntityBackmixReactor.this.currentMix;
                }
                case 4: {
                    return TileEntityBackmixReactor.this.timeToGenerate;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    TileEntityBackmixReactor.this.storedEnergy = value;
                    break;
                }
                case 1: {
                    TileEntityBackmixReactor.this.currentCanola = value;
                    break;
                }
                case 2: {
                    TileEntityBackmixReactor.this.currentMethanol = value;
                    break;
                }
                case 3: {
                    TileEntityBackmixReactor.this.currentMix = value;
                    break;
                }
                case 4: {
                    TileEntityBackmixReactor.this.timeToGenerate = value;
                }
            }
        }

        public int func_221478_a() {
            return 5;
        }
    };

    public TileEntityBackmixReactor() {
        super(Main.BACKMIX_REACTOR_TILE_ENTITY_TYPE);
        this.maxStorage = (Integer)Main.SERVER_CONFIG.backmixReactorEnergyStorage.get();
        this.storedEnergy = 0;
        this.energyUsage = (Integer)Main.SERVER_CONFIG.backmixReactorEnergyUsage.get();
        this.maxMethanol = (Integer)Main.SERVER_CONFIG.backmixReactorFluidStorage.get();
        this.maxCanola = (Integer)Main.SERVER_CONFIG.backmixReactorFluidStorage.get();
        this.maxMix = (Integer)Main.SERVER_CONFIG.backmixReactorFluidStorage.get();
        this.currentCanola = 0;
        this.currentMethanol = 0;
        this.currentMix = 0;
        this.generatingTime = (Integer)Main.SERVER_CONFIG.backmixReactorGeneratingTime.get();
        this.timeToGenerate = 0;
        this.mixGeneration = (Integer)Main.SERVER_CONFIG.backmixReactorMixGeneration.get();
        this.methanolUsage = (Integer)Main.SERVER_CONFIG.backmixReactorMethanolUsage.get();
        this.canolaUsage = (Integer)Main.SERVER_CONFIG.backmixReactorCanolaUsage.get();
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.setBlockEnabled(this.isEnabled());
        if (this.timeToGenerate > 0 && this.storedEnergy >= this.energyUsage) {
            this.storedEnergy -= this.energyUsage;
            --this.timeToGenerate;
            if (this.timeToGenerate == 0 && this.currentMix + this.mixGeneration <= this.maxMix) {
                this.currentMix += this.mixGeneration;
                this.currentCanola -= this.canolaUsage;
                this.currentMethanol -= this.methanolUsage;
            }
        } else if (this.storedEnergy >= this.energyUsage && this.currentCanola >= this.canolaUsage && this.currentMethanol >= this.methanolUsage && this.currentMix + this.mixGeneration <= this.maxMix) {
            this.timeToGenerate = this.generatingTime;
        }
        this.func_70296_d();
    }

    public boolean isEnabled() {
        if (this.storedEnergy > 0 && this.currentMix < this.maxMix && this.currentMethanol >= this.methanolUsage) {
            return this.currentCanola >= this.canolaUsage;
        }
        return false;
    }

    public void setBlockEnabled(boolean enabled) {
        BlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c().equals(ModBlocks.BACKMIX_REACTOR)) {
            ModBlocks.BACKMIX_REACTOR.setPowered(this.field_145850_b, this.field_174879_c, state, enabled);
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("stored_endergy", this.storedEnergy);
        compound.func_74768_a("canola", this.currentCanola);
        compound.func_74768_a("methanol", this.currentMethanol);
        compound.func_74768_a("mix", this.currentMix);
        compound.func_74768_a("time", this.timeToGenerate);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_230337_a_(BlockState blockState, CompoundNBT compound) {
        this.storedEnergy = compound.func_74762_e("stored_endergy");
        this.currentCanola = compound.func_74762_e("canola");
        this.currentMethanol = compound.func_74762_e("methanol");
        this.currentMix = compound.func_74762_e("mix");
        this.timeToGenerate = compound.func_74762_e("time");
        super.func_230337_a_(blockState, compound);
    }

    public int func_70302_i_() {
        return 0;
    }

    public ItemStack func_70301_a(int index) {
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70304_b(int index) {
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int index, ItemStack stack) {
    }

    public int func_70297_j_() {
        return 0;
    }

    public boolean func_70300_a(PlayerEntity player) {
        return true;
    }

    public void func_174889_b(PlayerEntity player) {
    }

    public void func_174886_c(PlayerEntity player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return false;
    }

    public void func_174888_l() {
    }

    public boolean func_191420_l() {
        return true;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int energyNeeded = this.maxStorage - this.storedEnergy;
        if (!simulate) {
            this.storedEnergy += Math.min(energyNeeded, maxReceive);
            this.func_70296_d();
        }
        return Math.min(energyNeeded, maxReceive);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return this.storedEnergy;
    }

    public int getMaxEnergyStored() {
        return this.maxStorage;
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }

    public int getCurrentCanola() {
        return this.currentCanola;
    }

    public int getCurrentMethanol() {
        return this.currentMethanol;
    }

    public int getCurrentMix() {
        return this.currentMix;
    }

    public int getStoredEnergy() {
        return this.storedEnergy;
    }

    public int getTimeToGenerate() {
        return this.timeToGenerate;
    }

    @Override
    public ITextComponent getTranslatedName() {
        return new TranslationTextComponent("block.car.backmix_reactor");
    }

    @Override
    public IIntArray getFields() {
        return this.FIELDS;
    }

    public int getTanks() {
        return 3;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        if (tank == 0) {
            return new FluidStack((Fluid)ModFluids.CANOLA_OIL, this.currentCanola);
        }
        if (tank == 1) {
            return new FluidStack((Fluid)ModFluids.METHANOL, this.currentMethanol);
        }
        return new FluidStack((Fluid)ModFluids.CANOLA_METHANOL_MIX, this.currentMix);
    }

    public int getTankCapacity(int tank) {
        if (tank == 0) {
            return this.maxCanola;
        }
        if (tank == 1) {
            return this.maxMethanol;
        }
        return this.maxMix;
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        if (tank == 0) {
            return stack.getFluid().equals(ModFluids.CANOLA_OIL);
        }
        if (tank == 1) {
            return stack.getFluid().equals(ModFluids.METHANOL);
        }
        return false;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.getFluid().equals(ModFluids.METHANOL)) {
            int amount = Math.min(this.maxMethanol - this.currentMethanol, resource.getAmount());
            if (action.execute()) {
                this.currentMethanol += amount;
                this.func_70296_d();
            }
            return amount;
        }
        if (resource.getFluid().equals(ModFluids.CANOLA_OIL)) {
            int amount = Math.min(this.maxCanola - this.currentCanola, resource.getAmount());
            if (action.execute()) {
                this.currentCanola += amount;
                this.func_70296_d();
            }
            return amount;
        }
        return 0;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        int amount = Math.min(resource.getAmount(), this.currentMix);
        if (action.execute()) {
            this.currentMix -= amount;
            this.func_70296_d();
        }
        return new FluidStack((Fluid)ModFluids.CANOLA_METHANOL_MIX, amount);
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        int amount = Math.min(maxDrain, this.currentMix);
        if (action.execute()) {
            this.currentMix -= amount;
            this.func_70296_d();
        }
        return new FluidStack((Fluid)ModFluids.CANOLA_METHANOL_MIX, amount);
    }
}

