/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity;

import de.maxhenkel.car.Main;
import de.maxhenkel.car.blocks.BlockGui;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.blocks.tileentity.TileEntityBase;
import de.maxhenkel.car.corelib.energy.EnergyUtils;
import de.maxhenkel.car.fluids.ModFluids;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntityGenerator
extends TileEntityBase
implements ITickableTileEntity,
IFluidHandler,
IEnergyStorage,
IInventory {
    public final int maxStorage;
    public int storedEnergy;
    public final int maxMillibuckets;
    protected int currentMillibuckets;
    protected final int energyGeneration;
    protected Fluid currentFluid;
    protected Inventory inventory;
    public final IIntArray FIELDS = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return TileEntityGenerator.this.storedEnergy;
                }
                case 1: {
                    return TileEntityGenerator.this.currentMillibuckets;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    TileEntityGenerator.this.storedEnergy = value;
                    break;
                }
                case 1: {
                    TileEntityGenerator.this.currentMillibuckets = value;
                }
            }
        }

        public int func_221478_a() {
            return 2;
        }
    };

    public TileEntityGenerator() {
        super(Main.GENERATOR_TILE_ENTITY_TYPE);
        this.inventory = new Inventory(0);
        this.maxStorage = (Integer)Main.SERVER_CONFIG.generatorEnergyStorage.get();
        this.storedEnergy = 0;
        this.maxMillibuckets = (Integer)Main.SERVER_CONFIG.generatorFluidStorage.get();
        this.currentMillibuckets = 0;
        this.energyGeneration = (Integer)Main.SERVER_CONFIG.generatorEnergyGeneration.get();
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.setBlockEnabled(this.isEnabled());
        if (this.currentFluid != null && this.currentMillibuckets > 0 && this.storedEnergy + this.energyGeneration <= this.maxStorage) {
            --this.currentMillibuckets;
            this.storedEnergy += this.energyGeneration;
            if (this.currentMillibuckets <= 0) {
                this.currentMillibuckets = 0;
                this.currentFluid = null;
            }
        }
        if (this.currentMillibuckets <= 0 && this.currentFluid != null) {
            this.currentMillibuckets = 0;
            this.currentFluid = null;
        }
        if (this.currentFluid == null && this.currentMillibuckets > 0) {
            this.currentMillibuckets = 0;
        }
        this.handlePushEnergy();
        this.func_70296_d();
    }

    public boolean isValidFuel(Fluid f) {
        return ModFluids.BIO_DIESEL.equals(f);
    }

    private void handlePushEnergy() {
        for (Direction side : Direction.values()) {
            IEnergyStorage storage = EnergyUtils.getEnergyStorageOffset((IWorldReader)this.field_145850_b, this.field_174879_c, side);
            if (storage == null) continue;
            EnergyUtils.pushEnergy(this, storage, this.storedEnergy);
        }
    }

    public boolean isEnabled() {
        return this.currentMillibuckets > 0 && this.storedEnergy + this.energyGeneration < this.maxStorage;
    }

    public void setBlockEnabled(boolean enabled) {
        BlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c().equals(ModBlocks.GENERATOR) && (Boolean)state.func_177229_b((Property)BlockGui.POWERED) != enabled) {
            ModBlocks.GENERATOR.setPowered(this.field_145850_b, this.field_174879_c, state, enabled);
        }
    }

    @Override
    public ITextComponent getTranslatedName() {
        return new TranslationTextComponent("block.car.generator");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("stored_energy", this.storedEnergy);
        if (this.currentFluid != null) {
            FluidStack stack = new FluidStack(this.currentFluid, this.currentMillibuckets);
            CompoundNBT comp = new CompoundNBT();
            stack.writeToNBT(comp);
            compound.func_218657_a("fluid", (INBT)comp);
        }
        return super.func_189515_b(compound);
    }

    @Override
    public void func_230337_a_(BlockState blockState, CompoundNBT compound) {
        this.storedEnergy = compound.func_74762_e("stored_energy");
        if (compound.func_74764_b("fluid")) {
            FluidStack stack = FluidStack.loadFluidStackFromNBT((CompoundNBT)compound.func_74775_l("fluid"));
            this.currentFluid = stack.getFluid();
            this.currentMillibuckets = stack.getAmount();
        }
        super.func_230337_a_(blockState, compound);
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int index) {
        return this.inventory.func_70301_a(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return this.inventory.func_70298_a(index, count);
    }

    public ItemStack func_70304_b(int index) {
        return this.inventory.func_70304_b(index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventory.func_70299_a(index, stack);
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(PlayerEntity player) {
        return this.inventory.func_70300_a(player);
    }

    public boolean func_191420_l() {
        return this.inventory.func_191420_l();
    }

    public void func_174889_b(PlayerEntity player) {
        this.inventory.func_174889_b(player);
    }

    public void func_174886_c(PlayerEntity player) {
        this.inventory.func_174886_c(player);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.inventory.func_94041_b(index, stack);
    }

    public void func_174888_l() {
        this.inventory.func_174888_l();
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int i = Math.min(maxExtract, this.storedEnergy);
        if (!simulate) {
            this.storedEnergy -= i;
            this.func_70296_d();
        }
        return i;
    }

    public int getEnergyStored() {
        return this.storedEnergy;
    }

    public int getMaxEnergyStored() {
        return this.maxStorage;
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return false;
    }

    public int getStoredEnergy() {
        return this.storedEnergy;
    }

    public int getCurrentMillibuckets() {
        return this.currentMillibuckets;
    }

    @Override
    public IIntArray getFields() {
        return this.FIELDS;
    }

    public int getTanks() {
        return 1;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        if (this.currentFluid == null) {
            return FluidStack.EMPTY;
        }
        return new FluidStack(this.currentFluid, this.currentMillibuckets);
    }

    public int getTankCapacity(int tank) {
        return this.maxMillibuckets;
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return this.isValidFuel(stack.getFluid()) && (this.currentFluid == null || this.currentFluid.equals(stack.getFluid()));
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.currentFluid == null && this.isValidFuel(resource.getFluid()) || resource.getFluid().equals(this.currentFluid)) {
            int amount = Math.min(this.maxMillibuckets - this.currentMillibuckets, resource.getAmount());
            if (action.execute()) {
                this.currentMillibuckets += amount;
                if (this.currentFluid == null) {
                    this.currentFluid = resource.getFluid();
                }
                this.func_70296_d();
            }
            return amount;
        }
        return 0;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return FluidStack.EMPTY;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return FluidStack.EMPTY;
    }
}

