/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.entity.car.base;

import de.maxhenkel.car.DamageSourceCar;
import de.maxhenkel.car.Main;
import de.maxhenkel.car.corelib.math.MathUtils;
import de.maxhenkel.car.entity.car.base.EntityCarBatteryBase;
import de.maxhenkel.car.entity.car.base.EntityVehicleBase;
import de.maxhenkel.car.net.MessageCarGui;
import de.maxhenkel.car.net.MessageCarHorn;
import de.maxhenkel.car.net.MessageControlCar;
import de.maxhenkel.car.net.MessageCrash;
import de.maxhenkel.car.sounds.ModSounds;
import de.maxhenkel.car.sounds.SoundLoopHigh;
import de.maxhenkel.car.sounds.SoundLoopIdle;
import de.maxhenkel.car.sounds.SoundLoopStart;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class EntityCarBase
extends EntityVehicleBase {
    private float wheelRotation;
    @OnlyIn(value=Dist.CLIENT)
    private boolean collidedLastTick;
    @OnlyIn(value=Dist.CLIENT)
    private SoundLoopStart startLoop;
    @OnlyIn(value=Dist.CLIENT)
    private SoundLoopIdle idleLoop;
    @OnlyIn(value=Dist.CLIENT)
    private SoundLoopHigh highLoop;
    private static final DataParameter<Float> SPEED = EntityDataManager.func_187226_a(EntityCarBase.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> STARTED = EntityDataManager.func_187226_a(EntityCarBase.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> FORWARD = EntityDataManager.func_187226_a(EntityCarBase.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> BACKWARD = EntityDataManager.func_187226_a(EntityCarBase.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> LEFT = EntityDataManager.func_187226_a(EntityCarBase.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> RIGHT = EntityDataManager.func_187226_a(EntityCarBase.class, (IDataSerializer)DataSerializers.field_187198_h);
    @OnlyIn(value=Dist.CLIENT)
    private boolean startedLast;

    public EntityCarBase(EntityType type, World worldIn) {
        super(type, worldIn);
        this.field_70138_W = 0.5f;
    }

    public abstract float getMaxSpeed();

    public abstract float getMaxReverseSpeed();

    public abstract float getAcceleration();

    public abstract float getMaxRotationSpeed();

    public abstract float getMinRotationSpeed();

    public abstract float getRollResistance();

    public abstract float getRotationModifier();

    public abstract float getPitch();

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.isStarted() && !this.canEngineStayOn()) {
            this.setStarted(false);
        }
        this.updateGravity();
        this.controlCar();
        this.checkPush();
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        if (this.field_70170_p.field_72995_K) {
            this.updateSounds();
        }
        this.updateWheelRotation();
    }

    public void centerCar() {
        Direction facing = this.func_174811_aO();
        switch (facing) {
            case SOUTH: {
                this.field_70177_z = 0.0f;
                break;
            }
            case NORTH: {
                this.field_70177_z = 180.0f;
                break;
            }
            case EAST: {
                this.field_70177_z = -90.0f;
                break;
            }
            case WEST: {
                this.field_70177_z = 90.0f;
            }
        }
    }

    @Override
    public boolean func_241849_j(Entity entityIn) {
        float speed;
        if (((Boolean)Main.SERVER_CONFIG.damageEntities.get()).booleanValue() && entityIn instanceof LivingEntity && !this.func_184188_bt().contains(entityIn) && entityIn.func_174813_aQ().func_72326_a(this.func_174813_aQ()) && (speed = this.getSpeed()) > 0.35f) {
            float damage = speed * 10.0f;
            entityIn.func_70097_a((DamageSource)DamageSourceCar.DAMAGE_CAR, damage);
        }
        return super.func_241849_j(entityIn);
    }

    public void checkPush() {
        List list = this.field_70170_p.func_217357_a(PlayerEntity.class, this.func_174813_aQ().func_72321_a(0.2, 0.0, 0.2).func_72321_a(-0.2, 0.0, -0.2));
        for (PlayerEntity player : list) {
            if (player.func_184196_w((Entity)this) || !player.func_225608_bj_()) continue;
            double motX = EntityCarBase.calculateMotionX(0.05f, player.field_70177_z);
            double motZ = EntityCarBase.calculateMotionZ(0.05f, player.field_70177_z);
            this.func_213315_a(MoverType.PLAYER, new Vector3d(motX, 0.0, motZ));
            return;
        }
    }

    public boolean canEngineStayOn() {
        return !this.func_70090_H() && !this.func_180799_ab();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateSounds() {
        if (this.getSpeed() == 0.0f && this.isStarted()) {
            if (!this.startedLast) {
                this.checkStartLoop();
            } else if (!this.isSoundPlaying((ISound)this.startLoop)) {
                if (this.startLoop != null) {
                    this.startLoop.setDonePlaying();
                    this.startLoop = null;
                }
                this.checkIdleLoop();
            }
        }
        if (this.getSpeed() != 0.0f && this.isStarted()) {
            this.checkHighLoop();
        }
        this.startedLast = this.isStarted();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isSoundPlaying(ISound sound) {
        if (sound == null) {
            return false;
        }
        return Minecraft.func_71410_x().func_147118_V().func_215294_c(sound);
    }

    public void destroyCar(PlayerEntity player, boolean dropParts) {
        this.func_70106_y();
    }

    private void controlCar() {
        if (!this.func_184207_aI()) {
            this.setForward(false);
            this.setBackward(false);
            this.setLeft(false);
            this.setRight(false);
        }
        float modifier = this.getModifier();
        float maxSp = this.getMaxSpeed() * modifier;
        float maxBackSp = this.getMaxReverseSpeed() * modifier;
        float speed = MathUtils.subtractToZero(this.getSpeed(), this.getRollResistance());
        if (this.isForward() && speed <= maxSp) {
            speed = Math.min(speed + this.getAcceleration(), maxSp);
        }
        if (this.isBackward() && speed >= -maxBackSp) {
            speed = Math.max(speed - this.getAcceleration(), -maxBackSp);
        }
        this.setSpeed(speed);
        float rotationSpeed = 0.0f;
        if (Math.abs(speed) > 0.02f) {
            rotationSpeed = MathHelper.func_76135_e((float)(this.getRotationModifier() / (float)Math.pow(speed, 2.0)));
            rotationSpeed = MathHelper.func_76131_a((float)rotationSpeed, (float)this.getMinRotationSpeed(), (float)this.getMaxRotationSpeed());
        }
        this.deltaRotation = 0.0f;
        if (speed < 0.0f) {
            rotationSpeed = -rotationSpeed;
        }
        if (this.isLeft()) {
            this.deltaRotation -= rotationSpeed;
        }
        if (this.isRight()) {
            this.deltaRotation += rotationSpeed;
        }
        this.field_70177_z += this.deltaRotation;
        float delta = Math.abs(this.field_70177_z - this.field_70126_B);
        while (this.field_70177_z > 180.0f) {
            this.field_70177_z -= 360.0f;
            this.field_70126_B = this.field_70177_z - delta;
        }
        while (this.field_70177_z <= -180.0f) {
            this.field_70177_z += 360.0f;
            this.field_70126_B = delta + this.field_70177_z;
        }
        if (this.field_70123_F) {
            if (this.field_70170_p.field_72995_K && !this.collidedLastTick) {
                this.onCollision(speed);
                this.collidedLastTick = true;
            }
        } else {
            this.func_213293_j(EntityCarBase.calculateMotionX(this.getSpeed(), this.field_70177_z), this.func_213322_ci().field_72448_b, EntityCarBase.calculateMotionZ(this.getSpeed(), this.field_70177_z));
            if (this.field_70170_p.field_72995_K) {
                this.collidedLastTick = false;
            }
        }
    }

    public float getModifier() {
        BlockPos pos = new BlockPos(this.func_226277_ct_(), this.func_226278_cu_() - 0.1, this.func_226281_cx_());
        BlockState state = this.field_70170_p.func_180495_p(pos);
        if (state.isAir((IBlockReader)this.field_70170_p, pos) || Main.SERVER_CONFIG.carDriveBlockList.contains(state.func_177230_c())) {
            return ((Double)Main.SERVER_CONFIG.carOnroadSpeed.get()).floatValue();
        }
        return ((Double)Main.SERVER_CONFIG.carOffroadSpeed.get()).floatValue();
    }

    public void onCollision(float speed) {
        if (this.field_70170_p.field_72995_K) {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageCrash(speed, this));
        }
        this.setSpeed(0.01f);
        this.func_213293_j(0.0, this.func_213322_ci().field_72448_b, 0.0);
    }

    public boolean canPlayerDriveCar(PlayerEntity player) {
        if (player.equals((Object)this.getDriver()) && this.isStarted()) {
            return true;
        }
        if (this.func_70090_H() || this.func_180799_ab()) {
            return false;
        }
        return false;
    }

    private void updateGravity() {
        if (this.func_189652_ae()) {
            this.func_213293_j(this.func_213322_ci().field_72450_a, 0.0, this.func_213322_ci().field_72449_c);
            return;
        }
        this.func_213293_j(this.func_213322_ci().field_72450_a, this.func_213322_ci().field_72448_b - 0.2, this.func_213322_ci().field_72449_c);
    }

    public void updateControls(boolean forward, boolean backward, boolean left, boolean right, PlayerEntity player) {
        boolean needsUpdate = false;
        if (this.isForward() != forward) {
            this.setForward(forward);
            needsUpdate = true;
        }
        if (this.isBackward() != backward) {
            this.setBackward(backward);
            needsUpdate = true;
        }
        if (this.isLeft() != left) {
            this.setLeft(left);
            needsUpdate = true;
        }
        if (this.isRight() != right) {
            this.setRight(right);
            needsUpdate = true;
        }
        if (this.field_70170_p.field_72995_K && needsUpdate) {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageControlCar(forward, backward, left, right, player));
        }
    }

    public void startCarEngine() {
        PlayerEntity player = this.getDriver();
        if (player != null && this.canStartCarEngine(player)) {
            this.setStarted(true);
        }
    }

    public boolean canStartCarEngine(PlayerEntity player) {
        return !this.func_70090_H() && !this.func_180799_ab();
    }

    public abstract double getPlayerYOffset();

    public boolean canPlayerEnterCar(PlayerEntity player) {
        return true;
    }

    @Override
    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        if (!this.canPlayerEnterCar(player)) {
            return ActionResultType.FAIL;
        }
        return super.func_184230_a(player, hand);
    }

    public float getKilometerPerHour() {
        return this.getSpeed() * 20.0f * 60.0f * 60.0f / 1000.0f;
    }

    public float getWheelRotationAmount() {
        return 120.0f * this.getSpeed();
    }

    public void updateWheelRotation() {
        this.wheelRotation += this.getWheelRotationAmount();
    }

    public float getWheelRotation(float partialTicks) {
        return this.wheelRotation + this.getWheelRotationAmount() * partialTicks;
    }

    public void openCarGUI(PlayerEntity player) {
        if (this.field_70170_p.field_72995_K) {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageCarGui(player));
        }
    }

    public boolean isAccelerating() {
        boolean b = (this.isForward() || this.isBackward()) && !this.field_70123_F;
        return b && this.isStarted();
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(STARTED, (Object)false);
        this.field_70180_af.func_187214_a(SPEED, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(FORWARD, (Object)false);
        this.field_70180_af.func_187214_a(BACKWARD, (Object)false);
        this.field_70180_af.func_187214_a(LEFT, (Object)false);
        this.field_70180_af.func_187214_a(RIGHT, (Object)false);
    }

    public void setSpeed(float speed) {
        this.field_70180_af.func_187227_b(SPEED, (Object)Float.valueOf(speed));
    }

    public float getSpeed() {
        return ((Float)this.field_70180_af.func_187225_a(SPEED)).floatValue();
    }

    public void setStarted(boolean started) {
        this.setStarted(started, true, false);
    }

    public void setStarted(boolean started, boolean playStopSound, boolean playFailSound) {
        if (!started && playStopSound) {
            this.playStopSound();
        } else if (!started && playFailSound) {
            this.playFailSound();
        }
        if (started) {
            this.setForward(false);
            this.setBackward(false);
            this.setLeft(false);
            this.setRight(false);
        }
        this.field_70180_af.func_187227_b(STARTED, (Object)started);
    }

    public boolean isStarted() {
        return (Boolean)this.field_70180_af.func_187225_a(STARTED);
    }

    public void setForward(boolean forward) {
        this.field_70180_af.func_187227_b(FORWARD, (Object)forward);
    }

    public boolean isForward() {
        if (this.getDriver() == null || !this.canPlayerDriveCar(this.getDriver())) {
            return false;
        }
        return (Boolean)this.field_70180_af.func_187225_a(FORWARD);
    }

    public void setBackward(boolean backward) {
        this.field_70180_af.func_187227_b(BACKWARD, (Object)backward);
    }

    public boolean isBackward() {
        if (this.getDriver() == null || !this.canPlayerDriveCar(this.getDriver())) {
            return false;
        }
        return (Boolean)this.field_70180_af.func_187225_a(BACKWARD);
    }

    public void setLeft(boolean left) {
        this.field_70180_af.func_187227_b(LEFT, (Object)left);
    }

    public boolean isLeft() {
        return (Boolean)this.field_70180_af.func_187225_a(LEFT);
    }

    public void setRight(boolean right) {
        this.field_70180_af.func_187227_b(RIGHT, (Object)right);
    }

    public boolean isRight() {
        return (Boolean)this.field_70180_af.func_187225_a(RIGHT);
    }

    public void func_70037_a(CompoundNBT compound) {
        this.setStarted(compound.func_74767_n("started"), false, false);
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74757_a("started", this.isStarted());
    }

    public void playStopSound() {
        ModSounds.playSound(this.getStopSound(), this.field_70170_p, this.func_233580_cy_(), null, SoundCategory.MASTER, 1.0f);
    }

    public void playFailSound() {
        ModSounds.playSound(this.getFailSound(), this.field_70170_p, this.func_233580_cy_(), null, SoundCategory.MASTER, 1.0f);
    }

    public void playCrashSound() {
        ModSounds.playSound(this.getCrashSound(), this.field_70170_p, this.func_233580_cy_(), null, SoundCategory.MASTER, 1.0f);
    }

    public void playHornSound() {
        ModSounds.playSound(this.getHornSound(), this.field_70170_p, this.func_233580_cy_(), null, SoundCategory.MASTER, 1.0f);
    }

    public abstract SoundEvent getStopSound();

    public abstract SoundEvent getFailSound();

    public abstract SoundEvent getCrashSound();

    public abstract SoundEvent getStartSound();

    public abstract SoundEvent getStartingSound();

    public abstract SoundEvent getIdleSound();

    public abstract SoundEvent getHighSound();

    public abstract SoundEvent getHornSound();

    @OnlyIn(value=Dist.CLIENT)
    public void checkIdleLoop() {
        if (!this.isSoundPlaying((ISound)this.idleLoop)) {
            this.idleLoop = new SoundLoopIdle(this, this.getIdleSound(), SoundCategory.MASTER);
            ModSounds.playSoundLoop(this.idleLoop, this.field_70170_p);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void checkHighLoop() {
        if (!this.isSoundPlaying((ISound)this.highLoop)) {
            this.highLoop = new SoundLoopHigh(this, this.getHighSound(), SoundCategory.MASTER);
            ModSounds.playSoundLoop(this.highLoop, this.field_70170_p);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void checkStartLoop() {
        if (!this.isSoundPlaying((ISound)this.startLoop)) {
            this.startLoop = new SoundLoopStart(this, this.getStartSound(), SoundCategory.MASTER);
            ModSounds.playSoundLoop(this.startLoop, this.field_70170_p);
        }
    }

    public void onHornPressed(PlayerEntity player) {
        if (this.field_70170_p.field_72995_K) {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageCarHorn(true, player));
        } else {
            if (this instanceof EntityCarBatteryBase) {
                EntityCarBatteryBase car = (EntityCarBatteryBase)this;
                if (car.getBatteryLevel() < 10) {
                    return;
                }
                if (((Boolean)Main.SERVER_CONFIG.useBattery.get()).booleanValue()) {
                    car.setBatteryLevel(car.getBatteryLevel() - 10);
                }
            }
            this.playHornSound();
            if (((Boolean)Main.SERVER_CONFIG.hornFlee.get()).booleanValue()) {
                double radius = 15.0;
                List list = this.field_70170_p.func_217357_a(MobEntity.class, new AxisAlignedBB(this.func_226277_ct_() - radius, this.func_226278_cu_() - radius, this.func_226281_cx_() - radius, this.func_226277_ct_() + radius, this.func_226278_cu_() + radius, this.func_226281_cx_() + radius));
                for (MobEntity ent : list) {
                    this.fleeEntity(ent);
                }
            }
        }
    }

    public void fleeEntity(MobEntity entity) {
        double fleeDistance = 10.0;
        Vector3d vecCar = new Vector3d(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        Vector3d vecEntity = new Vector3d(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
        Vector3d fleeDir = vecEntity.func_178788_d(vecCar);
        fleeDir = fleeDir.func_72432_b();
        Vector3d fleePos = new Vector3d(vecEntity.field_72450_a + fleeDir.field_72450_a * fleeDistance, vecEntity.field_72448_b + fleeDir.field_72448_b * fleeDistance, vecEntity.field_72449_c + fleeDir.field_72449_c * fleeDistance);
        entity.func_70661_as().func_75492_a(fleePos.field_72450_a, fleePos.field_72448_b, fleePos.field_72449_c, 2.5);
    }
}

