/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.entity.car.base;

import de.maxhenkel.car.Main;
import de.maxhenkel.car.entity.car.base.EntityCarDamageBase;
import de.maxhenkel.car.entity.car.base.EntityCarTemperatureBase;
import de.maxhenkel.car.sounds.ModSounds;
import de.maxhenkel.car.sounds.SoundLoopStarting;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class EntityCarBatteryBase
extends EntityCarTemperatureBase {
    private static final DataParameter<Integer> BATTERY_LEVEL = EntityDataManager.func_187226_a(EntityCarBatteryBase.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> STARTING_TIME = EntityDataManager.func_187226_a(EntityCarBatteryBase.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> STARTING = EntityDataManager.func_187226_a(EntityCarBatteryBase.class, (IDataSerializer)DataSerializers.field_187198_h);
    @OnlyIn(value=Dist.CLIENT)
    private SoundLoopStarting startingLoop;
    private boolean carStopped;
    private boolean carStarted;
    private int timeSinceStarted;
    private int timeToStart;

    public EntityCarBatteryBase(EntityType type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    public void func_70071_h_() {
        int time;
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            if (this.isStarted()) {
                ++this.timeSinceStarted;
                if (this.field_70173_aa % 2 == 0) {
                    this.spawnParticles(this.getSpeed() > 0.1f);
                }
            } else {
                this.timeSinceStarted = 0;
            }
            return;
        }
        if (this.isStarting()) {
            if (this.field_70173_aa % 2 == 0) {
                this.setBatteryLevel(this.getBatteryLevel() - this.getBatteryUsage());
            }
            this.setStartingTime(this.getStartingTime() + 1);
            if (this.getBatteryLevel() <= 0) {
                this.setStarting(false, true);
            }
        } else {
            this.setStartingTime(0);
        }
        if ((time = this.getStartingTime()) > 0) {
            if (this.timeToStart <= 0) {
                this.timeToStart = this.getTimeToStart();
            }
            if (time > this.getTimeToStart()) {
                this.startCarEngine();
                this.timeToStart = 0;
            }
        }
        if (this.isStarted()) {
            this.setStartingTime(0);
            this.carStarted = true;
            float speedPerc = this.getSpeed() / this.getMaxSpeed();
            int chargingRate = (int)(speedPerc * 7.0f);
            if (chargingRate < 5) {
                chargingRate = 1;
            }
            if (this.field_70173_aa % 20 == 0) {
                this.setBatteryLevel(this.getBatteryLevel() + chargingRate);
            }
        }
    }

    public void spawnParticles(boolean driving) {
        if (!this.field_70170_p.field_72995_K) {
            return;
        }
        Vector3d lookVec = this.func_70040_Z().func_72432_b();
        double offX = lookVec.field_72450_a * -1.0;
        double offY = lookVec.field_72448_b;
        double offZ = lookVec.field_72449_c * -1.0;
        if (this.timeSinceStarted > 0 && this.timeSinceStarted < 20 && this.getTemperature() < 50.0f) {
            double speedX = lookVec.field_72450_a * -0.1;
            double speedZ = lookVec.field_72449_c * -0.1;
            if (this instanceof EntityCarDamageBase) {
                float damage = ((EntityCarDamageBase)this).getDamage();
                int count = 1;
                double r = 0.1;
                if (damage > 0.9f) {
                    count = 6;
                    r = 0.7;
                } else if (damage > 0.75f) {
                    count = 3;
                    r = 0.7;
                } else if (damage > 0.5f) {
                    count = 2;
                    r = 0.3;
                }
                for (int i = 0; i <= count; ++i) {
                    this.spawnParticle((IParticleData)ParticleTypes.field_197594_E, offX, offY, offZ, speedX, speedZ, r);
                }
            } else {
                this.spawnParticle((IParticleData)ParticleTypes.field_197594_E, offX, offY, offZ, speedX, speedZ);
            }
        } else if (driving) {
            double speedX = lookVec.field_72450_a * -0.2;
            double speedZ = lookVec.field_72449_c * -0.2;
            this.spawnParticle((IParticleData)ParticleTypes.field_197601_L, offX, offY, offZ, speedX, speedZ);
        } else {
            double speedX = lookVec.field_72450_a * -0.05;
            double speedZ = lookVec.field_72449_c * -0.05;
            this.spawnParticle((IParticleData)ParticleTypes.field_197601_L, offX, offY, offZ, speedX, speedZ);
        }
    }

    private void spawnParticle(IParticleData particleTypes, double offX, double offY, double offZ, double speedX, double speedZ, double random) {
        this.field_70170_p.func_195594_a(particleTypes, this.func_226277_ct_() + offX + (this.field_70146_Z.nextDouble() * random - random / 2.0), this.func_226278_cu_() + offY + (this.field_70146_Z.nextDouble() * random - random / 2.0) + this.getCarHeight() / 8.0, this.func_226281_cx_() + offZ + (this.field_70146_Z.nextDouble() * random - random / 2.0), speedX, 0.0, speedZ);
    }

    private void spawnParticle(IParticleData particleTypes, double offX, double offY, double offZ, double speedX, double speedZ) {
        this.spawnParticle(particleTypes, offX, offY, offZ, speedX, speedZ, 0.1);
    }

    public int getTimeToStart() {
        int time = this.field_70146_Z.nextInt(10) + 5;
        float temp = this.getTemperature();
        if (temp < 0.0f) {
            time += 40;
        } else if (temp < 10.0f) {
            time += 35;
        } else if (temp < 30.0f) {
            time += 10;
        } else if (temp < 60.0f) {
            time += 5;
        }
        float batteryPerc = this.getBatteryPercentage();
        if (batteryPerc < 0.5f) {
            time += 20 + this.field_70146_Z.nextInt(10);
        } else if (batteryPerc < 0.75f) {
            time += 10 + this.field_70146_Z.nextInt(10);
        }
        return time;
    }

    public int getBatteryUsage() {
        if (!((Boolean)Main.SERVER_CONFIG.useBattery.get()).booleanValue()) {
            return 0;
        }
        float temp = this.getBiomeTemperatureCelsius();
        int baseUsage = 2;
        if (temp < 0.0f) {
            baseUsage += 2;
        } else if (temp < 15.0f) {
            ++baseUsage;
        }
        return baseUsage;
    }

    @Override
    public void setStarted(boolean started) {
        this.setStarting(false, false);
        super.setStarted(started);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BATTERY_LEVEL, (Object)this.getMaxBatteryLevel());
        this.field_70180_af.func_187214_a(STARTING_TIME, (Object)0);
        this.field_70180_af.func_187214_a(STARTING, (Object)Boolean.FALSE);
    }

    public int getStartingTime() {
        return (Integer)this.field_70180_af.func_187225_a(STARTING_TIME);
    }

    public void setStartingTime(int time) {
        this.field_70180_af.func_187227_b(STARTING_TIME, (Object)time);
    }

    public boolean isStarting() {
        return (Boolean)this.field_70180_af.func_187225_a(STARTING);
    }

    public void setStarting(boolean starting, boolean playFailSound) {
        if (starting) {
            if (this.getBatteryLevel() <= 0) {
                return;
            }
            if (this.isStarted()) {
                this.setStarted(false, true, false);
                this.carStopped = true;
                return;
            }
        } else {
            if (this.carStarted || this.carStopped) {
                this.carStopped = false;
                this.carStarted = false;
                return;
            }
            if (playFailSound && this.getBatteryLevel() > 0) {
                this.playFailSound();
            }
        }
        this.field_70180_af.func_187227_b(STARTING, (Object)starting);
    }

    public float getBatterySoundPitchLevel() {
        int batteryLevel = this.getBatteryLevel();
        int startLevel = this.getMaxBatteryLevel() / 3;
        float basePitch = 1.0f - 0.002f * (float)this.getStartingTime();
        if (batteryLevel > startLevel) {
            return basePitch;
        }
        int levelUnder = startLevel - batteryLevel;
        float perc = (float)levelUnder / (float)startLevel;
        return basePitch - perc / 2.3f;
    }

    public float getBatteryPercentage() {
        return (float)this.getBatteryLevel() / (float)this.getMaxBatteryLevel();
    }

    public void setBatteryLevel(int level) {
        if (level < 0) {
            level = 0;
        } else if (level > this.getMaxBatteryLevel()) {
            level = this.getMaxBatteryLevel();
        }
        this.field_70180_af.func_187227_b(BATTERY_LEVEL, (Object)level);
    }

    public int getBatteryLevel() {
        return (Integer)this.field_70180_af.func_187225_a(BATTERY_LEVEL);
    }

    public int getMaxBatteryLevel() {
        return 1000;
    }

    @Override
    public void updateSounds() {
        if (!this.isStarted() && this.isStarting()) {
            this.checkStartingLoop();
        }
        super.updateSounds();
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setBatteryLevel(compound.func_74762_e("battery"));
    }

    @Override
    protected void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("battery", this.getBatteryLevel());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void checkStartingLoop() {
        if (!this.isSoundPlaying((ISound)this.startingLoop)) {
            this.startingLoop = new SoundLoopStarting(this, this.getStartingSound(), SoundCategory.MASTER);
            ModSounds.playSoundLoop(this.startingLoop, this.field_70170_p);
        }
    }

    @Override
    public void playFailSound() {
        ModSounds.playSound(this.getFailSound(), this.field_70170_p, this.func_233580_cy_(), null, SoundCategory.MASTER, 1.0f, this.getBatterySoundPitchLevel());
    }
}

