/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.items;

import de.maxhenkel.car.ModItemGroups;
import de.maxhenkel.car.blocks.BlockPaint;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.gui.ContainerPainter;
import de.maxhenkel.car.gui.SlotPainter;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class ItemPainter
extends Item {
    private boolean isYellow;

    public ItemPainter(boolean isYellow) {
        super(new Item.Properties().func_200917_a(1).func_200918_c(1024).func_200916_a(ModItemGroups.TAB_CAR));
        this.setRegistryName(new ResourceLocation("car", "painter" + (isYellow ? "_yellow" : "")));
        this.isYellow = isYellow;
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        if (state.func_177230_c() instanceof BlockPaint) {
            return 50.0f;
        }
        return super.func_150893_a(stack, state);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, final PlayerEntity playerIn, final Hand handIn) {
        if (playerIn.func_225608_bj_() && playerIn instanceof ServerPlayerEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerIn), (INamedContainerProvider)new INamedContainerProvider(){

                public ITextComponent func_145748_c_() {
                    return ItemPainter.this.func_200295_i(playerIn.func_184586_b(handIn));
                }

                @Nullable
                public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
                    return new ContainerPainter(i, playerInventory, ItemPainter.this.isYellow);
                }
            }, packetBuffer -> packetBuffer.writeBoolean(this.isYellow));
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (context.func_195999_j().func_225608_bj_()) {
            return ActionResultType.PASS;
        }
        if (!context.func_196000_l().equals((Object)Direction.UP)) {
            return ActionResultType.FAIL;
        }
        if (!BlockPaint.canPlaceBlockAt(context.func_195991_k(), context.func_195995_a().func_177984_a())) {
            return ActionResultType.FAIL;
        }
        if (!context.func_195991_k().func_175623_d(context.func_195995_a().func_177984_a())) {
            return ActionResultType.FAIL;
        }
        ItemStack stack1 = SlotPainter.getPainterStack(context.func_195999_j());
        if (stack1.func_190926_b()) {
            return ActionResultType.FAIL;
        }
        BlockPaint block = this.getSelectedPaint(SlotPainter.getPainterID(stack1));
        if (block == null) {
            return ActionResultType.FAIL;
        }
        BlockState state = (BlockState)block.func_176223_P().func_206870_a((Property)BlockPaint.FACING, (Comparable)context.func_195999_j().func_174811_aO());
        context.func_195991_k().func_175656_a(context.func_195995_a().func_177984_a(), state);
        stack1.func_222118_a(1, (LivingEntity)context.func_195999_j(), playerEntity -> playerEntity.func_213334_d(context.func_221531_n()));
        return ActionResultType.CONSUME;
    }

    private BlockPaint getSelectedPaint(int id) {
        if (id < 0 || id >= ModBlocks.PAINTS.length) {
            return null;
        }
        BlockPaint block = this.isYellow ? ModBlocks.YELLOW_PAINTS[id] : ModBlocks.PAINTS[id];
        return block;
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> textComponents, ITooltipFlag tooltipFlag) {
        BlockPaint paint = this.getSelectedPaint(SlotPainter.getPainterID(stack));
        if (paint != null) {
            textComponents.add((ITextComponent)new TranslationTextComponent("tooltip.painter", new Object[]{new TranslationTextComponent(paint.func_149739_a()).func_240699_a_(TextFormatting.DARK_GRAY)}).func_240699_a_(TextFormatting.GRAY));
        }
        super.func_77624_a(stack, world, textComponents, tooltipFlag);
    }
}

