/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity;

import de.maxhenkel.car.Main;
import de.maxhenkel.car.blocks.tileentity.TileEntityBase;
import de.maxhenkel.car.fluids.ModFluids;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.IIntArray;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntitySplitTank
extends TileEntityBase
implements ITickableTileEntity,
IFluidHandler,
IInventory {
    private int currentMix = 0;
    public int maxMix;
    public int mixUsage;
    private int currentBioDiesel;
    public int maxBioDiesel;
    public int bioDieselGeneration;
    private int currentGlycerin;
    public int maxGlycerin;
    public int glycerinGeneration;
    public int generatingTime;
    private int timeToGenerate;
    protected Inventory inventory;
    public final IIntArray FIELDS = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return TileEntitySplitTank.this.currentMix;
                }
                case 1: {
                    return TileEntitySplitTank.this.currentBioDiesel;
                }
                case 2: {
                    return TileEntitySplitTank.this.currentGlycerin;
                }
                case 3: {
                    return TileEntitySplitTank.this.timeToGenerate;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    TileEntitySplitTank.this.currentMix = value;
                    break;
                }
                case 1: {
                    TileEntitySplitTank.this.currentBioDiesel = value;
                    break;
                }
                case 2: {
                    TileEntitySplitTank.this.currentGlycerin = value;
                    break;
                }
                case 3: {
                    TileEntitySplitTank.this.timeToGenerate = value;
                }
            }
        }

        public int func_221478_a() {
            return 4;
        }
    };

    public TileEntitySplitTank() {
        super(Main.SPLIT_TANK_TILE_ENTITY_TYPE);
        this.inventory = new Inventory(0);
        this.maxMix = (Integer)Main.SERVER_CONFIG.splitTankFluidStorage.get();
        this.currentBioDiesel = 0;
        this.maxBioDiesel = (Integer)Main.SERVER_CONFIG.splitTankFluidStorage.get();
        this.currentGlycerin = 0;
        this.maxGlycerin = (Integer)Main.SERVER_CONFIG.splitTankFluidStorage.get();
        this.generatingTime = (Integer)Main.SERVER_CONFIG.splitTankGeneratingTime.get();
        this.timeToGenerate = 0;
        this.mixUsage = (Integer)Main.SERVER_CONFIG.splitTankMixUsage.get();
        this.glycerinGeneration = (Integer)Main.SERVER_CONFIG.splitTankGlycerinGeneration.get();
        this.bioDieselGeneration = (Integer)Main.SERVER_CONFIG.splitTankBioDieselGeneration.get();
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.timeToGenerate > 0) {
            --this.timeToGenerate;
            if (this.timeToGenerate == 0 && this.currentMix - this.mixUsage >= 0) {
                this.currentMix -= this.mixUsage;
                if (this.currentBioDiesel + this.bioDieselGeneration <= this.maxBioDiesel) {
                    this.currentBioDiesel += this.bioDieselGeneration;
                }
                if (this.currentGlycerin + this.glycerinGeneration <= this.maxGlycerin) {
                    this.currentGlycerin += this.glycerinGeneration;
                }
            }
        } else if (this.currentMix >= this.mixUsage && this.currentBioDiesel + this.bioDieselGeneration <= this.maxBioDiesel && this.currentGlycerin + this.glycerinGeneration <= this.maxGlycerin) {
            this.timeToGenerate = this.generatingTime;
        }
        if (this.field_145850_b.func_82737_E() % 200L == 0L) {
            this.synchronize();
        }
        this.func_70296_d();
    }

    public float getBioDieselPerc() {
        return (float)this.currentBioDiesel / (float)this.maxBioDiesel;
    }

    public float getGlycerinPerc() {
        return (float)this.currentGlycerin / (float)this.maxGlycerin;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("mix", this.currentMix);
        compound.func_74768_a("bio_diesel", this.currentBioDiesel);
        compound.func_74768_a("glycerin", this.currentGlycerin);
        compound.func_74768_a("time", this.timeToGenerate);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_230337_a_(BlockState blockState, CompoundNBT compound) {
        this.currentMix = compound.func_74762_e("mix");
        this.currentBioDiesel = compound.func_74762_e("bio_diesel");
        this.currentGlycerin = compound.func_74762_e("glycerin");
        this.timeToGenerate = compound.func_74762_e("timeToGenerate");
        super.func_230337_a_(blockState, compound);
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int index) {
        return this.inventory.func_70301_a(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return this.inventory.func_70298_a(index, count);
    }

    public ItemStack func_70304_b(int index) {
        return this.inventory.func_70304_b(index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventory.func_70299_a(index, stack);
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(PlayerEntity player) {
        return this.inventory.func_70300_a(player);
    }

    public boolean func_191420_l() {
        return this.inventory.func_191420_l();
    }

    public void func_174889_b(PlayerEntity player) {
        this.inventory.func_174889_b(player);
    }

    public void func_174886_c(PlayerEntity player) {
        this.inventory.func_174886_c(player);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.inventory.func_94041_b(index, stack);
    }

    public void func_174888_l() {
        this.inventory.func_174888_l();
    }

    public int getCurrentMix() {
        return this.currentMix;
    }

    public int getCurrentBioDiesel() {
        return this.currentBioDiesel;
    }

    public int getCurrentGlycerin() {
        return this.currentGlycerin;
    }

    public int getTimeToGenerate() {
        return this.timeToGenerate;
    }

    @Override
    public ITextComponent getTranslatedName() {
        return new TranslationTextComponent("block.car.split_tank");
    }

    @Override
    public IIntArray getFields() {
        return this.FIELDS;
    }

    public int getTanks() {
        return 3;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        if (tank == 0) {
            return new FluidStack((Fluid)ModFluids.CANOLA_METHANOL_MIX, this.currentMix);
        }
        if (tank == 1) {
            return new FluidStack((Fluid)ModFluids.BIO_DIESEL, this.currentBioDiesel);
        }
        return new FluidStack((Fluid)ModFluids.GLYCERIN, this.currentGlycerin);
    }

    public int getTankCapacity(int tank) {
        if (tank == 0) {
            return this.maxMix;
        }
        if (tank == 1) {
            return this.maxBioDiesel;
        }
        return this.maxGlycerin;
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        if (tank == 0) {
            return stack.getFluid().equals(ModFluids.CANOLA_METHANOL_MIX);
        }
        if (tank == 1) {
            return stack.getFluid().equals(ModFluids.BIO_DIESEL);
        }
        return stack.getFluid().equals(ModFluids.GLYCERIN);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.getFluid().equals(ModFluids.CANOLA_METHANOL_MIX)) {
            int amount = Math.min(this.maxMix - this.currentMix, resource.getAmount());
            if (action.execute()) {
                this.currentMix += amount;
                this.func_70296_d();
            }
            return amount;
        }
        return 0;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.getFluid().equals(ModFluids.GLYCERIN)) {
            int amount = Math.min(resource.getAmount(), this.currentGlycerin);
            if (action.execute()) {
                this.currentGlycerin -= amount;
                this.func_70296_d();
            }
            return new FluidStack((Fluid)ModFluids.GLYCERIN, amount);
        }
        if (resource.getFluid().equals(ModFluids.BIO_DIESEL)) {
            int amount = Math.min(resource.getAmount(), this.currentBioDiesel);
            if (action.execute()) {
                this.currentBioDiesel -= amount;
                this.func_70296_d();
            }
            return new FluidStack((Fluid)ModFluids.BIO_DIESEL, amount);
        }
        return FluidStack.EMPTY;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (this.currentGlycerin > this.currentBioDiesel) {
            int amount = Math.min(maxDrain, this.currentGlycerin);
            if (action.execute()) {
                this.currentGlycerin -= amount;
                this.func_70296_d();
            }
            return new FluidStack((Fluid)ModFluids.GLYCERIN, amount);
        }
        int amount = Math.min(maxDrain, this.currentBioDiesel);
        if (action.execute()) {
            this.currentBioDiesel -= amount;
            this.func_70296_d();
        }
        return new FluidStack((Fluid)ModFluids.BIO_DIESEL, amount);
    }
}

