/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.entity.car.base;

import de.maxhenkel.car.Main;
import de.maxhenkel.car.config.Fuel;
import de.maxhenkel.car.corelib.client.obj.OBJModelInstance;
import de.maxhenkel.car.corelib.dataserializers.DataSerializerItemList;
import de.maxhenkel.car.entity.car.base.EntityCarLicensePlateBase;
import de.maxhenkel.car.entity.car.parts.Part;
import de.maxhenkel.car.entity.car.parts.PartBody;
import de.maxhenkel.car.entity.car.parts.PartBodyTransporter;
import de.maxhenkel.car.entity.car.parts.PartContainer;
import de.maxhenkel.car.entity.car.parts.PartEngine;
import de.maxhenkel.car.entity.car.parts.PartEngineTruck;
import de.maxhenkel.car.entity.car.parts.PartLicensePlateHolder;
import de.maxhenkel.car.entity.car.parts.PartModel;
import de.maxhenkel.car.entity.car.parts.PartTank;
import de.maxhenkel.car.entity.car.parts.PartTankContainer;
import de.maxhenkel.car.entity.car.parts.PartWheelBase;
import de.maxhenkel.car.integration.jei.CarRecipe;
import de.maxhenkel.car.integration.jei.CarRecipeBuilder;
import de.maxhenkel.car.items.ICarPart;
import de.maxhenkel.car.items.ItemKey;
import de.maxhenkel.car.sounds.ModSounds;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class EntityGenericCar
extends EntityCarLicensePlateBase {
    private static final DataParameter<NonNullList<ItemStack>> PARTS = EntityDataManager.func_187226_a(EntityGenericCar.class, DataSerializerItemList.ITEM_LIST);
    private List<Part> parts;
    private boolean isInitialized;
    private boolean isSpawned = true;
    private List<OBJModelInstance<EntityGenericCar>> modelInstances = new ArrayList<OBJModelInstance<EntityGenericCar>>();

    public EntityGenericCar(EntityType type, World worldIn) {
        super(type, worldIn);
    }

    public EntityGenericCar(World worldIn) {
        this(Main.CAR_ENTITY_TYPE, worldIn);
    }

    private List<Part> getParts() {
        if (this.parts == null) {
            this.parts = new ArrayList<Part>();
        }
        return this.parts;
    }

    @Override
    public float getWheelRotationAmount() {
        PartWheelBase wheel = this.getPartByClass(PartWheelBase.class);
        if (wheel == null) {
            return super.getWheelRotationAmount();
        }
        return wheel.getRotationModifier() * this.getSpeed();
    }

    @Override
    public int getFluidInventorySize() {
        PartTankContainer tank = this.getPartByClass(PartTankContainer.class);
        if (tank == null) {
            return 0;
        }
        return tank.getFluidAmount();
    }

    @Override
    public float getMaxSpeed() {
        PartEngine engine = this.getPartByClass(PartEngine.class);
        if (engine == null) {
            return 0.0f;
        }
        PartBody chassis = this.getPartByClass(PartBody.class);
        if (chassis == null) {
            return 0.0f;
        }
        return engine.getMaxSpeed() * chassis.getMaxSpeed();
    }

    @Override
    public float getMaxReverseSpeed() {
        PartEngine engine = this.getPartByClass(PartEngine.class);
        if (engine == null) {
            return 0.0f;
        }
        return engine.getMaxReverseSpeed();
    }

    @Override
    public float getAcceleration() {
        PartEngine engine = this.getPartByClass(PartEngine.class);
        if (engine == null) {
            return 0.0f;
        }
        PartBody chassis = this.getPartByClass(PartBody.class);
        if (chassis == null) {
            return 0.0f;
        }
        return engine.getAcceleration() * chassis.getAcceleration();
    }

    @Override
    public float getMaxRotationSpeed() {
        PartBody chassis = this.getPartByClass(PartBody.class);
        if (chassis == null) {
            return 5.0f;
        }
        return chassis.getMaxRotationSpeed();
    }

    @Override
    public float getMinRotationSpeed() {
        PartBody chassis = this.getPartByClass(PartBody.class);
        if (chassis == null) {
            return 2.0f;
        }
        return chassis.getMinRotationSpeed();
    }

    @Override
    public float getRollResistance() {
        return 0.02f;
    }

    @Override
    public float getOptimalTemperature() {
        return 90.0f;
    }

    @Override
    public int getMaxFuel() {
        PartTank tank = this.getPartByClass(PartTank.class);
        if (tank == null) {
            return 0;
        }
        return tank.getSize();
    }

    @Override
    public int getEfficiency(@Nullable Fluid fluid) {
        PartEngine engine = this.getPartByClass(PartEngine.class);
        if (engine == null) {
            return 0;
        }
        PartBody chassis = this.getPartByClass(PartBody.class);
        if (chassis == null) {
            return 0;
        }
        int fluidEfficiency = 0;
        if (fluid == null) {
            fluidEfficiency = 100;
        } else {
            Fuel fuel = Main.FUEL_CONFIG.getFuels().getOrDefault(fluid, null);
            if (fuel != null) {
                fluidEfficiency = fuel.getEfficiency();
            }
        }
        return (int)Math.ceil(chassis.getFuelEfficiency() * engine.getFuelEfficiency() * (float)fluidEfficiency);
    }

    @Override
    public float getRotationModifier() {
        return 0.5f;
    }

    @Override
    public float getPitch() {
        PartEngine engine = this.getPartByClass(PartEngine.class);
        if (engine instanceof PartEngineTruck) {
            return 1.0f + 0.35f * Math.abs(this.getSpeed()) / this.getMaxSpeed();
        }
        return Math.abs(this.getSpeed()) / this.getMaxSpeed();
    }

    @Override
    public double getPlayerYOffset() {
        return 0.2;
    }

    @Override
    public Vector3d[] getPlayerOffsets() {
        PartBody chassis = this.getPartByClass(PartBody.class);
        if (chassis == null) {
            return new Vector3d[]{new Vector3d(0.55, 0.0, -0.38), new Vector3d(0.55, 0.0, 0.38)};
        }
        return chassis.getPlayerOffsets();
    }

    @Override
    public int getPassengerSize() {
        PartBody chassis = this.getPartByClass(PartBody.class);
        if (chassis == null) {
            return 0;
        }
        return chassis.getPlayerOffsets().length;
    }

    @Override
    public Vector3d getLicensePlateOffset() {
        PartBody chassis = this.getPartByClass(PartBody.class);
        if (chassis == null) {
            return new Vector3d(0.0, 0.0, 0.0);
        }
        PartLicensePlateHolder numberPlate = this.getPartByClass(PartLicensePlateHolder.class);
        if (numberPlate == null) {
            return new Vector3d(0.0, 0.0, 0.0);
        }
        Vector3d offset = chassis.getNumberPlateOffset();
        Vector3d textOffset = numberPlate.getTextOffset();
        return new Vector3d(offset.field_72450_a + textOffset.field_72450_a, -offset.field_72448_b + textOffset.field_72448_b, offset.field_72449_c - textOffset.field_72449_c);
    }

    @Override
    public boolean doesEnterThirdPerson() {
        return true;
    }

    @Override
    public SoundEvent getStopSound() {
        PartEngine engine = this.getPartByClass(PartEngine.class);
        if (engine == null) {
            return ModSounds.ENGINE_STOP;
        }
        return engine.getStopSound();
    }

    @Override
    public SoundEvent getFailSound() {
        PartEngine engine = this.getPartByClass(PartEngine.class);
        if (engine == null) {
            return ModSounds.ENGINE_FAIL;
        }
        return engine.getFailSound();
    }

    @Override
    public SoundEvent getCrashSound() {
        PartEngine engine = this.getPartByClass(PartEngine.class);
        if (engine == null) {
            return ModSounds.CAR_CRASH;
        }
        return engine.getCrashSound();
    }

    @Override
    public SoundEvent getStartSound() {
        PartEngine engine = this.getPartByClass(PartEngine.class);
        if (engine == null) {
            return ModSounds.ENGINE_START;
        }
        return engine.getStartSound();
    }

    @Override
    public SoundEvent getStartingSound() {
        PartEngine engine = this.getPartByClass(PartEngine.class);
        if (engine == null) {
            return ModSounds.ENGINE_STARTING;
        }
        return engine.getStartingSound();
    }

    @Override
    public SoundEvent getIdleSound() {
        PartEngine engine = this.getPartByClass(PartEngine.class);
        if (engine == null) {
            return ModSounds.ENGINE_IDLE;
        }
        return engine.getIdleSound();
    }

    @Override
    public SoundEvent getHighSound() {
        PartEngine engine = this.getPartByClass(PartEngine.class);
        if (engine == null) {
            return ModSounds.ENGINE_HIGH;
        }
        return engine.getHighSound();
    }

    @Override
    public SoundEvent getHornSound() {
        PartEngine engine = this.getPartByClass(PartEngine.class);
        if (engine == null) {
            return ModSounds.CAR_HORN;
        }
        return engine.getHornSound();
    }

    protected ITextComponent func_225513_by_() {
        PartBody body = this.getPartByClass(PartBody.class);
        if (body == null) {
            return super.func_225513_by_();
        }
        return new TranslationTextComponent("car_name." + body.getTranslationKey(), new Object[]{new TranslationTextComponent("car_variant." + body.getMaterialTranslationKey())});
    }

    public ITextComponent getShortName() {
        PartBody body = this.getPartByClass(PartBody.class);
        if (body == null) {
            return this.func_225513_by_();
        }
        return new TranslationTextComponent("car_short_name." + body.getTranslationKey());
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PARTS, (Object)NonNullList.func_191196_a());
    }

    public <T extends Part> T getPartByClass(Class<T> clazz) {
        for (Part part : this.getParts()) {
            if (!clazz.isInstance(part)) continue;
            return (T)part;
        }
        return null;
    }

    public void setPartSerializer() {
        NonNullList stacks = NonNullList.func_191197_a((int)this.partInventory.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < this.partInventory.func_70302_i_(); ++i) {
            stacks.set(i, (Object)this.partInventory.func_70301_a(i));
        }
        this.field_70180_af.func_187227_b(PARTS, (Object)stacks);
    }

    private boolean updateClientSideItems() {
        NonNullList stacks = (NonNullList)this.field_70180_af.func_187225_a(PARTS);
        if (stacks.isEmpty()) {
            return false;
        }
        for (int i = 0; i < stacks.size(); ++i) {
            this.partInventory.func_70299_a(i, (ItemStack)stacks.get(i));
        }
        return true;
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150296_c().stream().allMatch(s -> s.equals("id"))) {
            this.randomizeParts();
            this.func_70299_a(0, ItemKey.getKeyForCar(this.func_110124_au()));
            this.func_70299_a(1, ItemKey.getKeyForCar(this.func_110124_au()));
            this.setFuelAmount(100);
            this.setBatteryLevel(500);
            this.initTemperature();
        }
        this.setPartSerializer();
        this.tryInitPartsAndModel();
    }

    protected void randomizeParts() {
        List<CarRecipe> allRecipes = CarRecipeBuilder.getAllRecipes();
        CarRecipe recipe = allRecipes.get(new Random().nextInt(allRecipes.size()));
        this.getParts().clear();
        this.partInventory.func_174888_l();
        List<ItemStack> inputs = recipe.getInputs();
        for (int i = 0; i < inputs.size(); ++i) {
            this.partInventory.func_70299_a(i, inputs.get(i));
        }
    }

    public void setIsSpawned(boolean isSpawned) {
        this.isSpawned = isSpawned;
    }

    public boolean isSpawned() {
        return this.isSpawned;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.tryInitPartsAndModel();
    }

    public void tryInitPartsAndModel() {
        if (!this.isInitialized) {
            if (this.field_70170_p.field_72995_K) {
                if (!this.isSpawned || this.updateClientSideItems()) {
                    this.initParts();
                    this.initModel();
                    this.isInitialized = true;
                }
            } else {
                this.initParts();
                this.isInitialized = true;
            }
        }
    }

    public List<Part> getModelParts() {
        return Collections.unmodifiableList(this.getParts());
    }

    public void initParts() {
        this.getParts().clear();
        for (int i = 0; i < this.partInventory.func_70302_i_(); ++i) {
            ICarPart itemCarPart;
            Part part;
            ItemStack stack = this.partInventory.func_70301_a(i);
            if (!(stack.func_77973_b() instanceof ICarPart) || (part = (itemCarPart = (ICarPart)stack.func_77973_b()).getPart(stack)) == null) continue;
            this.getParts().add(part);
        }
        this.checkInitializing();
    }

    private void checkInitializing() {
        PartWheelBase partWheels;
        PartBody body = this.getPartByClass(PartBody.class);
        if (body instanceof PartBodyTransporter) {
            PartContainer container = this.getPartByClass(PartContainer.class);
            if (this.externalInventory.func_70302_i_() <= 0) {
                this.externalInventory = container != null ? new Inventory(54) : new Inventory(27);
            }
        }
        if ((partWheels = this.getPartByClass(PartWheelBase.class)) != null) {
            this.field_70138_W = partWheels.getStepHeight();
        }
    }

    @Override
    public double getCarWidth() {
        PartBody body = this.getPartByClass(PartBody.class);
        if (body != null) {
            return body.getWidth();
        }
        return super.getCarWidth();
    }

    @Override
    public double getCarHeight() {
        PartBody body = this.getPartByClass(PartBody.class);
        if (body != null) {
            return body.getHeight();
        }
        return super.getCarHeight();
    }

    protected void initModel() {
        this.modelInstances.clear();
        boolean addedWheels = false;
        for (Part part : this.getParts()) {
            if (!(part instanceof PartModel)) continue;
            if (part instanceof PartWheelBase) {
                if (addedWheels) continue;
                addedWheels = true;
            }
            this.modelInstances.addAll(((PartModel)part).getInstances(this));
        }
    }

    public List<OBJModelInstance<EntityGenericCar>> getModels() {
        return this.modelInstances;
    }
}

