/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.maxhenkel.car.blocks.tileentity.TileEntityGenerator;
import de.maxhenkel.car.corelib.inventory.ScreenBase;
import de.maxhenkel.car.gui.ContainerGenerator;
import java.util.ArrayList;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiGenerator
extends ScreenBase<ContainerGenerator> {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("car", "textures/gui/gui_generator.png");
    private PlayerInventory playerInv;
    private TileEntityGenerator tile;

    public GuiGenerator(ContainerGenerator containerGenerator, PlayerInventory playerInv, ITextComponent title) {
        super(GUI_TEXTURE, containerGenerator, playerInv, title);
        this.playerInv = playerInv;
        this.tile = containerGenerator.getGenerator();
        this.field_146999_f = 176;
        this.field_147000_g = 166;
    }

    @Override
    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        ArrayList<IReorderingProcessor> list;
        super.func_230451_b_(matrixStack, mouseX, mouseY);
        this.field_230712_o_.func_238422_b_(matrixStack, this.playerInv.func_145748_c_().func_241878_f(), 8.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
        this.field_230712_o_.func_238422_b_(matrixStack, this.tile.func_145748_c_().func_241878_f(), 62.0f, 6.0f, 0x404040);
        if (mouseX >= this.field_147003_i + 122 && mouseX <= this.field_147003_i + 16 + 122 && mouseY >= this.field_147009_r + 8 && mouseY <= this.field_147009_r + 57 + 8) {
            list = new ArrayList<IReorderingProcessor>();
            list.add(new TranslationTextComponent("tooltip.energy", new Object[]{this.tile.getStoredEnergy()}).func_241878_f());
            this.func_238654_b_(matrixStack, list, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
        if (mouseX >= this.field_147003_i + 39 && mouseX <= this.field_147003_i + 16 + 39 && mouseY >= this.field_147009_r + 8 && mouseY <= this.field_147009_r + 57 + 8) {
            list = new ArrayList();
            list.add(new TranslationTextComponent("tooltip.fuel", new Object[]{this.tile.getCurrentMillibuckets()}).func_241878_f());
            this.func_238654_b_(matrixStack, list, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
    }

    @Override
    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        super.func_230450_a_(matrixStack, partialTicks, mouseX, mouseY);
        this.drawEnergy(matrixStack);
        this.drawFluid(matrixStack);
    }

    public void drawEnergy(MatrixStack matrixStack) {
        float perc = this.getEnergy();
        int texX = 176;
        int texY = 17;
        int texW = 16;
        int texH = 57;
        int targetX = 122;
        int targetY = 8;
        int scHeight = (int)((float)texH * (1.0f - perc));
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.func_238474_b_(matrixStack, i + targetX, j + targetY + scHeight, texX, texY + scHeight, texW, texH - scHeight);
    }

    public void drawFluid(MatrixStack matrixStack) {
        float perc = this.getFluid();
        int texX = 192;
        int texY = 17;
        int texW = 16;
        int texH = 57;
        int targetX = 39;
        int targetY = 8;
        int scHeight = (int)((float)texH * (1.0f - perc));
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.func_238474_b_(matrixStack, i + targetX, j + targetY + scHeight, texX, texY + scHeight, texW, texH - scHeight);
    }

    public float getEnergy() {
        return (float)this.tile.getStoredEnergy() / (float)this.tile.maxStorage;
    }

    public float getFluid() {
        return (float)this.tile.getCurrentMillibuckets() / (float)this.tile.maxMillibuckets;
    }
}

