/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.sounds;

import de.maxhenkel.car.corelib.reflection.ReflectionUtils;
import de.maxhenkel.tools.NoRegister;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.TickableSound;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ModSounds {
    public static SoundEvent ENGINE_STOP = ModSounds.addSound("engine_stop");
    public static SoundEvent ENGINE_STARTING = ModSounds.addSound("engine_starting");
    public static SoundEvent ENGINE_START = ModSounds.addSound("engine_start");
    public static SoundEvent ENGINE_IDLE = ModSounds.addSound("engine_idle");
    public static SoundEvent ENGINE_HIGH = ModSounds.addSound("engine_high");
    public static SoundEvent ENGINE_FAIL = ModSounds.addSound("engine_fail");
    public static SoundEvent SPORT_ENGINE_STOP = ModSounds.addSound("sport_engine_stop");
    public static SoundEvent SPORT_ENGINE_STARTING = ModSounds.addSound("sport_engine_starting");
    public static SoundEvent SPORT_ENGINE_START = ModSounds.addSound("sport_engine_start");
    public static SoundEvent SPORT_ENGINE_IDLE = ModSounds.addSound("sport_engine_idle");
    public static SoundEvent SPORT_ENGINE_HIGH = ModSounds.addSound("sport_engine_high");
    public static SoundEvent SPORT_ENGINE_FAIL = ModSounds.addSound("sport_engine_fail");
    public static SoundEvent TRUCK_ENGINE_STOP = ModSounds.addSound("truck_engine_stop");
    public static SoundEvent TRUCK_ENGINE_STARTING = ModSounds.addSound("truck_engine_starting");
    public static SoundEvent TRUCK_ENGINE_START = ModSounds.addSound("truck_engine_start");
    public static SoundEvent TRUCK_ENGINE_IDLE = ModSounds.addSound("truck_engine_idle");
    public static SoundEvent TRUCK_ENGINE_HIGH = ModSounds.addSound("truck_engine_high");
    public static SoundEvent TRUCK_ENGINE_FAIL = ModSounds.addSound("truck_engine_fail");
    public static SoundEvent CAR_CRASH = ModSounds.addSound("car_crash");
    public static SoundEvent GAS_STATION = ModSounds.addSound("gas_station");
    public static SoundEvent GENERATOR = ModSounds.addSound("generator");
    public static SoundEvent CAR_HORN = ModSounds.addSound("car_horn");
    public static SoundEvent CAR_LOCK = ModSounds.addSound("car_lock");
    public static SoundEvent CAR_UNLOCK = ModSounds.addSound("car_unlock");
    public static SoundEvent RATCHET = ModSounds.addSound("ratchet");
    public static SoundEvent GAS_STATION_ATTENDANT = ModSounds.addSound("gas_station_attendant");

    public static List<SoundEvent> getAll() {
        ArrayList<SoundEvent> sounds = new ArrayList<SoundEvent>();
        for (Field field : ModSounds.class.getFields()) {
            if (ReflectionUtils.hasAnnotation(field, NoRegister.class)) continue;
            try {
                Object obj = field.get(null);
                if (!(obj instanceof SoundEvent)) continue;
                sounds.add((SoundEvent)obj);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return sounds;
    }

    public static SoundEvent addSound(String soundName) {
        SoundEvent event = new SoundEvent(new ResourceLocation("car", soundName));
        event.setRegistryName(new ResourceLocation("car", soundName));
        return event;
    }

    public static void playSound(SoundEvent evt, World world, BlockPos pos, PlayerEntity entity, SoundCategory category, float volume) {
        ModSounds.playSound(evt, world, pos, entity, category, volume, 1.0f);
    }

    public static void playSound(SoundEvent evt, World world, BlockPos pos, PlayerEntity entity, SoundCategory category, float volume, float pitch) {
        if (entity != null) {
            world.func_184133_a(entity, pos, evt, category, volume, pitch);
        } else if (!world.field_72995_K) {
            world.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, evt, category, volume, pitch);
        }
    }

    public static void playSound(SoundEvent evt, World world, BlockPos pos, PlayerEntity entity, SoundCategory category) {
        ModSounds.playSound(evt, world, pos, entity, category, 0.15f);
    }

    public static boolean isCarSoundCategory(SoundEvent event) {
        if (event == null) {
            return false;
        }
        return event.equals(ENGINE_STOP) || event.equals(ENGINE_STARTING) || event.equals(ENGINE_START) || event.equals(ENGINE_IDLE) || event.equals(ENGINE_HIGH) || event.equals(ENGINE_FAIL) || event.equals(SPORT_ENGINE_STOP) || event.equals(SPORT_ENGINE_STARTING) || event.equals(SPORT_ENGINE_START) || event.equals(SPORT_ENGINE_IDLE) || event.equals(SPORT_ENGINE_HIGH) || event.equals(SPORT_ENGINE_FAIL) || event.equals(TRUCK_ENGINE_STOP) || event.equals(TRUCK_ENGINE_STARTING) || event.equals(TRUCK_ENGINE_START) || event.equals(TRUCK_ENGINE_IDLE) || event.equals(TRUCK_ENGINE_HIGH) || event.equals(TRUCK_ENGINE_FAIL) || event.equals(CAR_CRASH) || event.equals(CAR_HORN) || event.equals(CAR_LOCK) || event.equals(CAR_UNLOCK);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playSoundLoop(TickableSound loop, World world) {
        if (world.field_72995_K) {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)loop);
        }
    }
}

