/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.client.event;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModList;
import tschipp.carryon.CarryOn;
import tschipp.carryon.client.helper.CarryRenderHelper;
import tschipp.carryon.client.keybinds.CarryOnKeybinds;
import tschipp.carryon.common.config.Configs;
import tschipp.carryon.common.handler.ModelOverridesHandler;
import tschipp.carryon.common.handler.RegistrationHandler;
import tschipp.carryon.common.helper.KeyboardCallbackWrapper;
import tschipp.carryon.common.helper.ScriptParseHelper;
import tschipp.carryon.common.helper.ScrollCallbackWrapper;
import tschipp.carryon.common.helper.StringParser;
import tschipp.carryon.common.item.ItemCarryonBlock;
import tschipp.carryon.common.item.ItemCarryonEntity;
import tschipp.carryon.common.scripting.CarryOnOverride;
import tschipp.carryon.common.scripting.ScriptChecker;
import tschipp.carryon.network.server.SyncKeybindPacket;

public class RenderEvents {
    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onScroll(ScrollCallbackWrapper.MouseScrolledEvent event) {
        ItemStack stack;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (!(player == null || (stack = player.func_184614_ca()).func_190926_b() || stack.func_77973_b() != RegistrationHandler.itemTile && stack.func_77973_b() != RegistrationHandler.itemEntity || !ItemCarryonBlock.hasTileData(stack) && !ItemCarryonEntity.hasEntityData(stack))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onPlayerTick(TickEvent.PlayerTickEvent event) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        PlayerEntity player = event.player;
        if (player != null && event.side == LogicalSide.CLIENT) {
            boolean keyPressed = CarryOnKeybinds.carryKey.func_151470_d();
            boolean playerKeyPressed = CarryOnKeybinds.isKeyPressed(player);
            if (keyPressed && !playerKeyPressed) {
                CarryOnKeybinds.setKeyPressed(player, true);
                CarryOn.network.sendToServer((Object)new SyncKeybindPacket(true));
            } else if (!keyPressed && playerKeyPressed) {
                CarryOnKeybinds.setKeyPressed(player, false);
                CarryOn.network.sendToServer((Object)new SyncKeybindPacket(false));
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntity();
            if (player.field_70170_p.field_72995_K) {
                CarryOnKeybinds.setKeyPressed(player, false);
                CarryOn.network.sendToServer((Object)new SyncKeybindPacket(false));
                if (CarryOn.FINGERPRINT_VIOLATED) {
                    StringTextComponent cf = new StringTextComponent(TextFormatting.AQUA + "Curseforge" + TextFormatting.RED);
                    cf.func_150256_b().func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://minecraft.curseforge.com/projects/carry-on"));
                    player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.RED + "[CarryOn] WARNING! Invalid fingerprint detected! The Carry On mod file may have been tampered with! If you didn't download the file from ").func_230529_a_((ITextComponent)cf).func_240702_b_(TextFormatting.RED + " or through any kind of mod launcher, immediately delete the file and re-download it from ").func_230529_a_((ITextComponent)cf), false);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onGuiInit(GuiScreenEvent.InitGuiEvent.Pre event) {
        if (event.getGui() != null) {
            ItemStack stack;
            boolean inventory = event.getGui() instanceof ContainerScreen;
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player != null && inventory && !(stack = player.func_184586_b(Hand.MAIN_HAND)).func_190926_b() && (stack.func_77973_b() == RegistrationHandler.itemTile && ItemCarryonBlock.hasTileData(stack) || stack.func_77973_b() == RegistrationHandler.itemEntity && ItemCarryonEntity.hasEntityData(stack))) {
                Minecraft.func_71410_x().field_71439_g.func_71053_j();
                Minecraft.func_71410_x().field_71462_r = null;
                Minecraft.func_71410_x().field_71417_B.func_198034_i();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void inputEvent(KeyboardCallbackWrapper.KeyPressedEvent event) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        GameSettings settings = Minecraft.func_71410_x().field_71474_y;
        int key = event.key;
        int scancode = event.scancode;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            ItemStack stack = Minecraft.func_71410_x().field_71439_g.func_184614_ca();
            if (!stack.func_190926_b() && (stack.func_77973_b() == RegistrationHandler.itemTile && ItemCarryonBlock.hasTileData(stack) || stack.func_77973_b() == RegistrationHandler.itemEntity && ItemCarryonEntity.hasEntityData(stack))) {
                if (settings.field_74316_C.func_197976_a(key, scancode)) {
                    event.setCanceled(true);
                }
                if (settings.field_186718_X.func_197976_a(key, scancode)) {
                    event.setCanceled(true);
                }
                if (settings.field_74322_I.func_197976_a(key, scancode)) {
                    event.setCanceled(true);
                }
                for (KeyBinding keyBind : settings.field_151456_ac) {
                    if (!keyBind.func_197976_a(key, scancode)) continue;
                    event.setCanceled(true);
                }
            }
            int current = player.field_71071_by.field_70461_c;
            if (player.getPersistentData().func_74764_b("carrySlot") && player.getPersistentData().func_74762_e("carrySlot") != current) {
                player.field_71071_by.field_70461_c = player.getPersistentData().func_74762_e("carrySlot");
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void renderHand(RenderHandEvent event) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        ItemStack stack = player.func_184614_ca();
        int perspective = CarryRenderHelper.getPerspective();
        boolean f1 = Minecraft.func_71410_x().field_71474_y.field_74319_N;
        IRenderTypeBuffer buffer = event.getBuffers();
        MatrixStack matrix = event.getMatrixStack();
        int light = event.getLight();
        if (!stack.func_190926_b() && stack.func_77973_b() == RegistrationHandler.itemTile && ItemCarryonBlock.hasTileData(stack) && perspective == 0 && !f1) {
            if (ModList.get().isLoaded("realrender") || ModList.get().isLoaded("rfpr")) {
                return;
            }
            Block block = ItemCarryonBlock.getBlock(stack);
            CompoundNBT tag = ItemCarryonBlock.getTileData(stack);
            BlockState state = ItemCarryonBlock.getBlockState(stack);
            ItemStack tileStack = ItemCarryonBlock.getItemStack(stack);
            matrix.func_227860_a_();
            matrix.func_227862_a_(2.5f, 2.5f, 2.5f);
            matrix.func_227861_a_(0.0, -0.5, -1.0);
            RenderSystem.enableBlend();
            RenderSystem.disableCull();
            if ((Boolean)Configs.Settings.facePlayer.get() != false ? !RenderEvents.isChest(block) : RenderEvents.isChest(block)) {
                matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                matrix.func_227863_a_(Vector3f.field_229178_a_.func_229187_a_(8.0f));
            } else {
                matrix.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(8.0f));
            }
            IBakedModel model = ModelOverridesHandler.hasCustomOverrideModel(state, tag) ? ModelOverridesHandler.getCustomOverrideModel(state, tag, (World)world, (PlayerEntity)player) : (tileStack.func_190926_b() ? Minecraft.func_71410_x().func_175602_ab().func_184389_a(state) : Minecraft.func_71410_x().func_175599_af().func_184393_a(tileStack, (World)world, (LivingEntity)player));
            CarryOnOverride carryOverride = ScriptChecker.getOverride((PlayerEntity)player);
            if (carryOverride != null) {
                Block b;
                CarryRenderHelper.performOverrideTransformation(matrix, carryOverride);
                if (!carryOverride.getRenderNameBlock().isEmpty() && (b = StringParser.getBlock(carryOverride.getRenderNameBlock())) != null) {
                    ItemStack s = new ItemStack((IItemProvider)b, 1);
                    s.func_77982_d(carryOverride.getRenderNBT());
                    model = Minecraft.func_71410_x().func_175599_af().func_184393_a(s, (World)world, (LivingEntity)player);
                }
            }
            Minecraft.func_71410_x().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
            CarryRenderHelper.renderItem(state, tag, stack, tileStack, matrix, buffer, light, model);
            if (perspective == 0) {
                event.setCanceled(true);
            }
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
            matrix.func_227865_b_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onRenderWorld(RenderWorldLastEvent event) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        float partialticks = event.getPartialTicks();
        IRenderTypeBuffer.Impl buffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        MatrixStack matrix = event.getMatrixStack();
        int light = 0;
        int perspective = CarryRenderHelper.getPerspective();
        EntityRendererManager manager = Minecraft.func_71410_x().func_175598_ae();
        RenderSystem.enableBlend();
        RenderSystem.disableCull();
        RenderSystem.disableDepthTest();
        for (PlayerEntity player : world.func_217369_A()) {
            Entity entity;
            if (perspective == 0 && player == Minecraft.func_71410_x().field_71439_g) continue;
            light = Minecraft.func_71410_x().func_175598_ae().func_229085_a_((Entity)player, partialticks);
            ItemStack stack = player.func_184614_ca();
            if (!stack.func_190926_b() && stack.func_77973_b() == RegistrationHandler.itemTile && ItemCarryonBlock.hasTileData(stack)) {
                Block block = ItemCarryonBlock.getBlock(stack);
                BlockState state = ItemCarryonBlock.getBlockState(stack);
                CompoundNBT tag = ItemCarryonBlock.getTileData(stack);
                ItemStack tileItem = ItemCarryonBlock.getItemStack(stack);
                this.applyBlockTransformations(player, partialticks, matrix, block);
                IBakedModel model = ModelOverridesHandler.hasCustomOverrideModel(state, tag) ? ModelOverridesHandler.getCustomOverrideModel(state, tag, (World)world, player) : (tileItem.func_190926_b() ? Minecraft.func_71410_x().func_175602_ab().func_184389_a(state) : Minecraft.func_71410_x().func_175599_af().func_184393_a(tileItem, (World)world, (LivingEntity)player));
                CarryOnOverride carryOverride = ScriptChecker.getOverride(player);
                if (carryOverride != null) {
                    Block b;
                    CarryRenderHelper.performOverrideTransformation(matrix, carryOverride);
                    if (!carryOverride.getRenderNameBlock().isEmpty() && (b = StringParser.getBlock(carryOverride.getRenderNameBlock())) != null) {
                        ItemStack s = new ItemStack((IItemProvider)b, 1);
                        s.func_77982_d(carryOverride.getRenderNBT());
                        model = Minecraft.func_71410_x().func_175599_af().func_184393_a(s, (World)world, (LivingEntity)player);
                    }
                }
                Minecraft.func_71410_x().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
                CarryRenderHelper.renderItem(state, tag, stack, tileItem, matrix, (IRenderTypeBuffer)buffer, light, model);
                buffer.func_228461_a_();
                matrix.func_227865_b_();
                this.drawArms(player, partialticks, matrix, (IRenderTypeBuffer)buffer, light);
                matrix.func_227865_b_();
                continue;
            }
            if (stack.func_190926_b() || stack.func_77973_b() != RegistrationHandler.itemEntity || !ItemCarryonEntity.hasEntityData(stack) || (entity = ItemCarryonEntity.getEntity(stack, (World)world)) == null) continue;
            this.applyEntityTransformations(player, partialticks, matrix, entity);
            manager.func_178633_a(false);
            CarryOnOverride carryOverride = ScriptChecker.getOverride(player);
            if (carryOverride != null) {
                CarryRenderHelper.performOverrideTransformation(matrix, carryOverride);
                String entityname = carryOverride.getRenderNameEntity();
                if (entityname != null) {
                    Entity newEntity = null;
                    Optional type = EntityType.func_220327_a((String)entityname);
                    if (type.isPresent()) {
                        newEntity = ((EntityType)type.get()).func_200721_a((World)world);
                    }
                    if (newEntity != null) {
                        CompoundNBT nbttag = carryOverride.getRenderNBT();
                        if (nbttag != null) {
                            newEntity.deserializeNBT(nbttag);
                        }
                        entity = newEntity;
                        entity.field_70177_z = 0.0f;
                        entity.field_70126_B = 0.0f;
                        entity.func_70034_d(0.0f);
                        entity.field_70125_A = 0.0f;
                        entity.field_70127_C = 0.0f;
                    }
                }
            }
            if (entity instanceof LivingEntity) {
                ((LivingEntity)entity).field_70737_aN = 0;
            }
            manager.func_229084_a_(entity, 0.0, 0.0, 0.0, 0.0f, 0.0f, matrix, (IRenderTypeBuffer)buffer, light);
            buffer.func_228461_a_();
            matrix.func_227865_b_();
            this.drawArms(player, partialticks, matrix, (IRenderTypeBuffer)buffer, light);
            manager.func_178633_a(true);
            matrix.func_227865_b_();
        }
        RenderSystem.enableDepthTest();
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
    }

    private void applyGeneralTransformations(PlayerEntity player, float partialticks, MatrixStack matrix) {
        int perspective = CarryRenderHelper.getPerspective();
        Quaternion playerrot = CarryRenderHelper.getExactBodyRotation((LivingEntity)player, partialticks);
        Vector3d playerpos = CarryRenderHelper.getExactPos((Entity)player, partialticks);
        Vector3d cameraPos = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
        Vector3d offset = playerpos.func_178788_d(cameraPos);
        Pose pose = player.func_213283_Z();
        matrix.func_227860_a_();
        matrix.func_227861_a_(offset.field_72450_a, offset.field_72448_b, offset.field_72449_c);
        if (perspective == 2) {
            playerrot.func_195890_a(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        }
        matrix.func_227863_a_(playerrot);
        matrix.func_227860_a_();
        matrix.func_227862_a_(0.6f, 0.6f, 0.6f);
        if (perspective == 2) {
            matrix.func_227861_a_(0.0, 0.0, -1.35);
        }
        if (RenderEvents.doSneakCheck(player)) {
            matrix.func_227861_a_(0.0, -0.4, 0.0);
        }
        if (pose == Pose.SWIMMING) {
            float f = player.func_205015_b(partialticks);
            float f3 = player.func_70090_H() ? -90.0f - player.field_70125_A : -90.0f;
            float f4 = MathHelper.func_219799_g((float)f, (float)0.0f, (float)f3);
            if (perspective == 2) {
                matrix.func_227861_a_(0.0, 0.0, 1.35);
                matrix.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(f4));
            } else {
                matrix.func_227863_a_(Vector3f.field_229178_a_.func_229187_a_(f4));
            }
            matrix.func_227861_a_(0.0, -1.5, -1.848);
            if (perspective == 2) {
                matrix.func_227861_a_(0.0, 0.0, 2.38);
            }
        }
        if (pose == Pose.FALL_FLYING) {
            float f1 = (float)player.func_184599_cB() + partialticks;
            float f2 = MathHelper.func_76131_a((float)(f1 * f1 / 100.0f), (float)0.0f, (float)1.0f);
            if (!player.func_204805_cN()) {
                if (perspective == 2) {
                    matrix.func_227861_a_(0.0, 0.0, 1.35);
                }
                if (perspective == 2) {
                    matrix.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(f2 * (-90.0f - player.field_70125_A)));
                } else {
                    matrix.func_227863_a_(Vector3f.field_229178_a_.func_229187_a_(f2 * (-90.0f - player.field_70125_A)));
                }
            }
            Vector3d Vector3d2 = player.func_70676_i(partialticks);
            Vector3d Vector3d1 = player.func_213322_ci();
            double d0 = Entity.func_213296_b((Vector3d)Vector3d1);
            double d1 = Entity.func_213296_b((Vector3d)Vector3d2);
            if (d0 > 0.0 && d1 > 0.0) {
                double d2 = (Vector3d1.field_72450_a * Vector3d2.field_72450_a + Vector3d1.field_72449_c * Vector3d2.field_72449_c) / (Math.sqrt(d0) * Math.sqrt(d1));
                double d3 = Vector3d1.field_72450_a * Vector3d2.field_72449_c - Vector3d1.field_72449_c * Vector3d2.field_72450_a;
                matrix.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_((float)(Math.signum(d3) * Math.acos(d2))));
            }
            if (perspective != 2) {
                matrix.func_227861_a_(0.0, 0.0, -1.35);
            }
            matrix.func_227861_a_(0.0, -0.2, 0.0);
        }
        matrix.func_227861_a_(0.0, 1.6, 0.65);
    }

    private void applyBlockTransformations(PlayerEntity player, float partialticks, MatrixStack matrix, Block block) {
        int perspective = CarryRenderHelper.getPerspective();
        this.applyGeneralTransformations(player, partialticks, matrix);
        if ((Boolean)Configs.Settings.facePlayer.get() != false ? !RenderEvents.isChest(block) : RenderEvents.isChest(block)) {
            if ((ModList.get().isLoaded("realrender") || ModList.get().isLoaded("rfpr")) && perspective == 0) {
                matrix.func_227861_a_(0.0, 0.0, -0.4);
            }
            matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        } else if ((ModList.get().isLoaded("realrender") || ModList.get().isLoaded("rfpr")) && perspective == 0) {
            matrix.func_227861_a_(0.0, 0.0, 0.4);
        }
    }

    private void applyEntityTransformations(PlayerEntity player, float partialticks, MatrixStack matrix, Entity entity) {
        int perspective = CarryRenderHelper.getPerspective();
        Pose pose = player.func_213283_Z();
        this.applyGeneralTransformations(player, partialticks, matrix);
        if (perspective == 2) {
            matrix.func_227861_a_(0.0, -1.6, 0.65);
        } else {
            matrix.func_227861_a_(0.0, -1.6, -0.65);
        }
        matrix.func_227862_a_(1.666f, 1.666f, 1.666f);
        float height = entity.func_213302_cg();
        float width = entity.func_213311_cf();
        float multiplier = height * width;
        entity.field_70177_z = 0.0f;
        entity.field_70126_B = 0.0f;
        entity.func_70034_d(0.0f);
        entity.field_70125_A = 0.0f;
        entity.field_70127_C = 0.0f;
        if (perspective == 2) {
            matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        }
        matrix.func_227862_a_((10.0f - multiplier) * 0.08f, (10.0f - multiplier) * 0.08f, (10.0f - multiplier) * 0.08f);
        matrix.func_227861_a_(0.0, (double)(height / 2.0f + -(height / 2.0f) + 1.0f), (double)width - 0.1 < 0.7 ? (double)width - 0.1 + (0.7 - ((double)width - 0.1)) : (double)width - 0.1);
        if (pose == Pose.SWIMMING || pose == Pose.FALL_FLYING) {
            matrix.func_227863_a_(Vector3f.field_229178_a_.func_229187_a_(90.0f));
            matrix.func_227861_a_(0.0, -0.2 * (double)height, 0.0);
            if (pose == Pose.FALL_FLYING) {
                matrix.func_227861_a_(0.0, 0.0, 0.2);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawArms(PlayerEntity player, float partialticks, MatrixStack matrix, IRenderTypeBuffer buffer, int light) {
        ItemStack stack;
        int perspective = CarryRenderHelper.getPerspective();
        Pose pose = player.func_213283_Z();
        if (!((Boolean)Configs.Settings.renderArms.get()).booleanValue()) {
            return;
        }
        if (pose == Pose.SWIMMING || pose == Pose.FALL_FLYING) {
            return;
        }
        if (this.handleMobends() && !ModList.get().isLoaded("obfuscate") && (!(stack = player.func_184614_ca()).func_190926_b() && stack.func_77973_b() == RegistrationHandler.itemTile && ItemCarryonBlock.hasTileData(stack) || stack.func_77973_b() == RegistrationHandler.itemEntity && ItemCarryonEntity.hasEntityData(stack))) {
            PlayerModel<AbstractClientPlayerEntity> model = RenderEvents.getPlayerModel((AbstractClientPlayerEntity)player);
            AbstractClientPlayerEntity aplayer = (AbstractClientPlayerEntity)player;
            ResourceLocation skinLoc = aplayer.func_110306_p();
            matrix.func_227860_a_();
            if (perspective == 2) {
                matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
            }
            Minecraft.func_71410_x().func_110434_K().func_110577_a(skinLoc);
            CarryOnOverride overrider = ScriptChecker.getOverride(player);
            IVertexBuilder builder = buffer.getBuffer(RenderType.func_228638_b_((ResourceLocation)skinLoc));
            if (overrider != null) {
                float[] rotLeft = null;
                float[] rotRight = null;
                if (!overrider.getRenderRotationLeftArm().isEmpty()) {
                    rotLeft = ScriptParseHelper.getXYZArray(overrider.getRenderRotationLeftArm());
                }
                if (!overrider.getRenderRotationRightArm().isEmpty()) {
                    rotRight = ScriptParseHelper.getXYZArray(overrider.getRenderRotationRightArm());
                }
                boolean renderRight = overrider.isRenderRightArm();
                boolean renderLeft = overrider.isRenderLeftArm();
                if (renderLeft && rotLeft != null) {
                    this.renderArmPost(model.field_178724_i, rotLeft[0], rotLeft[2], false, RenderEvents.doSneakCheck(player), light, matrix, builder);
                    this.renderArmPost(model.field_178734_a, rotLeft[0], rotLeft[2], false, RenderEvents.doSneakCheck(player), light, matrix, builder);
                } else if (renderLeft) {
                    this.renderArmPost(model.field_178724_i, 2.0f + (RenderEvents.doSneakCheck(player) ? 0.0f : 0.2f) - (stack.func_77973_b() == RegistrationHandler.itemEntity ? 0.3f : 0.0f), stack.func_77973_b() == RegistrationHandler.itemEntity ? 0.15f : 0.0f, false, RenderEvents.doSneakCheck(player), light, matrix, builder);
                    this.renderArmPost(model.field_178734_a, 2.0f + (RenderEvents.doSneakCheck(player) ? 0.0f : 0.2f) - (stack.func_77973_b() == RegistrationHandler.itemEntity ? 0.3f : 0.0f), stack.func_77973_b() == RegistrationHandler.itemEntity ? 0.15f : 0.0f, false, RenderEvents.doSneakCheck(player), light, matrix, builder);
                }
                if (renderRight && rotRight != null) {
                    this.renderArmPost(model.field_178723_h, rotRight[0], rotRight[2], true, RenderEvents.doSneakCheck(player), light, matrix, builder);
                    this.renderArmPost(model.field_178732_b, rotRight[0], rotRight[2], true, RenderEvents.doSneakCheck(player), light, matrix, builder);
                } else if (renderRight) {
                    this.renderArmPost(model.field_178723_h, 2.0f + (RenderEvents.doSneakCheck(player) ? 0.0f : 0.2f) - (stack.func_77973_b() == RegistrationHandler.itemEntity ? 0.3f : 0.0f), stack.func_77973_b() == RegistrationHandler.itemEntity ? -0.15f : 0.0f, true, RenderEvents.doSneakCheck(player), light, matrix, builder);
                    this.renderArmPost(model.field_178732_b, 2.0f + (RenderEvents.doSneakCheck(player) ? 0.0f : 0.2f) - (stack.func_77973_b() == RegistrationHandler.itemEntity ? 0.3f : 0.0f), stack.func_77973_b() == RegistrationHandler.itemEntity ? -0.15f : 0.0f, true, RenderEvents.doSneakCheck(player), light, matrix, builder);
                }
            } else {
                this.renderArmPost(model.field_178723_h, 2.0f + (RenderEvents.doSneakCheck(player) ? 0.0f : 0.2f) - (stack.func_77973_b() == RegistrationHandler.itemEntity ? 0.3f : 0.0f), stack.func_77973_b() == RegistrationHandler.itemEntity ? -0.15f : 0.0f, true, RenderEvents.doSneakCheck(player), light, matrix, builder);
                this.renderArmPost(model.field_178724_i, 2.0f + (RenderEvents.doSneakCheck(player) ? 0.0f : 0.2f) - (stack.func_77973_b() == RegistrationHandler.itemEntity ? 0.3f : 0.0f), stack.func_77973_b() == RegistrationHandler.itemEntity ? 0.15f : 0.0f, false, RenderEvents.doSneakCheck(player), light, matrix, builder);
                this.renderArmPost(model.field_178734_a, 2.0f + (RenderEvents.doSneakCheck(player) ? 0.0f : 0.2f) - (stack.func_77973_b() == RegistrationHandler.itemEntity ? 0.3f : 0.0f), stack.func_77973_b() == RegistrationHandler.itemEntity ? 0.15f : 0.0f, false, RenderEvents.doSneakCheck(player), light, matrix, builder);
                this.renderArmPost(model.field_178732_b, 2.0f + (RenderEvents.doSneakCheck(player) ? 0.0f : 0.2f) - (stack.func_77973_b() == RegistrationHandler.itemEntity ? 0.3f : 0.0f), stack.func_77973_b() == RegistrationHandler.itemEntity ? -0.15f : 0.0f, true, RenderEvents.doSneakCheck(player), light, matrix, builder);
            }
            if (buffer instanceof IRenderTypeBuffer.Impl) {
                ((IRenderTypeBuffer.Impl)buffer).func_228461_a_();
            }
            matrix.func_227865_b_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onEvent(RenderPlayerEvent.Pre event) {
        if (!((Boolean)Configs.Settings.renderArms.get()).booleanValue()) {
            return;
        }
        if (this.handleMobends() && !ModList.get().isLoaded("obfuscate")) {
            PlayerEntity player = event.getPlayer();
            Pose pose = player.func_213283_Z();
            ItemStack stack = player.func_184614_ca();
            if (pose != Pose.SWIMMING && pose != Pose.FALL_FLYING && !stack.func_190926_b() && (stack.func_77973_b() == RegistrationHandler.itemTile && ItemCarryonBlock.hasTileData(stack) || stack.func_77973_b() == RegistrationHandler.itemEntity && ItemCarryonEntity.hasEntityData(stack))) {
                PlayerModel model = (PlayerModel)event.getRenderer().func_217764_d();
                CarryOnOverride overrider = ScriptChecker.getOverride(player);
                if (overrider != null) {
                    boolean renderRight = overrider.isRenderRightArm();
                    boolean renderLeft = overrider.isRenderLeftArm();
                    if (renderRight) {
                        this.renderArmPre(model.field_178723_h);
                        this.renderArmPre(model.field_178732_b);
                    }
                    if (renderLeft) {
                        this.renderArmPre(model.field_178724_i);
                        this.renderArmPre(model.field_178734_a);
                    }
                } else {
                    this.renderArmPre(model.field_178723_h);
                    this.renderArmPre(model.field_178724_i);
                    this.renderArmPre(model.field_178734_a);
                    this.renderArmPre(model.field_178732_b);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderArmPost(ModelRenderer arm, float x, float z, boolean right, boolean sneaking, int light, MatrixStack matrix, IVertexBuilder builder) {
        matrix.func_227860_a_();
        arm.field_78806_j = true;
        if (right) {
            matrix.func_227861_a_(0.015, 0.0, 0.0);
        } else {
            matrix.func_227861_a_(-0.015, 0.0, 0.0);
        }
        arm.field_78797_d = !sneaking ? 20.0f : 15.0f;
        arm.field_78795_f = x;
        arm.field_78796_g = 0.0f;
        arm.field_78808_h = -z;
        arm.func_228308_a_(matrix, builder, light, 655360);
        arm.field_78797_d = 2.0f;
        matrix.func_227865_b_();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderArmPre(ModelRenderer arm) {
        arm.field_78806_j = false;
    }

    public boolean handleMobends() {
        return true;
    }

    public static boolean doSneakCheck(PlayerEntity player) {
        if (player.field_71075_bZ.field_75100_b) {
            return false;
        }
        return player.func_225608_bj_() || player.func_213453_ef();
    }

    public static boolean isChest(Block block) {
        return block == Blocks.field_150486_ae || block == Blocks.field_150477_bB || block == Blocks.field_150447_bR;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static PlayerRenderer getRenderPlayer(AbstractClientPlayerEntity player) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityRendererManager manager = mc.func_175598_ae();
        return (PlayerRenderer)manager.getSkinMap().get(player.func_175154_l());
    }

    @OnlyIn(value=Dist.CLIENT)
    private static PlayerModel<AbstractClientPlayerEntity> getPlayerModel(AbstractClientPlayerEntity player) {
        return (PlayerModel)RenderEvents.getRenderPlayer(player).func_217764_d();
    }
}

