/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.handler;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import tschipp.carryon.common.config.Configs;
import tschipp.carryon.common.handler.CustomPickupOverrideHandler;
import tschipp.carryon.common.handler.ListHandler;
import tschipp.carryon.common.helper.CarryonGamestageHelper;
import tschipp.carryon.common.item.ItemCarryonBlock;
import tschipp.carryon.common.scripting.CarryOnOverride;
import tschipp.carryon.common.scripting.ScriptChecker;

public class PickupHandler {
    public static boolean canPlayerPickUpBlock(ServerPlayerEntity player, @Nullable TileEntity tile, World world, BlockPos pos) {
        double maxDist;
        double distance;
        CarryOnOverride override;
        if (player.field_71134_c.func_73081_b() == GameType.SPECTATOR || player.field_71134_c.func_73081_b() == GameType.ADVENTURE) {
            return false;
        }
        BlockState state = world.func_180495_p(pos);
        CompoundNBT tag = new CompoundNBT();
        if (tile != null) {
            tile.func_189515_b(tag);
        }
        if ((override = ScriptChecker.inspectBlock(world.func_180495_p(pos), world, pos, tag)) != null) {
            return ScriptChecker.fulfillsConditions(override, (PlayerEntity)player) && PickupHandler.handleProtections(player, world, pos, state);
        }
        if ((Boolean)Configs.Settings.useWhitelistBlocks.get() != false ? !ListHandler.isAllowed(world.func_180495_p(pos).func_177230_c()) : ListHandler.isForbidden(world.func_180495_p(pos).func_177230_c())) {
            return false;
        }
        if ((state.func_185887_b((IBlockReader)world, pos) != -1.0f || player.func_184812_l_()) && (distance = Vector3d.func_237491_b_((Vector3i)pos).func_72438_d(player.func_213303_ch())) < (maxDist = ((Double)Configs.Settings.maxDistance.get()).doubleValue()) && !ItemCarryonBlock.isLocked(pos, world)) {
            if (CustomPickupOverrideHandler.hasSpecialPickupConditions(state)) {
                return CarryonGamestageHelper.hasGamestage(CustomPickupOverrideHandler.getPickupCondition(state), (PlayerEntity)player) && PickupHandler.handleProtections(player, world, pos, state);
            }
            if (((Boolean)Configs.Settings.pickupAllBlocks.get()).booleanValue() || tile != null) {
                return PickupHandler.handleProtections(player, world, pos, state);
            }
        }
        return false;
    }

    public static boolean canPlayerPickUpEntity(ServerPlayerEntity player, Entity toPickUp) {
        double distance;
        AgeableEntity living;
        if (player.field_71134_c.func_73081_b() == GameType.SPECTATOR || player.field_71134_c.func_73081_b() == GameType.ADVENTURE) {
            return false;
        }
        BlockPos pos = toPickUp.func_233580_cy_();
        if (toPickUp instanceof PlayerEntity) {
            return false;
        }
        CarryOnOverride override = ScriptChecker.inspectEntity(toPickUp);
        if (override != null) {
            return ScriptChecker.fulfillsConditions(override, (PlayerEntity)player) && PickupHandler.handleProtections(player, toPickUp);
        }
        if (toPickUp instanceof AgeableEntity && ((Boolean)Configs.Settings.allowBabies.get()).booleanValue() && ((living = (AgeableEntity)toPickUp).func_70874_b() < 0 || living.func_70631_g_())) {
            TameableEntity tame;
            double distance2 = pos.func_177951_i((Vector3i)player.func_233580_cy_());
            if (distance2 < Math.pow((Double)Configs.Settings.maxDistance.get(), 2.0) && toPickUp instanceof TameableEntity && (tame = (TameableEntity)toPickUp).func_184753_b() != null && tame.func_184753_b() != PlayerEntity.func_146094_a((GameProfile)player.func_146103_bH())) {
                return false;
            }
            if (CustomPickupOverrideHandler.hasSpecialPickupConditions(toPickUp)) {
                return CarryonGamestageHelper.hasGamestage(CustomPickupOverrideHandler.getPickupCondition(toPickUp), (PlayerEntity)player) && PickupHandler.handleProtections(player, toPickUp);
            }
            return PickupHandler.handleProtections(player, toPickUp);
        }
        if ((Boolean)Configs.Settings.useWhitelistEntities.get() != false ? !ListHandler.isAllowed(toPickUp) : ListHandler.isForbidden(toPickUp)) {
            return false;
        }
        if ((((Boolean)Configs.Settings.pickupHostileMobs.get()).booleanValue() || toPickUp.func_200600_R().func_220339_d() != EntityClassification.MONSTER || player.func_184812_l_()) && (((Boolean)Configs.Settings.pickupHostileMobs.get()).booleanValue() || toPickUp.func_200600_R().func_220339_d() != EntityClassification.MONSTER || player.func_184812_l_()) && ((double)toPickUp.func_213302_cg() <= (Double)Configs.Settings.maxEntityHeight.get() && (double)toPickUp.func_213311_cf() <= (Double)Configs.Settings.maxEntityWidth.get() || player.func_184812_l_()) && (distance = pos.func_177951_i((Vector3i)player.func_233580_cy_())) < Math.pow((Double)Configs.Settings.maxDistance.get(), 2.0)) {
            if (toPickUp instanceof TameableEntity) {
                TameableEntity tame = (TameableEntity)toPickUp;
                UUID owner = tame.func_184753_b();
                UUID playerID = PlayerEntity.func_146094_a((GameProfile)player.func_146103_bH());
                if (owner != null && !owner.equals(playerID)) {
                    return false;
                }
            }
            if (CustomPickupOverrideHandler.hasSpecialPickupConditions(toPickUp)) {
                return CarryonGamestageHelper.hasGamestage(CustomPickupOverrideHandler.getPickupCondition(toPickUp), (PlayerEntity)player) && PickupHandler.handleProtections(player, toPickUp);
            }
            return PickupHandler.handleProtections(player, toPickUp);
        }
        return false;
    }

    private static boolean handleProtections(ServerPlayerEntity player, World world, BlockPos pos, BlockState state) {
        boolean breakable = true;
        PickUpBlockEvent event = new PickUpBlockEvent(world, pos, state, (PlayerEntity)player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            breakable = false;
        }
        return breakable;
    }

    private static boolean handleProtections(ServerPlayerEntity player, Entity entity) {
        boolean canPickup = true;
        PickUpEntityEvent event = new PickUpEntityEvent((PlayerEntity)player, entity);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            canPickup = false;
        }
        return canPickup;
    }

    public static class PickUpEntityEvent
    extends AttackEntityEvent {
        public PickUpEntityEvent(PlayerEntity player, Entity target) {
            super(player, target);
        }
    }

    public static class PickUpBlockEvent
    extends BlockEvent.BreakEvent {
        public PickUpBlockEvent(World world, BlockPos pos, BlockState state, PlayerEntity player) {
            super(world, pos, state, player);
        }
    }
}

