/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.item;

import com.google.common.base.CharMatcher;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModList;
import tschipp.carryon.CarryOn;
import tschipp.carryon.client.keybinds.CarryOnKeybinds;
import tschipp.carryon.common.config.Configs;
import tschipp.carryon.common.event.ItemEvents;
import tschipp.carryon.common.handler.CustomPickupOverrideHandler;
import tschipp.carryon.common.handler.ModelOverridesHandler;

public class ItemCarryonBlock
extends Item {
    public static final String TILE_DATA_KEY = "tileData";
    public static final String[] FACING_KEYS = new String[]{"rotation", "rot", "facing", "face", "direction", "dir", "front", "forward"};

    public ItemCarryonBlock() {
        super(new Item.Properties().func_200917_a(1));
        this.setRegistryName("carryon", "tile_item");
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        if (ItemCarryonBlock.hasTileData(stack)) {
            CompoundNBT nbt;
            BlockState state = ItemCarryonBlock.getBlockState(stack);
            if (ModelOverridesHandler.hasCustomOverrideModel(state, nbt = ItemCarryonBlock.getTileData(stack))) {
                Object override = ModelOverridesHandler.getOverrideObject(state, nbt);
                if (override instanceof ItemStack) {
                    return ((ItemStack)override).func_200301_q();
                }
                BlockState ostate = (BlockState)override;
                return ostate.func_177230_c().func_235333_g_();
            }
            return ItemCarryonBlock.getItemStack(stack).func_200301_q();
        }
        return new StringTextComponent("");
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        block18: {
            Direction facing = context.func_196000_l();
            PlayerEntity player = context.func_195999_j();
            World world = context.func_195991_k();
            BlockPos pos = context.func_195995_a();
            ItemStack stack = context.func_195996_i();
            if (ModList.get().isLoaded("betterplacement") && CarryOnKeybinds.isKeyPressed(player)) {
                return ActionResultType.FAIL;
            }
            if (ItemCarryonBlock.hasTileData(stack)) {
                try {
                    boolean canPlace;
                    Vector3d vec = player.func_70040_Z();
                    Direction facing2 = Direction.func_176737_a((float)((float)vec.field_72450_a), (float)0.0f, (float)((float)vec.field_72449_c));
                    BlockPos pos2 = pos;
                    Block containedblock = ItemCarryonBlock.getBlock(stack);
                    BlockState containedstate = ItemCarryonBlock.getBlockState(stack);
                    if (!world.func_180495_p(pos2).func_196953_a(new BlockItemUseContext(context))) {
                        pos2 = pos.func_177972_a(facing);
                    }
                    if (world.func_180495_p(pos2).func_196953_a(new BlockItemUseContext(context)) && containedblock != null && (canPlace = containedstate.func_196955_c((IWorldReader)world, pos2)) && player.func_175151_a(pos, facing, stack) && world.func_175660_a(player, pos2)) {
                        BlockState placementState = containedblock.func_196258_a(new BlockItemUseContext(context));
                        BlockState actualState = placementState == null ? containedstate : placementState;
                        BlockSnapshot snapshot = BlockSnapshot.create((RegistryKey)world.func_234923_W_(), (IWorld)world, (BlockPos)pos2);
                        BlockEvent.EntityPlaceEvent event = new BlockEvent.EntityPlaceEvent(snapshot, world.func_180495_p(pos), (Entity)player);
                        MinecraftForge.EVENT_BUS.post((Event)event);
                        if (!event.isCanceled()) {
                            TileEntity tile;
                            world.func_175656_a(pos2, actualState);
                            if (!ItemCarryonBlock.getTileData(stack).isEmpty()) {
                                CompoundNBT tag = ItemCarryonBlock.getTileData(stack);
                                Set keys = tag.func_150296_c();
                                block7: for (String key : keys) {
                                    for (String facingKey : FACING_KEYS) {
                                        if (!key.toLowerCase().equals(facingKey)) continue;
                                        byte type = tag.func_150299_b(key);
                                        switch (type) {
                                            case 8: {
                                                tag.func_74778_a(key, CharMatcher.javaUpperCase().matchesAllOf((CharSequence)tag.func_74779_i(key)) ? facing2.func_176734_d().func_176742_j().toUpperCase() : facing2.func_176734_d().func_176742_j());
                                                break;
                                            }
                                            case 3: {
                                                tag.func_74768_a(key, facing2.func_176734_d().func_176745_a());
                                                break;
                                            }
                                            case 1: {
                                                tag.func_74774_a(key, (byte)facing2.func_176734_d().func_176745_a());
                                                break;
                                            }
                                        }
                                        break block7;
                                    }
                                }
                            }
                            if ((tile = world.func_175625_s(pos2)) != null) {
                                CompoundNBT data = ItemCarryonBlock.getTileData(stack);
                                ItemCarryonBlock.updateTileLocation(data, pos2);
                                tile.func_230337_a_(actualState, data);
                            }
                            ItemCarryonBlock.clearTileData(stack);
                            player.func_184185_a(actualState.getSoundType((IWorldReader)world, pos2, (Entity)player).func_185841_e(), 1.0f, 0.5f);
                            player.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
                            player.getPersistentData().func_82580_o("overrideKey");
                            ItemEvents.sendPacket(player, 9, 0);
                            return ActionResultType.SUCCESS;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (world == null || !world.field_72995_K) break block18;
                    CarryOn.LOGGER.info("Block: " + ItemCarryonBlock.getBlock(stack));
                    CarryOn.LOGGER.info("BlockState: " + ItemCarryonBlock.getBlockState(stack));
                    CarryOn.LOGGER.info("ItemStack: " + ItemCarryonBlock.getItemStack(stack));
                    if (ModelOverridesHandler.hasCustomOverrideModel(ItemCarryonBlock.getBlockState(stack), ItemCarryonBlock.getTileData(stack))) {
                        CarryOn.LOGGER.info("Override Model: " + ModelOverridesHandler.getOverrideObject(ItemCarryonBlock.getBlockState(stack), ItemCarryonBlock.getTileData(stack)));
                    }
                    if (CustomPickupOverrideHandler.hasSpecialPickupConditions(ItemCarryonBlock.getBlockState(stack))) {
                        CarryOn.LOGGER.info("Custom Pickup Condition: " + CustomPickupOverrideHandler.getPickupCondition(ItemCarryonBlock.getBlockState(stack)));
                    }
                    player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.RED + "Error detected. Cannot place block. Execute \"/carryon clear\" to remove the item"), false);
                    StringTextComponent s = new StringTextComponent(TextFormatting.GOLD + "here");
                    s.func_150256_b().func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://github.com/Tschipp/CarryOn/issues"));
                    player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.RED + "Please report this error ").func_230529_a_((ITextComponent)s), false);
                }
            }
        }
        return ActionResultType.FAIL;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (ItemCarryonBlock.hasTileData(stack)) {
            if (entity instanceof LivingEntity) {
                if (!(entity instanceof PlayerEntity && ((Boolean)Configs.Settings.slownessInCreative.get()).booleanValue() || !((PlayerEntity)entity).func_184812_l_())) {
                    return;
                }
                ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_76421_d, 1, this.potionLevel(stack), false, false));
            }
        } else {
            stack = ItemStack.field_190927_a;
        }
    }

    public static boolean hasTileData(ItemStack stack) {
        if (stack.func_77942_o()) {
            CompoundNBT tag = stack.func_77978_p();
            return tag.func_74764_b(TILE_DATA_KEY) && tag.func_74764_b("block") && tag.func_74764_b("stateid");
        }
        return false;
    }

    public static boolean storeTileData(@Nullable TileEntity tile, World world, BlockPos pos, BlockState state, ItemStack stack) {
        CompoundNBT tag;
        if (stack.func_190926_b()) {
            return false;
        }
        CompoundNBT tileTag = new CompoundNBT();
        if (tile != null) {
            tileTag = tile.func_189515_b(tileTag);
        }
        CompoundNBT compoundNBT = tag = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        if (tag.func_74764_b(TILE_DATA_KEY)) {
            return false;
        }
        tag.func_218657_a(TILE_DATA_KEY, (INBT)tileTag);
        tag.func_74778_a("block", state.func_177230_c().getRegistryName().toString());
        tag.func_74768_a("stateid", Block.func_196246_j((BlockState)state));
        stack.func_77982_d(tag);
        return true;
    }

    public static void updateTileLocation(CompoundNBT tag, BlockPos pos) {
        tag.func_74768_a("x", pos.func_177958_n());
        tag.func_74768_a("y", pos.func_177956_o());
        tag.func_74768_a("z", pos.func_177952_p());
    }

    public static void clearTileData(ItemStack stack) {
        if (stack.func_77942_o()) {
            CompoundNBT tag = stack.func_77978_p();
            tag.func_82580_o(TILE_DATA_KEY);
            tag.func_82580_o("block");
            tag.func_82580_o("stateid");
        }
    }

    public static CompoundNBT getTileData(ItemStack stack) {
        if (stack.func_77942_o()) {
            CompoundNBT tag = stack.func_77978_p();
            return tag.func_74775_l(TILE_DATA_KEY);
        }
        return null;
    }

    public static Block getBlock(ItemStack stack) {
        if (stack.func_77942_o()) {
            CompoundNBT tag = stack.func_77978_p();
            int id = tag.func_74762_e("stateid");
            return Block.func_196257_b((int)id).func_177230_c();
        }
        return Blocks.field_150350_a;
    }

    public static ItemStack getItemStack(ItemStack stack) {
        return new ItemStack((IItemProvider)ItemCarryonBlock.getBlock(stack), 1);
    }

    public static BlockState getBlockState(ItemStack stack) {
        if (stack.func_77942_o()) {
            CompoundNBT tag = stack.func_77978_p();
            int id = tag.func_74762_e("stateid");
            return Block.func_196257_b((int)id);
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public static boolean isLocked(BlockPos pos, World world) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null) {
            CompoundNBT tag = new CompoundNBT();
            te.func_189515_b(tag);
            return tag.func_74764_b("Lock") ? !tag.func_74779_i("Lock").equals("") : false;
        }
        return false;
    }

    private int potionLevel(ItemStack stack) {
        String nbt = ItemCarryonBlock.getTileData(stack).toString();
        int i = nbt.length() / 500;
        if (i > 4) {
            i = 4;
        }
        if (!((Boolean)Configs.Settings.heavyTiles.get()).booleanValue()) {
            i = 1;
        }
        return (int)((double)i * (Double)Configs.Settings.blockSlownessMultiplier.get());
    }
}

