/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.biodomeGen;

import chanceCubes.rewards.biodomeGen.BasicTreesBiome;
import chanceCubes.rewards.biodomeGen.DesertBiome;
import chanceCubes.rewards.biodomeGen.EndBiome;
import chanceCubes.rewards.biodomeGen.IBioDomeBiome;
import chanceCubes.rewards.biodomeGen.NetherBiome;
import chanceCubes.rewards.biodomeGen.OceanBiome;
import chanceCubes.rewards.biodomeGen.SnowGlobeBiome;
import chanceCubes.rewards.rewardparts.OffsetBlock;
import chanceCubes.util.RewardBlockCache;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class BioDomeGen {
    public static final int delayShorten = 10;
    public static final IBioDomeBiome[] biomes = new IBioDomeBiome[]{new BasicTreesBiome("trees_plains"), new DesertBiome("desert"), new EndBiome("end"), new OceanBiome("ocean"), new SnowGlobeBiome("snow_globe"), new NetherBiome("nether")};
    private PlayerEntity player;
    private RewardBlockCache blockCache;
    private int yinc;
    private int xinc;
    private List<String> blackListBiomes;

    public BioDomeGen(PlayerEntity player) {
        this(player, new ArrayList<String>());
    }

    public BioDomeGen(PlayerEntity player, List<String> blackListBiomes) {
        this.player = player;
        this.blackListBiomes = blackListBiomes;
    }

    public void genRandomDome(BlockPos pos, ServerWorld world, int radius, boolean spawnEntities) {
        IBioDomeBiome biome = biomes[0];
        List biomesFiltered = Arrays.stream(biomes).filter(line -> !this.blackListBiomes.contains(line.getBiomeName())).collect(Collectors.toList());
        if (biomesFiltered.size() != 0) {
            biome = (IBioDomeBiome)biomesFiltered.get(RewardsUtil.rand.nextInt(biomesFiltered.size()));
        }
        this.genDome(biome, pos, world, radius, spawnEntities);
    }

    public void genDome(IBioDomeBiome spawnedBiome, BlockPos pos, ServerWorld world, int radius, boolean spawnEntities) {
        this.yinc = 0;
        this.xinc = -radius;
        this.blockCache = new RewardBlockCache((World)world, pos, this.player.func_233580_cy_());
        this.genDomePart(spawnedBiome, pos, world, radius, spawnEntities);
    }

    private void genDomePart(final IBioDomeBiome spawnedBiome, final BlockPos pos, final ServerWorld world, final int radius, final boolean spawnEntities) {
        ArrayList<OffsetBlock> blocks = new ArrayList<OffsetBlock>();
        int delay = 0;
        for (int z = -radius; z <= radius; ++z) {
            BlockPos loc = new BlockPos(this.xinc, this.yinc, z);
            float dist = (float)(Math.sqrt(Math.abs(loc.func_218140_a(0.0, 0.0, 0.0, false))) - (double)radius);
            if (!(dist < 1.0f)) continue;
            if (dist >= 0.0f) {
                blocks.add(new OffsetBlock(this.xinc, this.yinc, z, Blocks.field_150359_w, false, delay / 10));
                ++delay;
            } else if (this.yinc == 0) {
                blocks.add(new OffsetBlock(this.xinc, this.yinc, z, spawnedBiome.getFloorBlock(), false, delay / 10));
                ++delay;
            }
            spawnedBiome.getRandomGenBlock(dist, RewardsUtil.rand, this.xinc, this.yinc, z, blocks, delay);
        }
        this.xinc = this.xinc + 1 > radius ? -radius : this.xinc + 1;
        int yIncTemp = this.yinc;
        if (this.xinc == -radius) {
            int n = yIncTemp = yIncTemp + 1 > radius ? -1 : yIncTemp + 1;
        }
        if (yIncTemp == -1) {
            if (spawnEntities) {
                Scheduler.scheduleTask(new Task("Entity_Delays", delay){

                    @Override
                    public void callback() {
                        spawnedBiome.spawnEntities(pos, world);
                    }
                });
            }
            if (spawnedBiome instanceof OceanBiome) {
                this.player.func_195064_c(new EffectInstance(Effects.field_76427_o, 1200));
            }
            return;
        }
        this.yinc = yIncTemp;
        for (OffsetBlock b : blocks) {
            b.spawnInWorld((World)world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), this.blockCache);
        }
        Scheduler.scheduleTask(new Task("BioDome Reward", delay / 10){

            @Override
            public void callback() {
                BioDomeGen.this.genDomePart(spawnedBiome, pos, world, radius, spawnEntities);
            }
        });
    }

    public void removeDome(boolean resetPlayer) {
        this.blockCache.restoreBlocks((Entity)(resetPlayer ? this.player : null));
    }
}

