/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.defaultRewards;

import chanceCubes.rewards.biodomeGen.BioDomeGen;
import chanceCubes.rewards.defaultRewards.BaseCustomReward;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import com.google.common.collect.Multimap;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.network.play.server.STitlePacket;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public abstract class BossBaseReward
extends BaseCustomReward {
    private String bossName;

    public BossBaseReward(String bossName) {
        super("chancecubes:boss_" + bossName, -35);
        this.bossName = bossName.replace("_", " ");
    }

    @Override
    public void trigger(final ServerWorld world, final BlockPos pos, final PlayerEntity player, final JsonObject settings) {
        final BattleWrapper battleWrapper = new BattleWrapper();
        battleWrapper.rewardCenterPos = pos;
        battleWrapper.domeGen = new BioDomeGen(player);
        battleWrapper.domeGen.genRandomDome(pos.func_177982_a(0, -1, 0), world, 15, false);
        StringTextComponent message = new StringTextComponent("BOSS FIGHT!");
        message.func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.RED)));
        RewardsUtil.setNearPlayersTitle((World)world, pos, 50, STitlePacket.Type.TITLE, (ITextComponent)message, 10, 500, 0);
        Scheduler.scheduleTask(new Task("boss_fight_subtitle_1", 120){

            @Override
            public void callback() {
                StringTextComponent message = new StringTextComponent("");
                message.func_230529_a_(player.func_145748_c_());
                StringBuilder sbSpace = new StringBuilder();
                sbSpace.append(" VS ");
                for (int i = 0; i < BossBaseReward.this.bossName.length(); ++i) {
                    sbSpace.append(" ");
                }
                message.func_240702_b_(sbSpace.toString());
                message.func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.RED)));
                RewardsUtil.setNearPlayersTitle((World)world, pos, 50, STitlePacket.Type.SUBTITLE, (ITextComponent)message, 0, 500, 0);
            }
        });
        Scheduler.scheduleTask(new Task("boss_fight_subtitle_2", 160){

            @Override
            public void callback() {
                StringTextComponent message = new StringTextComponent("");
                message.func_230529_a_(player.func_145748_c_());
                message.func_240702_b_(" VS ");
                message.func_240702_b_(BossBaseReward.this.bossName);
                message.func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.RED)));
                RewardsUtil.setNearPlayersTitle((World)world, pos, 50, STitlePacket.Type.SUBTITLE, (ITextComponent)message, 0, 100, 10);
            }
        });
        Scheduler.scheduleTask(new Task("boss_fight_start", 200){

            @Override
            public void callback() {
                BossBaseReward.this.startBossFight(world, pos, player, settings, battleWrapper);
            }
        });
    }

    public void startBossFight(final ServerWorld world, final BlockPos pos, final PlayerEntity player, JsonObject settings, final BattleWrapper battleWrapper) {
        LivingEntity ent = this.initBoss(world, pos, player, settings, battleWrapper);
        ent.func_70634_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        ent.func_110148_a(Attributes.field_233818_a_).func_111128_a(this.getBossHealthDynamic(player, settings));
        ent.func_70606_j(ent.func_110138_aP());
        world.func_217376_c((Entity)ent);
        this.trackEntities(battleWrapper, new Entity[]{ent});
        this.trackPlayers(battleWrapper, player);
        Scheduler.scheduleTask(new Task("boss_fight_tracker", -1, 5){

            @Override
            public void callback() {
            }

            @Override
            public void update() {
                Entity ent;
                int i;
                for (i = battleWrapper.trackedEntities.size() - 1; i >= 0; --i) {
                    ent = battleWrapper.trackedEntities.get(i);
                    if (ent.func_70089_S() || ent.field_70173_aa <= 0 && !world.func_175659_aa().equals((Object)Difficulty.PEACEFUL)) continue;
                    battleWrapper.trackedEntities.remove(i);
                    if (!battleWrapper.trackedEntities.isEmpty()) continue;
                    BossBaseReward.this.endBossfight(true, world, pos, player, battleWrapper);
                    Scheduler.removeTask(this);
                }
                for (i = battleWrapper.trackedPlayers.size() - 1; i >= 0; --i) {
                    ent = (Entity)battleWrapper.trackedPlayers.get(i);
                    if (ent.func_70092_e((double)battleWrapper.rewardCenterPos.func_177958_n(), (double)battleWrapper.rewardCenterPos.func_177956_o(), (double)battleWrapper.rewardCenterPos.func_177952_p()) > 225.0 || ent.func_226278_cu_() < (double)(battleWrapper.rewardCenterPos.func_177956_o() - 1)) {
                        ent.func_70634_a((double)battleWrapper.rewardCenterPos.func_177958_n(), (double)(battleWrapper.rewardCenterPos.func_177956_o() + 1), (double)battleWrapper.rewardCenterPos.func_177952_p());
                    }
                    if (ent.func_70089_S() || ent.field_70173_aa <= 0 && !world.func_175659_aa().equals((Object)Difficulty.PEACEFUL)) continue;
                    for (Entity entity : battleWrapper.trackedEntities) {
                        entity.func_70106_y();
                    }
                    battleWrapper.trackedEntities.clear();
                    BossBaseReward.this.endBossfight(false, world, pos, player, battleWrapper);
                    Scheduler.removeTask(this);
                    return;
                }
            }
        });
    }

    public void endBossfight(boolean resetPlayer, ServerWorld world, BlockPos pos, PlayerEntity player, BattleWrapper battleWrapper) {
        for (Entity ent : battleWrapper.trackedSubEntities) {
            if (!ent.func_70089_S()) continue;
            ent.func_70106_y();
        }
        battleWrapper.trackedSubEntities.clear();
        this.onBossFightEnd(world, pos, player);
        battleWrapper.domeGen.removeDome(resetPlayer);
    }

    protected void trackEntities(BattleWrapper battleWrapper, Entity ... ents) {
        battleWrapper.trackedEntities.addAll(Arrays.asList(ents));
    }

    protected void trackSubEntities(BattleWrapper battleWrapper, Entity ... ents) {
        battleWrapper.trackedSubEntities.addAll(Arrays.asList(ents));
    }

    protected void trackPlayers(BattleWrapper battleWrapper, PlayerEntity ... player) {
        battleWrapper.trackedPlayers.addAll(Arrays.asList(player));
    }

    public abstract LivingEntity initBoss(ServerWorld var1, BlockPos var2, PlayerEntity var3, JsonObject var4, BattleWrapper var5);

    public abstract void onBossFightEnd(ServerWorld var1, BlockPos var2, PlayerEntity var3);

    public double getBossHealthDynamic(PlayerEntity player, JsonObject settings) {
        double maxDamage = 3.0;
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            Multimap atributes = stack.func_77973_b().getAttributeModifiers(EquipmentSlotType.MAINHAND, stack);
            if (!atributes.containsKey((Object)Attributes.field_233823_f_)) continue;
            Collection damageList = atributes.get((Object)Attributes.field_233823_f_);
            for (AttributeModifier damage : damageList) {
                if (!(maxDamage < damage.func_111164_d())) continue;
                maxDamage = damage.func_111164_d();
            }
        }
        double prePofileHealth = maxDamage * 15.0;
        double profileMult = super.getSettingAsDouble(settings, "bossHealthMultiplier", 1.0, 0.0, 10.0);
        return prePofileHealth * profileMult;
    }

    public ItemStack getHighestDamageItem(PlayerEntity player) {
        double maxDamage = -1.0;
        ItemStack maxItem = ItemStack.field_190927_a;
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            Multimap atributes = stack.func_77973_b().getAttributeModifiers(EquipmentSlotType.MAINHAND, stack);
            if (!atributes.containsKey((Object)Attributes.field_233823_f_)) continue;
            Collection damageList = atributes.get((Object)Attributes.field_233823_f_);
            for (AttributeModifier damage : damageList) {
                if (!(maxDamage < damage.func_111164_d())) continue;
                maxDamage = damage.func_111164_d();
                maxItem = stack;
            }
        }
        return maxItem;
    }

    protected static class BattleWrapper {
        public List<Entity> trackedEntities = new ArrayList<Entity>();
        public List<Entity> trackedSubEntities = new ArrayList<Entity>();
        public List<PlayerEntity> trackedPlayers = new ArrayList<PlayerEntity>();
        public BlockPos rewardCenterPos;
        public BioDomeGen domeGen;

        protected BattleWrapper() {
        }
    }
}

