/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.defaultRewards;

import chanceCubes.rewards.defaultRewards.BaseCustomReward;
import chanceCubes.util.GameTurn;
import chanceCubes.util.Point;
import chanceCubes.util.RewardBlockCache;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LadderBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class Connect4Reward
extends BaseCustomReward {
    private static int WIDTH = 7;
    private static int HEIGHT = 6;

    public Connect4Reward() {
        super("chancecubes:connect_4", 0);
    }

    @Override
    public void trigger(final ServerWorld world, final BlockPos pos, final PlayerEntity player, JsonObject settings) {
        int y;
        int z;
        int x;
        final int mistakeChance = super.getSettingAsInt(settings, "mistakeChance", 3, 0, 100);
        RewardsUtil.sendMessageToPlayer(player, "Lets play Connect 4!");
        RewardsUtil.sendMessageToPlayer(player, "Beat the Computer to get 5 Diamonds!");
        final RewardBlockCache cache = new RewardBlockCache((World)world, pos, player.func_233580_cy_());
        BlockPos playerPos = pos.func_177982_a(3, 0, 0);
        player.func_70012_b((double)playerPos.func_177958_n(), (double)playerPos.func_177956_o(), (double)playerPos.func_177952_p(), 0.0f, 0.0f);
        player.field_70170_p.func_217376_c((Entity)new ItemEntity(player.field_70170_p, (double)playerPos.func_177958_n(), (double)playerPos.func_177956_o(), (double)playerPos.func_177952_p(), new ItemStack((IItemProvider)Blocks.field_196883_jg, 21)));
        for (x = -5; x < 6; ++x) {
            for (z = -6; z < 7; ++z) {
                for (int y2 = 0; y2 < 9; ++y2) {
                    cache.cacheBlock(new BlockPos(x, y2, z), Blocks.field_150350_a.func_176223_P());
                }
            }
        }
        for (x = -3; x < 4; ++x) {
            for (z = -4; z < 5; ++z) {
                if (z != -4 && z != 4 && x != 0) continue;
                world.func_175656_a(pos.func_177982_a(x, 0, z), Blocks.field_150357_h.func_176223_P());
            }
        }
        for (y = 0; y < 8; ++y) {
            for (int x2 = -1; x2 < 2; ++x2) {
                world.func_175656_a(pos.func_177982_a(x2, y, -4), Blocks.field_150357_h.func_176223_P());
                world.func_175656_a(pos.func_177982_a(x2, y, 4), Blocks.field_150357_h.func_176223_P());
            }
        }
        for (x = -1; x < 2; ++x) {
            for (z = -4; z < 5; ++z) {
                if (z != -4 && z != 4 && x != -1 && x != 1) continue;
                world.func_175656_a(pos.func_177982_a(x, 7, z), Blocks.field_150357_h.func_176223_P());
            }
        }
        for (y = 1; y < 7; ++y) {
            for (z = -3; z < 4; ++z) {
                world.func_175656_a(pos.func_177982_a(-1, y, z), Blocks.field_150359_w.func_176223_P());
                world.func_175656_a(pos.func_177982_a(1, y, z), Blocks.field_150359_w.func_176223_P());
            }
        }
        for (y = 0; y < 8; ++y) {
            world.func_175656_a(pos.func_177982_a(0, y, -5), Blocks.field_150468_ap.func_176223_P());
            world.func_175656_a(pos.func_177982_a(0, y, 5), (BlockState)Blocks.field_150468_ap.func_176223_P().func_206870_a((Property)LadderBlock.field_176382_a, (Comparable)Direction.SOUTH));
        }
        world.func_175656_a(pos.func_177982_a(-2, 1, -4), Blocks.field_150357_h.func_176223_P());
        world.func_175656_a(pos.func_177982_a(2, 1, -4), Blocks.field_150357_h.func_176223_P());
        world.func_175656_a(pos.func_177982_a(-2, 1, 4), Blocks.field_150357_h.func_176223_P());
        world.func_175656_a(pos.func_177982_a(2, 1, 4), Blocks.field_150357_h.func_176223_P());
        Scheduler.scheduleTask(new Task("Connect_4_Game", 10000, 5){
            Board board;
            {
                super(name, delay, updateTick);
                this.board = new Board();
            }

            @Override
            public void callback() {
            }

            @Override
            public void update() {
                for (int z = -3; z < 4; ++z) {
                    for (int y = 1; y < 7; ++y) {
                        BlockPos pos2;
                        if (this.board.board[(y - 1) * WIDTH + (z + 3)] != 0 || y - 2 >= 0 && this.board.board[(y - 2) * WIDTH + (z + 3)] == 0 || world.func_175623_d(pos2 = pos.func_177982_a(0, y, z)) || !world.func_180495_p(pos2).func_177230_c().equals(Blocks.field_196883_jg)) continue;
                        this.makeMove(z + 3, y - 1);
                    }
                }
            }

            private void makeMove(int x, int y) {
                this.board.placeMove(x, y, GameTurn.PLAYER);
                this.board.updateWorldView((World)world, pos);
                boolean playerWon = this.board.hasWon(x, y, GameTurn.PLAYER);
                if (!this.board.isTie() && !playerWon) {
                    this.board.minimax(0, GameTurn.CPU, null, mistakeChance);
                    this.board.placeMove(this.board.computersMove.x, this.board.computersMove.y, GameTurn.CPU);
                    world.func_175656_a(pos.func_177982_a(0, 8, this.board.computersMove.x - 3), Blocks.field_196868_iW.func_176223_P());
                }
                boolean gameOver = false;
                if (playerWon) {
                    RewardsUtil.sendMessageToPlayer(player, "You Won!");
                    player.field_70170_p.func_217376_c((Entity)new ItemEntity(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), new ItemStack((IItemProvider)Items.field_151045_i, 5)));
                    gameOver = true;
                } else if (this.board.hasWon(this.board.computersMove.x, this.board.computersMove.y, GameTurn.CPU)) {
                    RewardsUtil.sendMessageToPlayer(player, "The Computer won! Better luck next time!");
                    gameOver = true;
                } else if (this.board.isTie()) {
                    RewardsUtil.sendMessageToPlayer(player, "You tied! Better luck next time!");
                    gameOver = true;
                }
                if (gameOver) {
                    this.delayLeft = 0;
                    Scheduler.scheduleTask(new Task("Connect_4_Game_End_Delay", 40){

                        @Override
                        public void callback() {
                            cache.restoreBlocks((Entity)player);
                        }
                    });
                }
            }
        });
    }

    private static class Board {
        public int[] board = new int[Connect4Reward.access$300() * Connect4Reward.access$100()];
        public Point computersMove;

        private Board() {
        }

        public boolean isTie() {
            return this.getAvailableStates().isEmpty();
        }

        public void placeMove(int x, int y, GameTurn turn) {
            this.board[WIDTH * y + x] = turn == GameTurn.PLAYER ? 2 : 1;
        }

        private boolean hasWon(int placedX, int placedY, GameTurn playerTurn) {
            int adj;
            int adjY;
            int adjX;
            int adj2;
            int i;
            int turn = playerTurn == GameTurn.PLAYER ? 2 : 1;
            int y = placedY * WIDTH;
            for (i = Math.max(0, placedX - 3); i <= placedX; ++i) {
                adj2 = i + y;
                if (adj2 < 0 || adj2 >= WIDTH * HEIGHT || i + 3 >= WIDTH || this.board[adj2] != turn || this.board[adj2 + 1] != turn || this.board[adj2 + 2] != turn || this.board[adj2 + 3] != turn) continue;
                return true;
            }
            for (i = Math.max(0, placedY - 3); i <= placedY; ++i) {
                adj2 = placedX + i * WIDTH;
                if (adj2 < 0 || adj2 >= WIDTH * HEIGHT || i + 3 >= HEIGHT || this.board[adj2] != turn || this.board[adj2 + WIDTH] != turn || this.board[adj2 + 2 * WIDTH] != turn || this.board[adj2 + 3 * WIDTH] != turn) continue;
                return true;
            }
            for (i = -3; i <= 0; ++i) {
                adjX = placedX + i;
                adjY = placedY + i;
                adj = adjX + adjY * WIDTH;
                if (adj < 0 || adj >= WIDTH * HEIGHT || adjX + 3 >= WIDTH || adjY + 3 >= HEIGHT || this.board[adj] != turn || this.board[adj + WIDTH + 1] != turn || this.board[adj + 2 * WIDTH + 2] != turn || this.board[adj + 3 * WIDTH + 3] != turn) continue;
                return true;
            }
            for (i = -3; i <= 0; ++i) {
                adjX = placedX + i;
                adjY = placedY - i;
                adj = adjX + adjY * WIDTH;
                if (adj < 0 || adj >= WIDTH * HEIGHT || adjX + 3 >= WIDTH || adjY - 3 < 0 || this.board[adj] != turn || this.board[adj - WIDTH + 1] != turn || this.board[adj - 2 * WIDTH + 2] != turn || this.board[adj - 3 * WIDTH + 3] != turn) continue;
                return true;
            }
            return false;
        }

        public List<Point> getAvailableStates() {
            ArrayList<Point> availablePoints = new ArrayList<Point>();
            for (int j = 0; j < 6; ++j) {
                for (int i = 0; i < 7; ++i) {
                    if (this.board[j * WIDTH + i] != 0 || j != 0 && this.board[(j - 1) * WIDTH + i] == 0) continue;
                    availablePoints.add(new Point(i, j));
                }
            }
            return availablePoints;
        }

        public int minimax(int depth, GameTurn turn, Point lastPlaced, int mistakeChance) {
            if (lastPlaced != null) {
                if (turn == GameTurn.PLAYER && this.hasWon(lastPlaced.x, lastPlaced.y, GameTurn.CPU)) {
                    return 1 - depth;
                }
                if (turn == GameTurn.CPU && this.hasWon(lastPlaced.x, lastPlaced.y, GameTurn.PLAYER)) {
                    return -1;
                }
            }
            if (depth > 7) {
                return 0;
            }
            List<Point> pointsAvailable = this.getAvailableStates();
            if (pointsAvailable.isEmpty()) {
                return 0;
            }
            if (depth == 0 && RewardsUtil.rand.nextInt(100) < mistakeChance) {
                this.computersMove = pointsAvailable.get(RewardsUtil.rand.nextInt(pointsAvailable.size()));
                return 0;
            }
            int min = Integer.MAX_VALUE;
            int max = Integer.MIN_VALUE;
            for (int i = 0; i < pointsAvailable.size(); ++i) {
                Point point = pointsAvailable.get(i);
                this.placeMove(point.x, point.y, turn);
                int currentScore = this.minimax(depth + 1, turn == GameTurn.CPU ? GameTurn.PLAYER : GameTurn.CPU, point, mistakeChance);
                if (turn == GameTurn.CPU) {
                    max = Math.max(currentScore, max);
                    if (currentScore >= 0 && depth == 0) {
                        this.computersMove = point;
                    }
                    if (currentScore == 1) {
                        this.board[point.y * WIDTH + point.x] = 0;
                        break;
                    }
                    if (i == pointsAvailable.size() - 1 && max < 0 && depth == 0) {
                        this.computersMove = point;
                    }
                } else if (turn == GameTurn.PLAYER && (min = Math.min(currentScore, min)) == -1) {
                    this.board[point.y * WIDTH + point.x] = 0;
                    break;
                }
                this.board[point.y * WIDTH + point.x] = 0;
            }
            return turn == GameTurn.CPU ? max : min;
        }

        public void updateWorldView(World world, BlockPos pos) {
            for (int z = -3; z < 4; ++z) {
                for (int y = 1; y < 7; ++y) {
                    world.func_175656_a(pos.func_177982_a(0, y, z), this.getStateForBoardVal(this.board[(y - 1) * WIDTH + (z + 3)]));
                }
            }
        }

        public BlockState getStateForBoardVal(int val) {
            switch (val) {
                case 1: {
                    return Blocks.field_196868_iW.func_176223_P();
                }
                case 2: {
                    return Blocks.field_196883_jg.func_176223_P();
                }
            }
            return Blocks.field_150350_a.func_176223_P();
        }
    }
}

