/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.defaultRewards;

import chanceCubes.rewards.defaultRewards.BaseCustomReward;
import chanceCubes.util.CCubesDamageSource;
import chanceCubes.util.RewardBlockCache;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.play.server.STitlePacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class MathReward
extends BaseCustomReward {
    private Map<PlayerEntity, RewardInfo> inQuestion = new HashMap<PlayerEntity, RewardInfo>();

    public MathReward() {
        super("chancecubes:math", -30);
    }

    @Override
    public void trigger(ServerWorld world, BlockPos pos, final PlayerEntity player, JsonObject settings) {
        if (this.inQuestion.containsKey(player)) {
            return;
        }
        int num1 = world.field_73012_v.nextInt(100);
        int num2 = world.field_73012_v.nextInt(100);
        RewardsUtil.sendMessageToPlayer(player, "Quick, what's " + num1 + "+" + num2 + "?");
        BlockPos playerPos = new BlockPos(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
        RewardBlockCache cache = new RewardBlockCache((World)world, playerPos, player.func_233580_cy_());
        for (int xx = -2; xx < 3; ++xx) {
            for (int zz = -2; zz < 3; ++zz) {
                for (int yy = 1; yy < 5; ++yy) {
                    if (xx == -2 || xx == 2 || zz == -2 || zz == 2 || yy == 1 || yy == 4) {
                        cache.cacheBlock(new BlockPos(xx, yy, zz), Blocks.field_150357_h.func_176223_P());
                        continue;
                    }
                    if (xx != -1 && xx != 1 || zz != -1 && zz != 1 || yy != 2) continue;
                    cache.cacheBlock(new BlockPos(xx, yy, zz), Blocks.field_150426_aN.func_176223_P());
                }
            }
        }
        player.func_70634_a((double)((int)player.func_226277_ct_()), (double)((int)player.func_226278_cu_() + 2), (double)((int)player.func_226281_cx_()));
        ArrayList<Entity> tnt = new ArrayList<Entity>();
        for (int i = 0; i < 5; ++i) {
            TNTEntity entitytntprimed = new TNTEntity((World)world, player.func_226277_ct_(), player.func_226278_cu_() + 1.0, player.func_226281_cx_(), (LivingEntity)player);
            world.func_217376_c((Entity)entitytntprimed);
            world.func_184148_a(player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187904_gd, SoundCategory.BLOCKS, 1.0f, 1.0f);
            entitytntprimed.func_184534_a(140);
            tnt.add((Entity)entitytntprimed);
        }
        this.inQuestion.put(player, new RewardInfo(num1 + num2, tnt, cache));
        int duration = super.getSettingAsInt(settings, "answerDuration", 100, 20, 2400);
        Scheduler.scheduleTask(new Task("Math", duration, 20){

            @Override
            public void callback() {
                MathReward.this.timeUp(player, false);
            }

            @Override
            public void update() {
                if (this.delayLeft % 20 == 0) {
                    this.showTimeLeft(player, STitlePacket.Type.ACTIONBAR);
                }
            }
        });
    }

    private void timeUp(PlayerEntity player, boolean correct) {
        if (!this.inQuestion.containsKey(player)) {
            return;
        }
        if (!RewardsUtil.isPlayerOnline(player)) {
            return;
        }
        RewardInfo info = this.inQuestion.get(player);
        if (correct) {
            RewardsUtil.sendMessageToPlayer(player, "Correct!");
            RewardsUtil.sendMessageToPlayer(player, "Here, have a item!");
            player.field_70170_p.func_217376_c((Entity)new ItemEntity(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), new ItemStack((IItemProvider)RewardsUtil.getRandomItem(), 1)));
        } else {
            player.field_70170_p.func_217385_a((Entity)player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 1.0f, Explosion.Mode.NONE);
            player.func_70097_a((DamageSource)CCubesDamageSource.MATH_FAIL, Float.MAX_VALUE);
        }
        for (Entity tnt : info.tnt) {
            tnt.func_70106_y();
        }
        info.cache.restoreBlocks((Entity)player);
        this.inQuestion.remove(player);
    }

    @SubscribeEvent
    public void onMessage(ServerChatEvent event) {
        ServerPlayerEntity player = event.getPlayer();
        if (this.inQuestion.containsKey(player)) {
            int answer = 0;
            try {
                answer = Integer.parseInt(event.getMessage());
            }
            catch (NumberFormatException e) {
                RewardsUtil.sendMessageToPlayer((PlayerEntity)player, "Incorrect!");
            }
            if (this.inQuestion.get((Object)player).answer == answer) {
                this.timeUp((PlayerEntity)player, true);
            } else {
                RewardsUtil.sendMessageToPlayer((PlayerEntity)player, "Incorrect!");
            }
            event.setCanceled(true);
        }
    }

    private static class RewardInfo {
        public int answer;
        public List<Entity> tnt;
        public RewardBlockCache cache;

        public RewardInfo(int answer, List<Entity> tnt, RewardBlockCache cache) {
            this.answer = answer;
            this.tnt = tnt;
            this.cache = cache;
        }
    }
}

