/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.util;

import chanceCubes.config.ConfigLoader;
import chanceCubes.rewards.rewardparts.OffsetBlock;
import chanceCubes.rewards.rewardparts.OffsetTileEntity;
import chanceCubes.rewards.variableTypes.BoolVar;
import chanceCubes.rewards.variableTypes.FloatVar;
import chanceCubes.rewards.variableTypes.IntVar;
import chanceCubes.rewards.variableTypes.NBTVar;
import chanceCubes.util.CustomEntry;
import chanceCubes.util.CustomSchematic;
import chanceCubes.util.FileUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class SchematicUtil {
    private static Gson gson = new GsonBuilder().create();
    public static BlockPos[] selectionPoints = new BlockPos[2];

    public static void createCustomSchematic(final World world, final BlockPos loc1, final BlockPos loc2, final String fileName) {
        Scheduler.scheduleTask(new Task("Schematic Creation", 1){

            @Override
            public void callback() {
                ArrayList blocks = new ArrayList();
                ArrayList blockDataIds = new ArrayList();
                ArrayList tileEntityData = new ArrayList();
                int largeX = Math.max(loc1.func_177958_n(), loc2.func_177958_n());
                int smallX = Math.min(loc1.func_177958_n(), loc2.func_177958_n());
                int largeY = Math.max(loc1.func_177956_o(), loc2.func_177956_o());
                int smallY = Math.min(loc1.func_177956_o(), loc2.func_177956_o());
                int largeZ = Math.max(loc1.func_177952_p(), loc2.func_177952_p());
                int smallZ = Math.min(loc1.func_177952_p(), loc2.func_177952_p());
                Vector3i small = new Vector3i(smallX, smallY, smallZ);
                Vector3i large = new Vector3i(largeX, largeY, largeZ);
                SchematicUtil.storeBlocksInfo(small, large, world, blocks, blockDataIds, tileEntityData);
                JsonObject json = new JsonObject();
                JsonArray blockArray = new JsonArray();
                int row = 0;
                int last = -1;
                Iterator iterator = blocks.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    if (last == i) {
                        ++row;
                        continue;
                    }
                    if (row != 0) {
                        Object value = "" + last;
                        if (row != 1) {
                            value = (String)value + "x" + row;
                        }
                        blockArray.add((JsonElement)new JsonPrimitive((String)value));
                    }
                    last = i;
                    row = 1;
                }
                String value = "" + last;
                if (row != 1) {
                    value = value + "x" + row;
                }
                blockArray.add((JsonElement)new JsonPrimitive(value));
                json.add("Blocks", (JsonElement)blockArray);
                JsonArray blockDataArray = new JsonArray();
                for (Object i : blockDataIds) {
                    JsonObject index = new JsonObject();
                    index.addProperty((String)((CustomEntry)i).getValue(), (Number)((CustomEntry)i).getKey());
                    blockDataArray.add((JsonElement)index);
                }
                json.add("Block Data", (JsonElement)blockDataArray);
                JsonArray tileEntityDataArray = new JsonArray();
                for (CustomEntry i : tileEntityData) {
                    JsonObject index = new JsonObject();
                    JsonArray tileEntityBlockIds = new JsonArray();
                    Iterator iterator2 = ((List)i.getValue()).iterator();
                    while (iterator2.hasNext()) {
                        int id = (Integer)iterator2.next();
                        tileEntityBlockIds.add((JsonElement)new JsonPrimitive((Number)id));
                    }
                    index.add((String)i.getKey(), (JsonElement)tileEntityBlockIds);
                    tileEntityDataArray.add((JsonElement)index);
                }
                json.add("TileEntities", (JsonElement)tileEntityDataArray);
                JsonObject info = new JsonObject();
                info.addProperty("xSize", (Number)(large.func_177958_n() - small.func_177958_n()));
                info.addProperty("ySize", (Number)(large.func_177956_o() - small.func_177956_o()));
                info.addProperty("zSize", (Number)(large.func_177952_p() - small.func_177952_p()));
                json.add("Schematic Data", (JsonElement)info);
                FileUtil.writeToFile(ConfigLoader.schematicsFolder.getAbsolutePath() + "/" + fileName, gson.toJson((JsonElement)json));
            }
        });
    }

    private static void storeBlocksInfo(Vector3i small, Vector3i large, World world, List<Integer> blocks, List<CustomEntry<Integer, String>> blockDataIds, List<CustomEntry<String, List<Integer>>> tileEntityData) {
        StringBuilder blockData = new StringBuilder();
        for (int y = small.func_177956_o(); y < large.func_177956_o(); ++y) {
            for (int x = small.func_177958_n(); x < large.func_177958_n(); ++x) {
                for (int z = small.func_177952_p(); z < large.func_177952_p(); ++z) {
                    blockData.setLength(0);
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState blockState = world.func_180495_p(pos);
                    blockData.append(blockState.func_177230_c().getRegistryName().toString());
                    String encoded = SchematicUtil.encodeBlockState(blockState);
                    if (!encoded.isEmpty()) {
                        blockData.append(":").append(encoded);
                    }
                    String blockString = blockData.toString();
                    int id = -1;
                    for (CustomEntry<Integer, String> data : blockDataIds) {
                        if (!blockString.equalsIgnoreCase(data.getValue())) continue;
                        id = data.getKey();
                    }
                    if (id == -1) {
                        id = blockDataIds.size();
                        blockDataIds.add(new CustomEntry<Integer, String>(id, blockString));
                    }
                    blocks.add(id);
                    if (world.func_175625_s(pos) == null) continue;
                    TileEntity te = world.func_175625_s(pos);
                    CompoundNBT nbt = new CompoundNBT();
                    nbt = te.func_189515_b(nbt);
                    for (CustomEntry<String, List<Integer>> data : tileEntityData) {
                        if (!nbt.toString().equalsIgnoreCase(data.getKey())) continue;
                        data.getValue().add(blocks.size() - 1);
                        break;
                    }
                    ArrayList<Integer> list = new ArrayList<Integer>();
                    list.add(blocks.size() - 1);
                    tileEntityData.add(new CustomEntry(nbt.toString(), list));
                }
            }
        }
    }

    public static CustomSchematic loadCustomSchematic(String file, int xOffSet, int yOffSet, int zOffSet, FloatVar spacingDelay, BoolVar falling, BoolVar relativeToPlayer, BoolVar includeAirBlocks, BoolVar playSound, IntVar delay) {
        JsonElement elem = FileUtil.readJsonfromFile(ConfigLoader.schematicsFolder.getAbsolutePath() + "/" + file);
        return SchematicUtil.loadCustomSchematic(elem, xOffSet, yOffSet, zOffSet, spacingDelay, falling, relativeToPlayer, includeAirBlocks, playSound, delay);
    }

    public static CustomSchematic loadCustomSchematic(JsonElement elem, int xOffSet, int yOffSet, int zOffSet, FloatVar spacingDelay, BoolVar falling, BoolVar relativeToPlayer, BoolVar includeAirBlocks, BoolVar playSound, IntVar delay) {
        if (elem == null) {
            return null;
        }
        JsonObject json = elem.getAsJsonObject();
        ArrayList<OffsetBlock> offsetBlocks = new ArrayList<OffsetBlock>();
        JsonObject info = json.get("Schematic Data").getAsJsonObject();
        int xSize = info.get("xSize").getAsInt();
        int ySize = info.get("ySize").getAsInt();
        int zSize = info.get("zSize").getAsInt();
        ArrayList<CustomEntry<Integer, String>> blockDataIds = new ArrayList<CustomEntry<Integer, String>>();
        JsonArray blockDataArray = json.get("Block Data").getAsJsonArray();
        for (JsonElement i : blockDataArray) {
            JsonObject index = i.getAsJsonObject();
            for (Map.Entry obj : index.entrySet()) {
                blockDataIds.add(new CustomEntry<Integer, String>(((JsonElement)obj.getValue()).getAsInt(), (String)obj.getKey()));
            }
        }
        int index = 0;
        ArrayList<Integer> blockArray = new ArrayList<Integer>();
        for (JsonElement ids : json.get("Blocks").getAsJsonArray()) {
            String entry = ids.getAsString();
            String[] parts = entry.split("x");
            int id = Integer.parseInt(parts[0]);
            int recurse = parts.length > 1 ? Integer.parseInt(parts[1]) : 1;
            for (int i = 0; i < recurse; ++i) {
                blockArray.add(id);
            }
        }
        for (int yOff = 0; yOff < ySize; ++yOff) {
            for (int xOff = xSize / 2 - xSize; xOff < xSize / 2; ++xOff) {
                for (int zOff = zSize / 2 - zSize; zOff < zSize / 2; ++zOff) {
                    String[] stringArray;
                    int id = (Integer)blockArray.get(index);
                    String blockData = "";
                    for (CustomEntry customEntry : blockDataIds) {
                        if ((Integer)customEntry.getKey() != id) continue;
                        blockData = (String)customEntry.getValue();
                        break;
                    }
                    BlockState state = (stringArray = blockData.split(":")).length == 1 ? ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(stringArray[0]))).func_176223_P() : ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(stringArray[0], stringArray[1]))).func_176223_P();
                    if (stringArray.length == 3) {
                        state = SchematicUtil.decodeBlockState(state, stringArray[2]);
                    }
                    OffsetBlock osb = new OffsetBlock(xOff + xOffSet, yOff + yOffSet, zOff + zOffSet, state.func_177230_c(), falling, new IntVar(0));
                    osb.setBlockState(state);
                    osb.setRelativeToPlayer(relativeToPlayer);
                    osb.setPlaysSound(playSound);
                    offsetBlocks.add(osb);
                    ++index;
                }
            }
        }
        JsonArray teArray = json.get("TileEntities").getAsJsonArray();
        for (JsonElement i : teArray) {
            for (Map.Entry obj : i.getAsJsonObject().entrySet()) {
                String teData = (String)obj.getKey();
                for (JsonElement ids : ((JsonElement)obj.getValue()).getAsJsonArray()) {
                    int id = ids.getAsInt();
                    OffsetBlock osb = (OffsetBlock)offsetBlocks.get(id);
                    OffsetTileEntity oste = SchematicUtil.OffsetBlockToTileEntity(osb, teData);
                    if (oste == null) continue;
                    offsetBlocks.set(id, oste);
                }
            }
        }
        return new CustomSchematic(offsetBlocks, xSize, ySize, zSize, relativeToPlayer, includeAirBlocks, spacingDelay, delay);
    }

    public static OffsetTileEntity OffsetBlockToTileEntity(OffsetBlock osb, String nbt) {
        try {
            return SchematicUtil.OffsetBlockToTileEntity(osb, JsonToNBT.func_180713_a((String)nbt));
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static OffsetTileEntity OffsetBlockToTileEntity(OffsetBlock osb, NBTVar nbt) {
        OffsetTileEntity oste = new OffsetTileEntity(osb.xOff, osb.yOff, osb.zOff, osb.getBlockState(), nbt, osb.isFallingVar(), osb.getDelayVar());
        oste.setBlockState(osb.getBlockState());
        oste.setDelay(osb.getDelay());
        oste.setRelativeToPlayer(osb.isRelativeToPlayer());
        oste.setFalling(osb.isFalling());
        return oste;
    }

    public static OffsetTileEntity OffsetBlockToTileEntity(OffsetBlock osb, CompoundNBT nbt) {
        OffsetTileEntity oste = new OffsetTileEntity(osb.xOff, osb.yOff, osb.zOff, osb.getBlockState(), new NBTVar(nbt), osb.isFallingVar(), osb.getDelayVar());
        oste.setBlockState(osb.getBlockState());
        oste.setDelay(osb.getDelay());
        oste.setRelativeToPlayer(osb.isRelativeToPlayer());
        oste.setFalling(osb.isFalling());
        return oste;
    }

    public static JsonElement getSchematicJson(String path) {
        BufferedReader in = new BufferedReader(new InputStreamReader(SchematicUtil.class.getResourceAsStream(path)));
        StringBuilder builder = new StringBuilder();
        try {
            String line;
            while ((line = in.readLine()) != null) {
                builder.append(line);
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return FileUtil.JSON_PARSER.parse(builder.toString());
    }

    public static String encodeBlockState(BlockState state) {
        StringBuilder builder = new StringBuilder("[");
        for (Property prop : state.func_235904_r_()) {
            if (!state.func_235901_b_(prop)) continue;
            builder.append(prop.func_177701_a()).append("=").append(state.func_177229_b(prop).toString()).append(",");
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append("]");
        return builder.toString();
    }

    public static BlockState decodeBlockState(BlockState defaultState, String stateString) {
        BlockState returnState = defaultState;
        if (!stateString.matches("\\[.*]")) {
            return returnState;
        }
        stateString = stateString.substring(1, stateString.length() - 1);
        HashMap map = new HashMap();
        Arrays.stream(stateString.split(",")).forEach(s -> {
            String[] entry = s.split("=");
            map.put(entry[0], entry[1]);
        });
        for (Property prop : defaultState.func_235904_r_()) {
            if (!map.containsKey(prop.func_177701_a())) continue;
            returnState = SchematicUtil.withString(returnState, prop, (String)map.get(prop.func_177701_a()));
        }
        return returnState;
    }

    public static <T extends Comparable<T>> BlockState withString(BlockState state, Property<T> prop, String propVal) {
        return prop.func_185929_b(propVal).map(t -> (BlockState)state.func_206870_a(prop, t)).orElse(state);
    }
}

