/*
 * Decompiled with CFR 0.152.
 */
package cityofskytcd.chineseworkshop.block;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import snownee.kiwi.block.ModBlock;

public class TableBlock
extends ModBlock
implements IWaterLoggable {
    private static final VoxelShape PLATE_VS = TableBlock.func_208617_a((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape NW_VS = TableBlock.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)5.0, (double)14.0, (double)5.0);
    private static final VoxelShape SW_VS = TableBlock.func_208617_a((double)3.0, (double)0.0, (double)11.0, (double)5.0, (double)14.0, (double)13.0);
    private static final VoxelShape SE_VS = TableBlock.func_208617_a((double)11.0, (double)0.0, (double)11.0, (double)13.0, (double)14.0, (double)13.0);
    private static final VoxelShape NE_VS = TableBlock.func_208617_a((double)11.0, (double)0.0, (double)3.0, (double)13.0, (double)14.0, (double)5.0);
    public static final BooleanProperty NW = BooleanProperty.func_177716_a((String)"nw");
    public static final BooleanProperty NE = BooleanProperty.func_177716_a((String)"ne");
    public static final BooleanProperty SE = BooleanProperty.func_177716_a((String)"se");
    public static final BooleanProperty SW = BooleanProperty.func_177716_a((String)"sw");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private final VoxelShape[] shapes = TableBlock.makeShapes();

    private static VoxelShape[] makeShapes() {
        VoxelShape[] shapes = new VoxelShape[16];
        for (int i = 0; i < 16; ++i) {
            shapes[i] = PLATE_VS;
            if (i % 2 == 1) {
                shapes[i] = VoxelShapes.func_197872_a((VoxelShape)shapes[i], (VoxelShape)NW_VS);
            }
            if ((i >> 1) % 2 == 1) {
                shapes[i] = VoxelShapes.func_197872_a((VoxelShape)shapes[i], (VoxelShape)NE_VS);
            }
            if ((i >> 2) % 2 == 1) {
                shapes[i] = VoxelShapes.func_197872_a((VoxelShape)shapes[i], (VoxelShape)SW_VS);
            }
            if ((i >> 3) % 2 != 1) continue;
            shapes[i] = VoxelShapes.func_197872_a((VoxelShape)shapes[i], (VoxelShape)SE_VS);
        }
        return shapes;
    }

    public TableBlock(AbstractBlock.Properties builder) {
        super(builder);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)NW, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)NE, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SW, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SE, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{NW, NE, SE, SW, WATERLOGGED});
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : Fluids.field_204541_a.func_207188_f();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        int i = ((Boolean)state.func_177229_b((Property)NW) != false ? 1 : 0) + ((Boolean)state.func_177229_b((Property)NE) != false ? 2 : 0) + ((Boolean)state.func_177229_b((Property)SW) != false ? 4 : 0) + ((Boolean)state.func_177229_b((Property)SE) != false ? 8 : 0);
        return this.shapes[i];
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        World iblockreader = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        FluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)this.getState(this.func_176223_P(), (IBlockReader)iblockreader, blockpos).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    public BlockState getState(BlockState state, IBlockReader worldIn, BlockPos pos) {
        int n = 0;
        boolean nw = false;
        boolean ne = false;
        boolean se = false;
        boolean sw = false;
        for (int i = 0; i < 4; ++i) {
            Direction facing = Direction.func_176731_b((int)i);
            if (worldIn.func_180495_p(pos.func_177972_a(facing)).func_177230_c() != this) continue;
            n = (int)((double)n + Math.pow(2.0, i));
        }
        switch (n) {
            case 0: {
                sw = true;
                se = true;
                ne = true;
                nw = true;
                break;
            }
            case 3: {
                ne = true;
                break;
            }
            case 6: {
                se = true;
                break;
            }
            case 12: {
                sw = true;
                break;
            }
            case 9: {
                nw = true;
                break;
            }
            case 1: {
                ne = true;
                nw = true;
                break;
            }
            case 2: {
                se = true;
                ne = true;
                break;
            }
            case 4: {
                sw = true;
                se = true;
                break;
            }
            case 8: {
                sw = true;
                nw = true;
            }
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)NW, (Comparable)Boolean.valueOf(nw))).func_206870_a((Property)NE, (Comparable)Boolean.valueOf(ne))).func_206870_a((Property)SE, (Comparable)Boolean.valueOf(se))).func_206870_a((Property)SW, (Comparable)Boolean.valueOf(sw));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return this.getState(stateIn, (IBlockReader)worldIn, currentPos);
    }
}

