/*
 * Decompiled with CFR 0.152.
 */
package de.guntram.mcmod.clickthrough;

import de.guntram.mcmod.fabrictools.ConfigChangedEvent;
import de.guntram.mcmod.fabrictools.Configuration;
import de.guntram.mcmod.fabrictools.ModConfigurationHandler;
import java.io.File;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class ConfigurationHandler
implements ModConfigurationHandler {
    private static ConfigurationHandler instance;
    private Configuration config;
    private String configFileName;
    private boolean sneakToDyeSigns;
    private Pattern[] compiledPatterns = new Pattern[4];
    private String[] patterns = new String[4];
    private static final String[] defaultPatterns;

    public static ConfigurationHandler getInstance() {
        if (instance == null) {
            instance = new ConfigurationHandler();
        }
        return instance;
    }

    private ConfigurationHandler() {
    }

    public void load(File configFile) {
        if (this.config == null) {
            this.config = new Configuration(configFile);
            this.configFileName = configFile.getPath();
            this.loadConfig();
        }
    }

    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("clickthrough")) {
            this.loadConfig();
        }
    }

    private void loadConfig() {
        this.sneakToDyeSigns = this.config.getBoolean("clickthrough.config.sneaktodye", 0, true, "clickthrough.config.tt.sneaktodye");
        for (int i = 0; i < 4; ++i) {
            this.patterns[i] = this.config.getString("clickthrough.config.ignore." + (i + 1), 0, defaultPatterns[i], "clickthrough.config.tt.ignore." + (i + 1));
            try {
                if (this.patterns[i].isEmpty()) {
                    this.compiledPatterns[i] = null;
                    continue;
                }
                this.compiledPatterns[i] = Pattern.compile(this.patterns[i], 2);
                continue;
            }
            catch (PatternSyntaxException ex) {
                System.out.println("Pattern syntax exception with Pattern '" + this.patterns[i] + "' " + ex.getMessage());
                this.compiledPatterns[i] = null;
            }
        }
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    public Configuration getConfig() {
        return this.config;
    }

    public static String getConfigFileName() {
        return ConfigurationHandler.getInstance().configFileName;
    }

    public static boolean getSneakToDyeSigns() {
        return ConfigurationHandler.getInstance().sneakToDyeSigns;
    }

    public static Pattern getIgnorePattern(int row) {
        return ConfigurationHandler.getInstance().compiledPatterns[row];
    }

    static {
        defaultPatterns = new String[]{"\\[buy\\]|\\[sell\\]|\\[shop\\]", "", "b\\s*\\d+|b\\s*\\d+\\s*:\\s*\\d+\\s*s|\\d+\\s*s", ""};
    }
}

