/*
 * Decompiled with CFR 0.152.
 */
package cofh.core;

import cofh.core.capability.CapabilityArchery;
import cofh.core.capability.CapabilityAreaEffect;
import cofh.core.capability.CapabilityEnchantableItem;
import cofh.core.capability.CapabilityShieldItem;
import cofh.core.command.CoFHCommand;
import cofh.core.event.AttributeEvents;
import cofh.core.init.CoreBlocks;
import cofh.core.init.CoreConfig;
import cofh.core.init.CoreEffects;
import cofh.core.init.CoreFluids;
import cofh.core.init.CoreItems;
import cofh.core.key.CoreKeys;
import cofh.core.network.PacketHandler;
import cofh.core.network.packet.client.IndexedChatPacket;
import cofh.core.network.packet.client.TileControlPacket;
import cofh.core.network.packet.client.TileGuiPacket;
import cofh.core.network.packet.client.TileRedstonePacket;
import cofh.core.network.packet.client.TileStatePacket;
import cofh.core.network.packet.server.ContainerPacket;
import cofh.core.network.packet.server.ItemModeChangePacket;
import cofh.core.network.packet.server.RedstoneControlPacket;
import cofh.core.network.packet.server.SecurityControlPacket;
import cofh.core.network.packet.server.SecurityPacket;
import cofh.core.network.packet.server.SideConfigPacket;
import cofh.core.network.packet.server.StorageClearPacket;
import cofh.core.network.packet.server.TileConfigPacket;
import cofh.core.network.packet.server.TransferControlPacket;
import cofh.core.registries.DeferredRegisterCoFH;
import cofh.core.util.Proxy;
import cofh.core.util.ProxyClient;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.block.Block;
import net.minecraft.command.CommandSource;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.Effect;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="cofh_core")
public class CoFHCore {
    public static final Logger LOG = LogManager.getLogger((String)"cofh_core");
    public static final PacketHandler PACKET_HANDLER = new PacketHandler(new ResourceLocation("cofh_core", "general"));
    public static final Proxy PROXY = (Proxy)DistExecutor.runForDist(() -> ProxyClient::new, () -> Proxy::new);
    public static final DeferredRegisterCoFH<Block> BLOCKS = new DeferredRegisterCoFH(ForgeRegistries.BLOCKS, "cofh_core");
    public static final DeferredRegisterCoFH<Fluid> FLUIDS = new DeferredRegisterCoFH(ForgeRegistries.FLUIDS, "cofh_core");
    public static final DeferredRegisterCoFH<Effect> EFFECTS = new DeferredRegisterCoFH(ForgeRegistries.POTIONS, "cofh_core");
    public static final DeferredRegisterCoFH<Item> ITEMS = new DeferredRegisterCoFH(ForgeRegistries.ITEMS, "cofh_core");
    public static final DeferredRegisterCoFH<ParticleType<?>> PARTICLES = new DeferredRegisterCoFH(ForgeRegistries.PARTICLE_TYPES, "cofh_core");
    public static final DeferredRegisterCoFH<TileEntityType<?>> TILE_ENTITIES = new DeferredRegisterCoFH(ForgeRegistries.TILE_ENTITIES, "cofh_core");

    public CoFHCore() {
        this.registerPackets();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        MinecraftForge.EVENT_BUS.addListener(this::serverStarting);
        BLOCKS.register(modEventBus);
        FLUIDS.register(modEventBus);
        EFFECTS.register(modEventBus);
        ITEMS.register(modEventBus);
        TILE_ENTITIES.register(modEventBus);
        CoreConfig.register();
        CoreBlocks.register();
        CoreFluids.register();
        CoreEffects.register();
        CoreItems.register();
    }

    private void registerPackets() {
        PACKET_HANDLER.registerPacket(1, TileControlPacket::new);
        PACKET_HANDLER.registerPacket(2, TileGuiPacket::new);
        PACKET_HANDLER.registerPacket(3, TileRedstonePacket::new);
        PACKET_HANDLER.registerPacket(4, TileStatePacket::new);
        PACKET_HANDLER.registerPacket(16, IndexedChatPacket::new);
        PACKET_HANDLER.registerPacket(24, ContainerPacket::new);
        PACKET_HANDLER.registerPacket(25, SecurityPacket::new);
        PACKET_HANDLER.registerPacket(32, TileConfigPacket::new);
        PACKET_HANDLER.registerPacket(33, SecurityControlPacket::new);
        PACKET_HANDLER.registerPacket(34, RedstoneControlPacket::new);
        PACKET_HANDLER.registerPacket(35, TransferControlPacket::new);
        PACKET_HANDLER.registerPacket(36, SideConfigPacket::new);
        PACKET_HANDLER.registerPacket(37, StorageClearPacket::new);
        PACKET_HANDLER.registerPacket(64, ItemModeChangePacket::new);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        CapabilityAreaEffect.register();
        CapabilityArchery.register();
        CapabilityEnchantableItem.register();
        CapabilityShieldItem.register();
        AttributeEvents.setup();
    }

    private void clientSetup(FMLClientSetupEvent event) {
        CoreKeys.register();
    }

    private void serverStarting(FMLServerStartingEvent event) {
        CoFHCommand.initialize((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
    }
}

