/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.renderer.model;

import cofh.core.client.renderer.model.BakedQuadRetextured;
import cofh.core.util.helpers.MathHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.SimpleBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ModelUtils {
    private ModelUtils() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class WrappedBakedModelBuilder {
        private final List<BakedQuad> builderGeneralQuads = Lists.newArrayList();
        private final Map<Direction, List<BakedQuad>> builderFaceQuads = Maps.newEnumMap(Direction.class);
        private final ItemOverrideList builderItemOverrideList;
        private final boolean builderAmbientOcclusion;
        private TextureAtlasSprite builderTexture;
        private final boolean field_230187_f_;
        private final boolean builderGui3d;
        private final ItemCameraTransforms builderCameraTransforms;

        public WrappedBakedModelBuilder(IBakedModel model) {
            for (Direction direction : Direction.values()) {
                this.builderFaceQuads.put(direction, new ArrayList(model.func_200117_a(null, direction, MathHelper.RANDOM)));
            }
            this.builderItemOverrideList = model.func_188617_f();
            this.builderAmbientOcclusion = model.func_177555_b();
            this.builderTexture = model.func_177554_e();
            this.field_230187_f_ = model.func_230044_c_();
            this.builderGui3d = model.func_177556_c();
            this.builderCameraTransforms = model.func_177552_f();
        }

        public WrappedBakedModelBuilder addQuads(Map<Direction, BakedQuad> quad) {
            return this;
        }

        public WrappedBakedModelBuilder addFaceQuad(Direction facing, BakedQuad quad) {
            this.builderFaceQuads.get(facing).add(quad);
            return this;
        }

        public WrappedBakedModelBuilder addRetexturedQuad(Direction facing, TextureAtlasSprite textureIn) {
            this.addFaceQuad(facing, new BakedQuadRetextured(this.getQuads(facing).get(0), textureIn));
            return this;
        }

        public WrappedBakedModelBuilder addGeneralQuad(BakedQuad quad) {
            this.builderGeneralQuads.add(quad);
            return this;
        }

        public List<BakedQuad> getQuads(Direction facing) {
            return facing == null ? this.builderGeneralQuads : this.builderFaceQuads.get(facing);
        }

        public WrappedBakedModelBuilder setTexture(TextureAtlasSprite texture) {
            this.builderTexture = texture;
            return this;
        }

        public IBakedModel build() {
            if (this.builderTexture == null) {
                throw new RuntimeException("Missing particle!");
            }
            return new SimpleBakedModel(this.builderGeneralQuads, this.builderFaceQuads, this.builderAmbientOcclusion, this.field_230187_f_, this.builderGui3d, this.builderTexture, this.builderCameraTransforms, this.builderItemOverrideList);
        }
    }
}

