/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.datagen;

import cofh.core.registries.DeferredRegisterCoFH;
import cofh.core.util.FeatureManager;
import cofh.core.util.FeatureRecipeCondition;
import java.util.function.Consumer;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.criterion.EnchantmentPredicate;
import net.minecraft.advancements.criterion.EnterBlockTrigger;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.advancements.criterion.NBTPredicate;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.Block;
import net.minecraft.data.CookingRecipeBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;

public class RecipeProviderCoFH
extends RecipeProvider
implements IConditionBuilder {
    private final String modid;

    public RecipeProviderCoFH(DataGenerator generatorIn, String modid) {
        super(generatorIn);
        this.modid = modid;
    }

    protected void generateStorageRecipes(DeferredRegisterCoFH<Item> reg, Consumer<IFinishedRecipe> consumer, Item storage, Item individual) {
        String storageName = storage.getRegistryName().func_110623_a();
        String individualName = individual.getRegistryName().func_110623_a();
        ShapedRecipeBuilder.func_200470_a((IItemProvider)storage).func_200462_a(Character.valueOf('#'), (IItemProvider)individual).func_200472_a("###").func_200472_a("###").func_200472_a("###").func_200465_a("has_at_least_9_" + individualName, (ICriterionInstance)this.hasItem(MinMaxBounds.IntBound.func_211340_b((int)9), (IItemProvider)individual)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)individual, (int)9).func_200487_b((IItemProvider)storage).func_200483_a("has_at_least_9_" + individualName, (ICriterionInstance)this.hasItem(MinMaxBounds.IntBound.func_211340_b((int)9), (IItemProvider)individual)).func_200483_a("has_" + storageName, (ICriterionInstance)this.func_200403_a((IItemProvider)storage)).func_200484_a(consumer, this.modid + ":" + individualName + "_from_block");
    }

    protected void generateStorageRecipes(DeferredRegisterCoFH<Item> reg, Consumer<IFinishedRecipe> consumer, String type) {
        String ingotName;
        Item block = reg.get(type + "_block");
        Item ingot = reg.get(type + "_ingot");
        Item gem = reg.get(type + "_gem");
        Item nugget = reg.get(type + "_nugget");
        if (block != null) {
            String blockName = block.getRegistryName().func_110623_a();
            if (ingot != null) {
                ingotName = ingot.getRegistryName().func_110623_a();
                ShapedRecipeBuilder.func_200470_a((IItemProvider)block).func_200462_a(Character.valueOf('#'), (IItemProvider)ingot).func_200472_a("###").func_200472_a("###").func_200472_a("###").func_200465_a("has_at_least_9_" + ingotName, (ICriterionInstance)this.hasItem(MinMaxBounds.IntBound.func_211340_b((int)9), (IItemProvider)ingot)).func_200464_a(consumer);
                ShapelessRecipeBuilder.func_200488_a((IItemProvider)ingot, (int)9).func_200487_b((IItemProvider)block).func_200483_a("has_at_least_9_" + ingotName, (ICriterionInstance)this.hasItem(MinMaxBounds.IntBound.func_211340_b((int)9), (IItemProvider)ingot)).func_200483_a("has_" + blockName, (ICriterionInstance)this.func_200403_a((IItemProvider)block)).func_200484_a(consumer, this.modid + ":" + ingotName + "_from_block");
            } else if (gem != null) {
                String gemName = gem.getRegistryName().func_110623_a();
                ShapedRecipeBuilder.func_200470_a((IItemProvider)block).func_200462_a(Character.valueOf('#'), (IItemProvider)gem).func_200472_a("###").func_200472_a("###").func_200472_a("###").func_200465_a("has_at_least_9_" + gemName, (ICriterionInstance)this.hasItem(MinMaxBounds.IntBound.func_211340_b((int)9), (IItemProvider)gem)).func_200464_a(consumer);
                ShapelessRecipeBuilder.func_200488_a((IItemProvider)gem, (int)9).func_200487_b((IItemProvider)block).func_200483_a("has_at_least_9_" + gemName, (ICriterionInstance)this.hasItem(MinMaxBounds.IntBound.func_211340_b((int)9), (IItemProvider)gem)).func_200483_a("has_" + blockName, (ICriterionInstance)this.func_200403_a((IItemProvider)block)).func_200484_a(consumer, this.modid + ":" + gemName + "_from_block");
            }
        }
        if (nugget != null) {
            String nuggetName = nugget.getRegistryName().func_110623_a();
            if (ingot != null) {
                ingotName = ingot.getRegistryName().func_110623_a();
                ShapedRecipeBuilder.func_200470_a((IItemProvider)ingot).func_200462_a(Character.valueOf('#'), (IItemProvider)nugget).func_200472_a("###").func_200472_a("###").func_200472_a("###").func_200465_a("has_at_least_9_" + nuggetName, (ICriterionInstance)this.hasItem(MinMaxBounds.IntBound.func_211340_b((int)9), (IItemProvider)nugget)).func_200466_a(consumer, this.modid + ":" + ingotName + "_from_nuggets");
                ShapelessRecipeBuilder.func_200488_a((IItemProvider)nugget, (int)9).func_200487_b((IItemProvider)ingot).func_200483_a("has_at_least_9_" + nuggetName, (ICriterionInstance)this.hasItem(MinMaxBounds.IntBound.func_211340_b((int)9), (IItemProvider)nugget)).func_200483_a("has_" + ingotName, (ICriterionInstance)this.func_200403_a((IItemProvider)ingot)).func_200484_a(consumer, this.modid + ":" + nuggetName + "_from_ingot");
            }
        }
        this.generateGearRecipe(reg, consumer, type);
    }

    protected void generateGearRecipe(DeferredRegisterCoFH<Item> reg, Consumer<IFinishedRecipe> consumer, String type) {
        Item gear = reg.get(type + "_gear");
        if (gear == null) {
            return;
        }
        Item ingot = reg.get(type + "_ingot");
        Item gem = reg.get(type + "_gem");
        Tag<Item> ingotTag = RecipeProviderCoFH.forgeTag("ingots/" + type);
        Tag<Item> gemTag = RecipeProviderCoFH.forgeTag("gems/" + type);
        if (ingot != null) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)gear).func_200469_a(Character.valueOf('#'), ingotTag).func_200469_a(Character.valueOf('i'), Tags.Items.NUGGETS_IRON).func_200472_a(" # ").func_200472_a("#i#").func_200472_a(" # ").func_200465_a("has_" + ingot.getRegistryName().func_110623_a(), (ICriterionInstance)this.func_200409_a(ingotTag)).func_200464_a(consumer);
        }
        if (gem != null) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)gear).func_200469_a(Character.valueOf('#'), gemTag).func_200469_a(Character.valueOf('i'), Tags.Items.NUGGETS_IRON).func_200472_a(" # ").func_200472_a("#i#").func_200472_a(" # ").func_200465_a("has_" + gem.getRegistryName().func_110623_a(), (ICriterionInstance)this.func_200409_a(gemTag)).func_200464_a(consumer);
        }
    }

    protected void generateGearRecipe(Consumer<IFinishedRecipe> consumer, Item gear, Item material, Tag<Item> tag) {
        if (gear == null || material == null || tag == null) {
            return;
        }
        ShapedRecipeBuilder.func_200470_a((IItemProvider)gear).func_200469_a(Character.valueOf('#'), tag).func_200469_a(Character.valueOf('i'), Tags.Items.NUGGETS_IRON).func_200472_a(" # ").func_200472_a("#i#").func_200472_a(" # ").func_200465_a("has_" + material.getRegistryName().func_110623_a(), (ICriterionInstance)this.func_200409_a(tag)).func_200464_a(consumer);
    }

    protected void generateSmeltingAndBlastingRecipes(DeferredRegisterCoFH<Item> reg, Consumer<IFinishedRecipe> consumer, String type, float xp) {
        Item ore = reg.get(type + "_ore");
        Item ingot = reg.get(type + "_ingot");
        Item gem = reg.get(type + "_gem");
        Item nugget = reg.get(type + "_nugget");
        Item dust = reg.get(type + "_dust");
        if (ingot != null) {
            String ingotName = ingot.getRegistryName().func_110623_a();
            if (dust != null) {
                String dustName = dust.getRegistryName().func_110623_a();
                CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{dust}), (IItemProvider)ingot, (float)0.0f, (int)200).func_218628_a("has_" + dustName, (ICriterionInstance)this.func_200403_a((IItemProvider)dust)).func_218632_a(consumer, this.modid + ":" + ingotName + "_from_dust_smelting");
                CookingRecipeBuilder.func_218633_b((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{dust}), (IItemProvider)ingot, (float)0.0f, (int)100).func_218628_a("has_" + dustName, (ICriterionInstance)this.func_200403_a((IItemProvider)dust)).func_218632_a(consumer, this.modid + ":" + ingotName + "_from_dust_blasting");
            }
            if (ore != null) {
                String oreName = ore.getRegistryName().func_110623_a();
                CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ore}), (IItemProvider)ingot, (float)xp, (int)200).func_218628_a("has_" + oreName, (ICriterionInstance)this.func_200403_a((IItemProvider)ore)).func_218632_a(consumer, this.modid + ":" + ingotName + "_from_ore_smelting");
                CookingRecipeBuilder.func_218633_b((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ore}), (IItemProvider)ingot, (float)xp, (int)100).func_218628_a("has_" + oreName, (ICriterionInstance)this.func_200403_a((IItemProvider)ore)).func_218632_a(consumer, this.modid + ":" + ingotName + "_from_ore_blasting");
            }
        } else if (gem != null) {
            String gemName = gem.getRegistryName().func_110623_a();
            if (ore != null) {
                String oreName = ore.getRegistryName().func_110623_a();
                CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ore}), (IItemProvider)gem, (float)xp, (int)200).func_218628_a("has_" + oreName, (ICriterionInstance)this.func_200403_a((IItemProvider)ore)).func_218632_a(consumer, gemName + "_from_ore_smelting");
                CookingRecipeBuilder.func_218633_b((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ore}), (IItemProvider)gem, (float)xp, (int)100).func_218628_a("has_" + oreName, (ICriterionInstance)this.func_200403_a((IItemProvider)ore)).func_218632_a(consumer, gemName + "_from_ore_blasting");
            }
        }
    }

    protected void generateSmeltingAndBlastingRecipes(DeferredRegisterCoFH<Item> reg, Consumer<IFinishedRecipe> consumer, Item input, Item output, float xp) {
        this.generateSmeltingAndBlastingRecipes(reg, consumer, input, output, xp, "");
    }

    protected void generateSmeltingAndBlastingRecipes(DeferredRegisterCoFH<Item> reg, Consumer<IFinishedRecipe> consumer, Item input, Item output, float xp, String type) {
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{input}), (IItemProvider)output, (float)xp, (int)200).func_218628_a("has_" + input.getRegistryName().func_110623_a(), (ICriterionInstance)this.func_200403_a((IItemProvider)input)).func_218632_a(consumer, this.modid + ":" + output.getRegistryName().func_110623_a() + "_from" + type + "_smelting");
        CookingRecipeBuilder.func_218633_b((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{input}), (IItemProvider)output, (float)xp, (int)100).func_218628_a("has_" + input.getRegistryName().func_110623_a(), (ICriterionInstance)this.func_200403_a((IItemProvider)input)).func_218632_a(consumer, this.modid + ":" + output.getRegistryName().func_110623_a() + "_from" + type + "_blasting");
    }

    public EnterBlockTrigger.Instance func_200407_a(Block blockIn) {
        return new EnterBlockTrigger.Instance(blockIn, StatePropertiesPredicate.field_227178_a_);
    }

    public InventoryChangeTrigger.Instance func_200403_a(IItemProvider itemIn) {
        return this.func_200405_a(ItemPredicate.Builder.func_200309_a().func_200308_a(itemIn).func_200310_b());
    }

    public InventoryChangeTrigger.Instance func_200409_a(Tag<Item> tagIn) {
        return this.func_200405_a(ItemPredicate.Builder.func_200309_a().func_200307_a(tagIn).func_200310_b());
    }

    public InventoryChangeTrigger.Instance func_200405_a(ItemPredicate ... predicates) {
        return new InventoryChangeTrigger.Instance(MinMaxBounds.IntBound.field_211347_e, MinMaxBounds.IntBound.field_211347_e, MinMaxBounds.IntBound.field_211347_e, predicates);
    }

    public InventoryChangeTrigger.Instance hasItem(MinMaxBounds.IntBound amount, IItemProvider itemIn) {
        return this.func_200405_a(new ItemPredicate(null, itemIn.func_199767_j(), amount, MinMaxBounds.IntBound.field_211347_e, EnchantmentPredicate.field_226534_b_, EnchantmentPredicate.field_226534_b_, null, NBTPredicate.field_193479_a));
    }

    protected static Tag<Item> forgeTag(String name) {
        return new ItemTags.Wrapper(new ResourceLocation("forge", name));
    }

    protected ICondition flagEnabled(FeatureManager manager, String flag) {
        return new FeatureRecipeCondition(manager, flag);
    }
}

