/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.entity;

import cofh.core.entity.AbstractMinecartEntityCoFH;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class AbstractTNTMinecartEntity
extends AbstractMinecartEntityCoFH {
    protected static final int CLOUD_DURATION = 20;
    protected int radius = 8;
    protected int fuse = -1;
    protected boolean detonated = false;

    public AbstractTNTMinecartEntity(EntityType<?> type, World worldIn) {
        super(type, worldIn);
    }

    public AbstractTNTMinecartEntity(EntityType<?> type, World worldIn, double posX, double posY, double posZ) {
        super(type, worldIn, posX, posY, posZ);
    }

    public BlockState func_180457_u() {
        return this.getBlock().func_176223_P();
    }

    public void func_70071_h_() {
        double d0;
        super.func_70071_h_();
        if (this.fuse > 0) {
            --this.fuse;
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.func_226277_ct_(), this.func_226278_cu_() + 0.5, this.func_226281_cx_(), 0.0, 0.0, 0.0);
        } else if (this.fuse == 0) {
            this.explodeCart(AbstractTNTMinecartEntity.func_213296_b((Vec3d)this.func_213322_ci()));
        }
        if (this.field_70123_F && (d0 = AbstractTNTMinecartEntity.func_213296_b((Vec3d)this.func_213322_ci())) >= (double)0.01f) {
            this.explodeCart(d0);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        AbstractArrowEntity abstractarrowentity;
        Entity entity = source.func_76364_f();
        if (entity instanceof AbstractArrowEntity && (abstractarrowentity = (AbstractArrowEntity)entity).func_70027_ad()) {
            this.explodeCart(abstractarrowentity.func_213322_ci().func_189985_c());
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    public void func_94095_a(DamageSource source) {
        double d0 = AbstractTNTMinecartEntity.func_213296_b((Vec3d)this.func_213322_ci());
        if (!(source.func_76347_k() || source.func_94541_c() || d0 >= (double)0.01f)) {
            super.func_94095_a(source);
            if (!source.func_94541_c() && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                this.func_199703_a((IItemProvider)this.getBlock());
            }
        } else if (this.fuse < 0) {
            this.ignite();
            this.fuse = this.field_70146_Z.nextInt(20) + this.field_70146_Z.nextInt(20);
        }
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        if (distance >= 3.0f) {
            float f = distance / 10.0f;
            this.explodeCart(f * f);
        }
        return super.func_225503_b_(distance, damageMultiplier);
    }

    public void func_96095_a(int x, int y, int z, boolean receivingPower) {
        if (receivingPower && this.fuse < 0) {
            this.ignite();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.ignite();
        } else {
            super.func_70103_a(id);
        }
    }

    public float func_180428_a(Explosion explosionIn, IBlockReader worldIn, BlockPos pos, BlockState blockStateIn, IFluidState p_180428_5_, float p_180428_6_) {
        return !this.isIgnited() || !blockStateIn.func_203425_a(BlockTags.field_203437_y) && !worldIn.func_180495_p(pos.func_177984_a()).func_203425_a(BlockTags.field_203437_y) ? super.func_180428_a(explosionIn, worldIn, pos, blockStateIn, p_180428_5_, p_180428_6_) : 0.0f;
    }

    public boolean func_174816_a(Explosion explosionIn, IBlockReader worldIn, BlockPos pos, BlockState blockStateIn, float p_174816_5_) {
        return (!this.isIgnited() || !blockStateIn.func_203425_a(BlockTags.field_203437_y) && !worldIn.func_180495_p(pos.func_177984_a()).func_203425_a(BlockTags.field_203437_y)) && super.func_174816_a(explosionIn, worldIn, pos, blockStateIn, p_174816_5_);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("Fuse", 99)) {
            this.fuse = compound.func_74762_e("Fuse");
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Fuse", this.fuse);
    }

    public AbstractMinecartEntity.Type func_184264_v() {
        return AbstractMinecartEntity.Type.TNT;
    }

    public void ignite() {
        this.fuse = 80;
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)10);
            if (!this.func_174814_R()) {
                this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187904_gd, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    public int getFuseTicks() {
        return this.fuse;
    }

    public boolean isIgnited() {
        return this.fuse > -1;
    }

    public abstract Block getBlock();

    protected void explodeCart(double speed) {
        double d0 = Math.sqrt(speed);
        if (d0 > 5.0) {
            d0 = 5.0;
        }
        this.radius = (int)((double)this.radius + (double)((int)this.field_70170_p.field_73012_v.nextDouble()) * 1.5 * d0);
        this.detonated = true;
        this.explode();
    }

    protected abstract void explode();
}

