/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.event;

import cofh.core.init.CoreAttributes;
import cofh.core.util.references.CoreReferences;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cofh_core")
public class AttributeEvents {
    private static final Set<String> STING_DAMAGE_TYPES = new ObjectOpenHashSet();
    private static final Set<String> HAZARD_DAMAGE_TYPES = new ObjectOpenHashSet();
    private static final Set<Effect> HAZARD_EFFECTS = new ObjectOpenHashSet();

    private AttributeEvents() {
    }

    @SubscribeEvent
    public static void handleEntityConstructingEvent(EntityEvent.EntityConstructing event) {
        if (event.getEntity() instanceof LivingEntity) {
            ((LivingEntity)event.getEntity()).func_110140_aT().func_111150_b(CoreAttributes.FALL_DISTANCE);
            ((LivingEntity)event.getEntity()).func_110140_aT().func_111150_b(CoreAttributes.HAZARD_RESISTANCE);
            ((LivingEntity)event.getEntity()).func_110140_aT().func_111150_b(CoreAttributes.STING_RESISTANCE);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleLivingAttackEvent(LivingAttackEvent event) {
        double stingRes;
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        DamageSource source = event.getSource();
        float amount = event.getAmount();
        double hazRes = entity.func_110148_a(CoreAttributes.HAZARD_RESISTANCE).func_111126_e();
        if (hazRes > 0.0 && (source.func_76347_k() || HAZARD_DAMAGE_TYPES.contains(source.func_76355_l())) && entity.func_70681_au().nextDouble() < hazRes) {
            entity.func_70066_B();
            AttributeEvents.attemptDamageArmor((Entity)entity, amount);
            event.setCanceled(true);
        }
        if ((stingRes = entity.func_110148_a(CoreAttributes.STING_RESISTANCE).func_111126_e()) > 0.0 && STING_DAMAGE_TYPES.contains(source.func_76355_l()) && entity.func_70681_au().nextDouble() < stingRes) {
            AttributeEvents.attemptDamageArmor((Entity)entity, amount);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleLivingFallEvent(LivingFallEvent event) {
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        double fallMod = entity.func_110148_a(CoreAttributes.FALL_DISTANCE).func_111126_e();
        if (fallMod != 0.0) {
            event.setDistance(Math.max(0.0f, event.getDistance() - (float)fallMod));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handlePotionApplicableEvent(PotionEvent.PotionApplicableEvent event) {
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        EffectInstance effect = event.getPotionEffect();
        double hazRes = entity.func_110148_a(CoreAttributes.HAZARD_RESISTANCE).func_111126_e();
        if (hazRes > 0.0 && HAZARD_EFFECTS.contains(effect.func_188419_a()) && entity.func_70681_au().nextDouble() < hazRes) {
            AttributeEvents.attemptDamageArmor((Entity)entity, (float)((1 + effect.func_76458_c()) * effect.func_76459_b()) / 40.0f);
            event.setResult(Event.Result.DENY);
        }
    }

    public static void attemptDamageArmor(Entity entity, float amount) {
        if (entity instanceof PlayerEntity && 100.0f * entity.field_70170_p.field_73012_v.nextFloat() < amount) {
            ((PlayerEntity)entity).field_71071_by.func_70449_g(Math.min(20.0f, amount));
        }
    }

    public static void setup() {
        STING_DAMAGE_TYPES.add("sting");
        STING_DAMAGE_TYPES.add("cactus");
        STING_DAMAGE_TYPES.add("sweetBerryBush");
        HAZARD_DAMAGE_TYPES.add("lightningBolt");
        HAZARD_DAMAGE_TYPES.add("cold");
        HAZARD_DAMAGE_TYPES.add("lightning");
        HAZARD_EFFECTS.add(Effects.field_76436_u);
        HAZARD_EFFECTS.add(Effects.field_82731_v);
        HAZARD_EFFECTS.add(CoreReferences.CHILLED);
        HAZARD_EFFECTS.add(CoreReferences.SHOCKED);
    }
}

