/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.fluid;

import cofh.core.fluid.FluidStorageCoFH;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidStorageInfinite
extends FluidStorageCoFH {
    public FluidStorageInfinite(int capacity) {
        super(capacity);
    }

    public FluidStorageInfinite(int capacity, Predicate<FluidStack> validator) {
        super(capacity, validator);
    }

    @Override
    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !resource.isFluidEqual(this.fluid)) {
            return FluidStack.EMPTY;
        }
        return this.drain(resource.getAmount(), action);
    }

    @Override
    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (maxDrain <= 0 || this.fluid.isEmpty()) {
            return FluidStack.EMPTY;
        }
        int retAmount = Math.min(this.fluid.getAmount(), maxDrain);
        return new FluidStack(this.fluid, retAmount);
    }
}

